/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.opencastproject.elasticsearch.api.Language;
import org.opencastproject.elasticsearch.api.SearchMetadata;

public final class ElasticsearchDocument
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2687550418831284487L;
    private String id = null;
    private String type = null;

    public ElasticsearchDocument(String id, String type, List<SearchMetadata<?>> resource) {
        this.id = id;
        this.type = type;
        for (SearchMetadata<?> entry : resource) {
            String metadataKey = entry.getName();
            this.put(metadataKey, entry.getValues());
            if (!entry.addToText()) continue;
            this.addToFulltext(entry, "text", "text");
        }
    }

    public String getType() {
        return this.type;
    }

    private void addToFulltext(SearchMetadata<?> item, String fulltextFieldName, String localizedFulltextFieldName) {
        ArrayList<String> fulltext = (ArrayList<String>)this.get(fulltextFieldName);
        if (fulltext == null) {
            fulltext = new ArrayList<String>();
            this.put(fulltextFieldName, fulltext);
            this.put(fulltextFieldName + "_fuzzy", fulltext);
        }
        for (Object value : item.getValues()) {
            if (value.getClass().isArray()) {
                Object[] fieldValues;
                for (Object v : fieldValues = (Object[])value) {
                    fulltext.add(v.toString());
                }
                continue;
            }
            fulltext.add(value.toString());
        }
        for (Language language : item.getLocalizedValues().keySet()) {
            String localizedFieldName = MessageFormat.format(localizedFulltextFieldName, language.getIdentifier());
            Collection localizedFulltext = (Collection)this.get(localizedFieldName);
            if (fulltext == null) {
                fulltext = new ArrayList();
                this.put(localizedFieldName, fulltext);
            }
            Collection values = (Collection)item.getLocalizedValues().get(language);
            for (Object value : values) {
                if (value.getClass().isArray()) {
                    Object[] fieldValues;
                    for (Object v : fieldValues = (Object[])value) {
                        localizedFulltext.add(v.toString());
                    }
                    continue;
                }
                localizedFulltext.add(value.toString());
            }
        }
    }

    public String getUID() {
        return this.id;
    }
}

