/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.elasticsearch.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.opencastproject.elasticsearch.api.SearchQuery;
import org.opencastproject.util.DateTimeSupport;

public abstract class AbstractElasticsearchQueryBuilder<T extends SearchQuery>
implements QueryBuilder {
    private Map<String, Set<Object>> searchTerms = null;
    protected List<ValueGroup> groups = null;
    private Set<DateRange> dateRanges = null;
    protected String filter = null;
    protected String text = null;
    protected String fuzzyText = null;
    private T query;
    private QueryBuilder queryBuilder = null;

    public AbstractElasticsearchQueryBuilder(T query) {
        this.query = query;
        this.buildQuery(query);
        this.createQuery();
    }

    public T getQuery() {
        return this.query;
    }

    public abstract void buildQuery(T var1);

    private void createQuery() {
        this.queryBuilder = new MatchAllQueryBuilder();
        BoolQueryBuilder booleanQuery = new BoolQueryBuilder();
        if (this.searchTerms != null) {
            for (Map.Entry entry : this.searchTerms.entrySet()) {
                booleanQuery.must((QueryBuilder)new TermsQueryBuilder((String)entry.getKey(), ((Set)entry.getValue()).toArray(new Object[0])));
            }
            this.queryBuilder = booleanQuery;
        }
        if (this.dateRanges != null) {
            for (DateRange dateRange : this.dateRanges) {
                booleanQuery.must(dateRange.getQueryBuilder());
            }
            this.queryBuilder = booleanQuery;
        }
        if (this.text != null) {
            QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)this.text).field("text");
            booleanQuery.must((QueryBuilder)queryBuilder);
            this.queryBuilder = booleanQuery;
        }
        if (this.fuzzyText != null) {
            MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((String[])new String[]{"text_fuzzy"}, (String[])new String[]{this.fuzzyText}, null);
            booleanQuery.must((QueryBuilder)moreLikeThisQueryBuilder);
            this.queryBuilder = booleanQuery;
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.groups != null) {
            for (ValueGroup valueGroup : this.groups) {
                filters.addAll(valueGroup.getFilterBuilders());
            }
        }
        if (this.filter != null) {
            filters.add(QueryBuilders.termQuery((String)"text", (String)this.filter));
        }
        if (!filters.isEmpty()) {
            for (QueryBuilder queryBuilder : filters) {
                booleanQuery.filter(queryBuilder);
            }
            this.queryBuilder = booleanQuery;
        }
    }

    protected void and(String fieldName, Object ... fieldValues) {
        if (this.searchTerms == null) {
            this.searchTerms = new HashMap<String, Set<Object>>();
        }
        fieldName = StringUtils.trim((String)fieldName);
        this.searchTerms.computeIfAbsent(fieldName, k -> new HashSet()).addAll(Arrays.asList(fieldValues));
    }

    protected void and(String fieldName, Date startDate, Date endDate) {
        fieldName = StringUtils.trim((String)fieldName);
        if (this.dateRanges == null) {
            this.dateRanges = new HashSet<DateRange>();
        }
        this.dateRanges.add(new DateRange(fieldName, startDate, endDate));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.queryBuilder.toXContent(builder, params);
    }

    public Query toQuery(QueryShardContext context) throws IOException {
        return this.queryBuilder.toQuery(context);
    }

    public QueryBuilder queryName(String queryName) {
        return this.queryBuilder.queryName(queryName);
    }

    public String queryName() {
        return this.queryBuilder.queryName();
    }

    public float boost() {
        return this.queryBuilder.boost();
    }

    public QueryBuilder boost(float boost) {
        return this.queryBuilder.boost(boost);
    }

    public String getName() {
        return this.queryBuilder.getName();
    }

    public String getWriteableName() {
        return this.queryBuilder.getWriteableName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.queryBuilder.writeTo(out);
    }

    public QueryBuilder rewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this.queryBuilder.rewrite(queryShardContext);
    }

    public boolean isFragment() {
        return this.queryBuilder.isFragment();
    }

    public static final class ValueGroup {
        private String field;
        private Object[] values;

        public ValueGroup(String field, Object ... values) {
            this.field = field;
            this.values = values;
        }

        List<QueryBuilder> getFilterBuilders() {
            return Arrays.stream(this.values).map(v -> QueryBuilders.termQuery((String)this.field, (String)v.toString())).collect(Collectors.toList());
        }

        public boolean equals(Object obj) {
            return obj instanceof ValueGroup && ((ValueGroup)obj).field.equals(this.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }

    public static final class DateRange {
        private String field;
        private Date startDate;
        private Date endDate;

        DateRange(String field, Date start, Date end) {
            this.field = field;
            this.startDate = start;
            this.endDate = end;
        }

        QueryBuilder getQueryBuilder() {
            RangeQueryBuilder rqb = new RangeQueryBuilder(this.field);
            if (this.startDate != null) {
                rqb.from((Object)DateTimeSupport.toUTC((long)this.startDate.getTime()));
            }
            if (this.endDate != null) {
                rqb.to((Object)DateTimeSupport.toUTC((long)this.endDate.getTime()));
            }
            return rqb;
        }

        public boolean equals(Object obj) {
            return obj instanceof DateRange && ((DateRange)obj).field.equals(this.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }
}

