/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial3d.Geo3DPointOutsideSortField;
import org.apache.lucene.spatial3d.Geo3DPointSortField;
import org.apache.lucene.spatial3d.Geo3DUtil;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoPath;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.PlanetModel;

public class Geo3DDocValuesField
extends Field {
    private final PlanetModel planetModel;
    public static final FieldType TYPE = new FieldType();

    public Geo3DDocValuesField(String name, GeoPoint point, PlanetModel planetModel) {
        this(name, TYPE, planetModel);
        this.setLocationValue(point);
    }

    public Geo3DDocValuesField(String name, double x, double y, double z, PlanetModel planetModel) {
        this(name, TYPE, planetModel);
        this.setLocationValue(x, y, z);
    }

    private Geo3DDocValuesField(String name, FieldType type, PlanetModel planetModel) {
        super(name, TYPE);
        this.planetModel = planetModel;
    }

    public void setLocationValue(GeoPoint point) {
        this.fieldsData = this.planetModel.getDocValueEncoder().encodePoint(point);
    }

    public void setLocationValue(double x, double y, double z) {
        this.fieldsData = this.planetModel.getDocValueEncoder().encodePoint(x, y, z);
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)TYPE.docValuesType()) + ", is the field really a Geo3DDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(this.planetModel.getDocValueEncoder().decodeXValue(currentValue));
        result.append(',');
        result.append(this.planetModel.getDocValueEncoder().decodeYValue(currentValue));
        result.append(',');
        result.append(this.planetModel.getDocValueEncoder().decodeZValue(currentValue));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, double latitude, double longitude, double maxRadiusMeters, PlanetModel planetModel) {
        GeoCircle shape = Geo3DUtil.fromDistance(planetModel, latitude, longitude, maxRadiusMeters);
        return new Geo3DPointSortField(field, planetModel, shape);
    }

    public static SortField newPathSort(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters, PlanetModel planetModel) {
        GeoPath shape = Geo3DUtil.fromPath(planetModel, pathLatitudes, pathLongitudes, pathWidthMeters);
        return new Geo3DPointSortField(field, planetModel, shape);
    }

    public static SortField newOutsideDistanceSort(String field, double latitude, double longitude, double maxRadiusMeters, PlanetModel planetModel) {
        GeoCircle shape = Geo3DUtil.fromDistance(planetModel, latitude, longitude, maxRadiusMeters);
        return new Geo3DPointOutsideSortField(field, planetModel, shape);
    }

    public static SortField newOutsideBoxSort(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude, PlanetModel planetModel) {
        GeoBBox shape = Geo3DUtil.fromBox(planetModel, minLatitude, maxLatitude, minLongitude, maxLongitude);
        return new Geo3DPointOutsideSortField(field, planetModel, shape);
    }

    public static SortField newOutsidePolygonSort(String field, PlanetModel planetModel, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromPolygon(planetModel, polygons);
        return new Geo3DPointOutsideSortField(field, planetModel, shape);
    }

    public static SortField newOutsideLargePolygonSort(String field, PlanetModel planetModel, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromLargePolygon(planetModel, polygons);
        return new Geo3DPointOutsideSortField(field, planetModel, shape);
    }

    public static SortField newOutsidePathSort(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters, PlanetModel planetModel) {
        GeoPath shape = Geo3DUtil.fromPath(planetModel, pathLatitudes, pathLongitudes, pathWidthMeters);
        return new Geo3DPointOutsideSortField(field, planetModel, shape);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

