/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor;

import com.entwinemedia.fn.data.Opt;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.editor.EditorLock;
import org.opencastproject.editor.api.EditingData;
import org.opencastproject.editor.api.EditorService;
import org.opencastproject.editor.api.EditorServiceException;
import org.opencastproject.editor.api.ErrorStatus;
import org.opencastproject.editor.api.LockData;
import org.opencastproject.editor.api.SegmentData;
import org.opencastproject.editor.api.TrackData;
import org.opencastproject.editor.api.TrackSubData;
import org.opencastproject.editor.api.WorkflowData;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.impl.util.EventUtils;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.attachment.AttachmentImpl;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.EventCatalogUIAdapter;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.security.urlsigning.utils.UrlSigningServiceOsgiUtil;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowUtil;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component(property={"service.description=Editor Service"}, immediate=true, service={EditorService.class})
public class EditorServiceImpl
implements EditorService {
    private static final Logger logger = LoggerFactory.getLogger(EditorServiceImpl.class);
    private static final String EDITOR_WORKFLOW_TAG = "editor";
    private static EditorLock editorLock;
    private long expireSeconds = 7200L;
    private Boolean signWithClientIP = UrlSigningServiceOsgiUtil.DEFAULT_SIGN_WITH_CLIENT_IP;
    private IndexService index;
    private AssetManager assetManager;
    private SecurityService securityService;
    private SmilService smilService;
    private UrlSigningService urlSigningService;
    private WorkflowService workflowService;
    private Workspace workspace;
    private AuthorizationService authorizationService;
    private MediaPackageElementFlavor smilCatalogFlavor;
    private String previewVideoSubtype;
    private String previewTag;
    private String previewSubtype;
    private String waveformSubtype;
    private String thumbnailSubType;
    private MediaPackageElementFlavor smilSilenceFlavor;
    private ElasticsearchIndex searchIndex;
    private MediaPackageElementFlavor captionsFlavor;
    private String thumbnailWfProperty;
    private List<MediaPackageElementFlavor> thumbnailSourcePrimary;
    private String distributionDirectory;
    private Boolean localPublication = null;
    private static final String DEFAULT_PREVIEW_SUBTYPE = "source";
    private static final String DEFAULT_PREVIEW_TAG = "editor";
    private static final String DEFAULT_WAVEFORM_SUBTYPE = "waveform";
    private static final String DEFAULT_SMIL_CATALOG_FLAVOR = "smil/cutting";
    private static final String DEFAULT_SMIL_CATALOG_TAGS = "archive";
    private static final String DEFAULT_SMIL_SILENCE_FLAVOR = "*/silence";
    private static final String DEFAULT_PREVIEW_VIDEO_SUBTYPE = "video+preview";
    private static final String DEFAULT_CAPTIONS_FLAVOR = "captions/*";
    private static final String DEFAULT_THUMBNAIL_SUBTYPE = "player+preview";
    private static final String DEFAULT_THUMBNAIL_WF_PROPERTY = "thumbnail_edited";
    private static final List<MediaPackageElementFlavor> DEFAULT_THUMBNAIL_PRIORITY_FLAVOR;
    private static final int DEFAULT_LOCK_TIMEOUT_SECONDS = 300;
    private static final int DEFAULT_LOCK_REFRESH_SECONDS = 60;
    public static final String OPT_PREVIEW_SUBTYPE = "preview.subtype";
    public static final String OPT_PREVIEW_TAG = "preview.tag";
    public static final String OPT_WAVEFORM_SUBTYPE = "waveform.subtype";
    public static final String OPT_SMIL_CATALOG_FLAVOR = "smil.catalog.flavor";
    public static final String OPT_SMIL_CATALOG_TAGS = "smil.catalog.tags";
    public static final String OPT_SMIL_SILENCE_FLAVOR = "smil.silence.flavor";
    public static final String OPT_PREVIEW_VIDEO_SUBTYPE = "preview.video.subtype";
    public static final String OPT_CAPTIONS_FLAVOR = "captions.flavor";
    public static final String OPT_THUMBNAILSUBTYPE = "thumbnail.subtype";
    public static final String OPT_THUMBNAIL_WF_PROPERTY = "thumbnail.workflow.property";
    public static final String OPT_THUMBNAIL_PRIORITY_FLAVOR = "thumbnail.priority.flavor";
    public static final String OPT_LOCAL_PUBLICATION = "publication.local";
    public static final String OPT_LOCK_ENABLED = "lock.enable";
    public static final String OPT_LOCK_TIMEOUT = "lock.release.after.seconds";
    public static final String OPT_LOCK_REFRESH = "lock.refresh.after.seconds";
    private Boolean lockingActive;
    private int lockRefresh = 60;
    private int lockTimeout = 300;
    private final Set<String> smilCatalogTagSet = new HashSet<String>();

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    @Reference
    void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Reference
    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    void setUrlSigningService(UrlSigningService urlSigningService) {
        this.urlSigningService = urlSigningService;
    }

    @Reference
    void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.searchIndex = elasticsearchIndex;
    }

    @Reference
    public void setIndexService(IndexService index) {
        this.index = index;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public MediaPackageElementFlavor getSmilCatalogFlavor() {
        return this.smilCatalogFlavor;
    }

    public Set<String> getSmilCatalogTags() {
        return this.smilCatalogTagSet;
    }

    public String getPreviewVideoSubtype() {
        return this.previewVideoSubtype;
    }

    public MediaPackageElementFlavor getSmilSilenceFlavor() {
        return this.smilSilenceFlavor;
    }

    private String getPreviewSubtype() {
        return this.previewSubtype;
    }

    public String getPreviewTag() {
        return this.previewTag;
    }

    private String getWaveformSubtype() {
        return this.waveformSubtype;
    }

    private String getThumbnailSubtype() {
        return this.thumbnailSubType;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        String storageDir;
        Dictionary properties = cc.getProperties();
        if (properties == null) {
            return;
        }
        this.expireSeconds = UrlSigningServiceOsgiUtil.getUpdatedSigningExpiration((Dictionary)properties, (String)this.getClass().getSimpleName());
        this.signWithClientIP = UrlSigningServiceOsgiUtil.getUpdatedSignWithClientIP((Dictionary)properties, (String)this.getClass().getSimpleName());
        this.previewTag = Objects.toString(properties.get(OPT_PREVIEW_TAG), "editor");
        logger.debug("Preview tag configuration set to '{}'", (Object)this.previewTag);
        this.previewSubtype = Objects.toString(properties.get(OPT_PREVIEW_SUBTYPE), DEFAULT_PREVIEW_SUBTYPE);
        logger.debug("Preview subtype configuration set to '{}'", (Object)this.previewSubtype);
        this.waveformSubtype = Objects.toString(properties.get(OPT_WAVEFORM_SUBTYPE), DEFAULT_WAVEFORM_SUBTYPE);
        logger.debug("Waveform subtype configuration set to '{}'", (Object)this.waveformSubtype);
        this.smilCatalogFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SMIL_CATALOG_FLAVOR)), (String)DEFAULT_SMIL_CATALOG_FLAVOR));
        logger.debug("Smil catalog flavor configuration set to '{}'", (Object)this.smilCatalogFlavor);
        String tags = Objects.toString(properties.get(OPT_SMIL_CATALOG_TAGS), DEFAULT_SMIL_CATALOG_TAGS);
        String[] smilCatalogTags = StringUtils.split((String)tags, (String)",");
        this.smilCatalogTagSet.clear();
        if (smilCatalogTags != null) {
            this.smilCatalogTagSet.addAll(Arrays.asList(smilCatalogTags));
        }
        this.smilSilenceFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_SMIL_SILENCE_FLAVOR)), (String)DEFAULT_SMIL_SILENCE_FLAVOR));
        logger.debug("Smil silence flavor configuration set to '{}'", (Object)this.smilSilenceFlavor);
        this.previewVideoSubtype = Objects.toString(properties.get(OPT_PREVIEW_VIDEO_SUBTYPE), DEFAULT_PREVIEW_VIDEO_SUBTYPE);
        logger.debug("Preview video subtype set to '{}'", (Object)this.previewVideoSubtype);
        this.captionsFlavor = MediaPackageElementFlavor.parseFlavor((String)StringUtils.defaultString((String)((String)properties.get(OPT_CAPTIONS_FLAVOR)), (String)DEFAULT_CAPTIONS_FLAVOR));
        logger.debug("Caption flavor set to '{}'", (Object)this.captionsFlavor);
        this.thumbnailSubType = Objects.toString(properties.get(OPT_THUMBNAILSUBTYPE), DEFAULT_THUMBNAIL_SUBTYPE);
        logger.debug("Thumbnail subtype set to '{}'", (Object)this.thumbnailSubType);
        this.thumbnailWfProperty = Objects.toString(properties.get(OPT_THUMBNAIL_WF_PROPERTY), DEFAULT_THUMBNAIL_WF_PROPERTY);
        logger.debug("Thumbnail workflow property set to '{}'", (Object)this.thumbnailWfProperty);
        String thumbnailPriorities = Objects.toString(properties.get(OPT_THUMBNAIL_PRIORITY_FLAVOR));
        this.thumbnailSourcePrimary = "null".equals(thumbnailPriorities) || thumbnailPriorities.isEmpty() ? DEFAULT_THUMBNAIL_PRIORITY_FLAVOR : Arrays.stream(thumbnailPriorities.split(",", -1)).map(MediaPackageElementFlavor::parseFlavor).collect(Collectors.toList());
        String localPublicationConfig = Objects.toString(properties.get(OPT_LOCAL_PUBLICATION), "auto");
        if (!"auto".equals(localPublicationConfig)) {
            this.localPublication = BooleanUtils.toBoolean((String)localPublicationConfig);
        }
        this.distributionDirectory = cc.getBundleContext().getProperty("org.opencastproject.download.directory");
        if (StringUtils.isEmpty((CharSequence)this.distributionDirectory) && StringUtils.isNotEmpty((CharSequence)(storageDir = cc.getBundleContext().getProperty("org.opencastproject.storage.dir")))) {
            this.distributionDirectory = new File(storageDir, "downloads").getPath();
        }
        logger.debug("Thumbnail track priority set to '{}'", this.thumbnailSourcePrimary);
        this.lockingActive = Boolean.parseBoolean(StringUtils.trimToEmpty((String)((String)properties.get(OPT_LOCK_ENABLED))));
        try {
            this.lockTimeout = Integer.parseUnsignedInt(Objects.toString(properties.get(OPT_LOCK_TIMEOUT)));
        }
        catch (NumberFormatException e) {
            logger.info("Configuration {} contains invalid value, defaulting to {}", (Object)OPT_LOCK_TIMEOUT, (Object)this.lockTimeout);
        }
        try {
            this.lockRefresh = Integer.parseUnsignedInt(Objects.toString(properties.get(OPT_LOCK_REFRESH)));
        }
        catch (NumberFormatException e) {
            logger.info("Configuration {} contains invalid value, defaulting to {}", (Object)OPT_LOCK_REFRESH, (Object)this.lockRefresh);
        }
        editorLock = new EditorLock(this.lockTimeout);
    }

    private boolean isLocal(URI uri) {
        String path = uri.normalize().getPath();
        if (!path.startsWith("/static/")) {
            return false;
        }
        File localFile = new File(this.distributionDirectory, path.substring("/static".length()));
        return localFile.exists();
    }

    private Boolean elementHasPreviewTag(MediaPackageElement element) {
        return element.getTags() != null && Arrays.asList(element.getTags()).contains(this.getPreviewTag());
    }

    private Boolean elementHasPreviewFlavor(MediaPackageElement element) {
        return element.getFlavor() != null && this.getPreviewSubtype().equals(element.getFlavor().getSubtype());
    }

    private Boolean elementHasWaveformFlavor(MediaPackageElement element) {
        return element.getFlavor() != null && this.getWaveformSubtype().equals(element.getFlavor().getSubtype());
    }

    private String signIfNecessary(URI uri) {
        if (!this.urlSigningService.accepts(uri.toString())) {
            return uri.toString();
        }
        String clientIP = this.signWithClientIP != false ? this.securityService.getUserIP() : null;
        try {
            return new URI(this.urlSigningService.sign(uri.toString(), Long.valueOf(this.expireSeconds), null, clientIP)).toString();
        }
        catch (URISyntaxException | UrlSigningException e) {
            throw new WebApplicationException(e, 500);
        }
    }

    Smil createSmilCuttingCatalog(EditingData editingInfo, MediaPackage mediaPackage) throws SmilException {
        SmilResponse smilResponse = this.smilService.createNewSmil(mediaPackage);
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (TrackData trackdata : editingInfo.getTracks()) {
            String trackId = trackdata.getId();
            Track track = mediaPackage.getTrack(trackId);
            if (track == null) {
                track = Arrays.stream(this.getInternalPublication(mediaPackage).orElseThrow(() -> new IllegalStateException("Event has no internal publication")).getTracks()).filter(t -> trackId.equals(t.getIdentifier())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("The track '%s' doesn't exist in media package '%s'", trackId, mediaPackage)));
            }
            tracks.add(track);
        }
        for (SegmentData segment : editingInfo.getSegments()) {
            smilResponse = this.smilService.addParallel(smilResponse.getSmil());
            String parentId = smilResponse.getEntity().getId();
            long duration = segment.getEnd() - segment.getStart();
            if (segment.isDeleted()) continue;
            smilResponse = this.smilService.addClips(smilResponse.getSmil(), parentId, tracks.toArray(new Track[0]), segment.getStart().longValue(), duration);
        }
        return smilResponse.getSmil();
    }

    MediaPackage addSmilToArchive(MediaPackage mediaPackage, Smil smil) throws IOException {
        URI smilURI;
        Catalog[] catalogs;
        MediaPackageElementFlavor mediaPackageElementFlavor = this.getSmilCatalogFlavor();
        String catalogId = smil.getId();
        for (Catalog p : catalogs = mediaPackage.getCatalogs()) {
            if (!p.getFlavor().matches(mediaPackageElementFlavor)) continue;
            logger.debug("Set Identifier for Smil-Catalog to: {}", (Object)p.getIdentifier());
            catalogId = p.getIdentifier();
            break;
        }
        Catalog catalog = mediaPackage.getCatalog(catalogId);
        try (InputStream is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");){
            smilURI = this.workspace.put(mediaPackage.getIdentifier().toString(), catalogId, "cut.smil", is);
        }
        catch (JAXBException | SAXException e) {
            throw new IOException("Error while serializing the SMIL catalog to XML", e);
        }
        if (catalog == null) {
            MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, this.getSmilCatalogFlavor());
            mediaPackage.add(catalog);
        }
        catalog.setURI(smilURI);
        catalog.setIdentifier(catalogId);
        catalog.setMimeType(MimeTypes.XML);
        for (String tag : this.getSmilCatalogTags()) {
            catalog.addTag(tag);
        }
        catalog.setChecksum(null);
        return mediaPackage;
    }

    private MediaPackage processSubtitleTrack(MediaPackage mediaPackage, List<EditingData.Subtitle> subtitles) throws IOException, IllegalArgumentException {
        for (EditingData.Subtitle subtitle : subtitles) {
            String subtitleId = UUID.randomUUID().toString();
            String trackId = null;
            for (Track t : mediaPackage.getTracks()) {
                if (!t.getIdentifier().matches(subtitle.getId())) continue;
                logger.debug("Set Identifier for Subtitle-Track to: {}", (Object)t.getIdentifier());
                subtitleId = t.getIdentifier();
                trackId = t.getIdentifier();
                break;
            }
            Track track = mediaPackage.getTrack(trackId);
            if (subtitle.isDeleted()) {
                if (trackId == null) continue;
                mediaPackage.remove(track);
                continue;
            }
            URI oldTrackURI = null;
            if (track != null) {
                oldTrackURI = track.getURI();
            }
            InputStream is = IOUtils.toInputStream((String)subtitle.getSubtitle(), (String)"UTF-8");
            try {
                URI subtitleUri = this.workspace.put(mediaPackage.getIdentifier().toString(), subtitleId, "subtitle.vtt", is);
                if (track == null) {
                    String[] mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
                    track = (Track)mpeBuilder.elementFromURI(subtitleUri, MediaPackageElement.Type.Track, new MediaPackageElementFlavor(this.captionsFlavor.getType(), DEFAULT_PREVIEW_SUBTYPE));
                    mediaPackage.add(track);
                    logger.info("Creating new subtitle track " + track.getIdentifier() + " with tags " + track.getTags().toString());
                }
                track.setURI(subtitleUri);
                track.setIdentifier(subtitleId);
                track.setChecksum(null);
                for (String tag : subtitle.getTags()) {
                    track.addTag(tag);
                }
                if (oldTrackURI == null || oldTrackURI == subtitleUri) continue;
                logger.info("Removing old track file {}", (Object)oldTrackURI);
                try {
                    this.workspace.delete(oldTrackURI);
                }
                catch (IOException | NotFoundException e) {
                    logger.info("Could not remove track from workspace. Could be it was never there.");
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return mediaPackage;
    }

    private MediaPackage addThumbnailsToArchive(EditingData editingData, MediaPackage mediaPackage) throws MimeTypeParseException, IOException {
        for (TrackData track : editingData.getTracks()) {
            String id = track.getId();
            MediaPackageElementFlavor flavor = new MediaPackageElementFlavor(track.getFlavor().getType(), this.getThumbnailSubtype());
            String uri = track.getThumbnailURI();
            if (uri == null || uri.isEmpty() || !uri.startsWith("data")) continue;
            uri = uri.substring(uri.indexOf(",") + 1);
            byte[] byteArray = Base64.getMimeDecoder().decode(uri);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
            String stringMimeType = this.detectMimeType(uri);
            MimeType mimeType = MimeType.mimeType((String)stringMimeType.split("/")[0], (String)stringMimeType.split("/")[1]);
            String filename = "thumbnail_" + id + "." + mimeType.getSubtype();
            String originalThumbnailId = UUID.randomUUID().toString();
            URI tempThumbnail = null;
            try {
                tempThumbnail = this.workspace.put(mediaPackage.getIdentifier().toString(), originalThumbnailId, filename, (InputStream)inputStream);
            }
            catch (IOException e) {
                throw new IOException("Could not add thumbnail to workspace", e);
            }
            Attachment attachment = AttachmentImpl.fromURI((URI)tempThumbnail);
            attachment.setFlavor(flavor);
            attachment.setMimeType(mimeType);
            Arrays.stream(mediaPackage.getElementsByFlavor(flavor)).map(MediaPackageElement::getTags).flatMap(Arrays::stream).distinct().forEach(arg_0 -> ((Attachment)attachment).addTag(arg_0));
            Arrays.stream(mediaPackage.getElementsByFlavor(flavor)).forEach(arg_0 -> ((MediaPackage)mediaPackage).remove(arg_0));
            mediaPackage.add(attachment);
            WorkflowPropertiesUtil.storeProperty((AssetManager)this.assetManager, (MediaPackage)mediaPackage, (String)(flavor.getType() + "/" + this.thumbnailWfProperty), (String)"true");
        }
        return mediaPackage;
    }

    private String detectMimeType(String b64) throws MimeTypeParseException {
        HashMap<String, String> signatures = new HashMap<String, String>();
        signatures.put("R0lGODdh", "image/gif");
        signatures.put("iVBORw0KGgo", "image/png");
        signatures.put("/9j/", "image/jpg");
        for (Map.Entry s : signatures.entrySet()) {
            if (b64.indexOf((String)s.getKey()) != 0) continue;
            return (String)s.getValue();
        }
        throw new MimeTypeParseException("No image mimetype found");
    }

    private Optional<Publication> getInternalPublication(MediaPackage mp) {
        return Arrays.stream(mp.getPublications()).filter(publication -> "internal".equals(publication.getChannel())).findFirst();
    }

    private Event getEvent(String mediaPackageId) throws EditorServiceException {
        try {
            Opt optEvent = this.index.getEvent(mediaPackageId, this.searchIndex);
            if (!optEvent.isNone()) {
                return (Event)optEvent.get();
            }
            this.errorExit("Event not found", mediaPackageId, ErrorStatus.MEDIAPACKAGE_NOT_FOUND);
        }
        catch (SearchIndexException e) {
            this.errorExit("Error while reading event from search index:", mediaPackageId, ErrorStatus.MEDIAPACKAGE_NOT_FOUND, (Exception)((Object)e));
        }
        return null;
    }

    private List<WorkflowDefinition> getEditingWorkflows() {
        try {
            return this.workflowService.listAvailableWorkflowDefinitions().stream().filter(workflow -> workflow.containsTag("editor")).collect(Collectors.toList());
        }
        catch (WorkflowDatabaseException e) {
            logger.warn("Error while retrieving list of workflow definitions:", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<SegmentData> getSegments(MediaPackage mediaPackage) {
        SegmentData singleSegment;
        Smil smil;
        List<SegmentData> segments = new ArrayList<SegmentData>();
        for (Catalog smilCatalog : mediaPackage.getCatalogs(this.getSmilCatalogFlavor())) {
            try {
                smil = this.smilService.fromXml(this.workspace.get(smilCatalog.getURI())).getSmil();
                segments = this.mergeSegments(segments, this.getSegmentsFromSmil(smil));
            }
            catch (NotFoundException e) {
                logger.warn("File '{}' could not be loaded by workspace service:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (IOException e) {
                logger.warn("Reading file '{}' from workspace service failed:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (SmilException e) {
                logger.warn("Error while parsing SMIL catalog '{}':", (Object)smilCatalog.getURI(), (Object)e);
            }
        }
        if (!segments.isEmpty()) {
            return segments;
        }
        for (Catalog smilCatalog : mediaPackage.getCatalogs(this.getSmilSilenceFlavor())) {
            try {
                smil = this.smilService.fromXml(this.workspace.get(smilCatalog.getURI())).getSmil();
                segments = this.getSegmentsFromSmil(smil);
            }
            catch (NotFoundException e) {
                logger.warn("File '{}' could not be loaded by workspace service:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (IOException e) {
                logger.warn("Reading file '{}' from workspace service failed:", (Object)smilCatalog.getURI(), (Object)e);
            }
            catch (SmilException e) {
                logger.warn("Error while parsing SMIL catalog '{}':", (Object)smilCatalog.getURI(), (Object)e);
            }
        }
        if (segments.size() == 1 && (singleSegment = (SegmentData)segments.get(0)).getStart() == 0L && singleSegment.getEnd() >= mediaPackage.getDuration()) {
            segments.remove(0);
        }
        return segments;
    }

    protected List<SegmentData> getDeletedSegments(MediaPackage mediaPackage, List<SegmentData> segments) {
        long lastTime = 0L;
        ArrayList<SegmentData> deletedElements = new ArrayList<SegmentData>();
        for (int i = 0; i < segments.size(); ++i) {
            SegmentData segmentData = segments.get(i);
            if (segmentData.getStart() != lastTime) {
                SegmentData deleted = new SegmentData(Long.valueOf(lastTime), segmentData.getStart(), true);
                deletedElements.add(deleted);
            }
            lastTime = segmentData.getEnd();
            if (segments.size() - 1 != i || mediaPackage.getDuration() == null || lastTime >= mediaPackage.getDuration()) continue;
            deletedElements.add(new SegmentData(Long.valueOf(lastTime), mediaPackage.getDuration(), true));
        }
        return deletedElements;
    }

    protected List<SegmentData> mergeSegments(List<SegmentData> segments, List<SegmentData> segments2) {
        List<SegmentData> mergedSegments = this.mergeInternal(segments, segments2);
        this.sortSegments(mergedSegments);
        return mergedSegments;
    }

    private void sortSegments(List<SegmentData> mergedSegments) {
        mergedSegments.sort(Comparator.comparing(SegmentData::getStart));
    }

    private List<SegmentData> mergeInternal(List<SegmentData> segments, List<SegmentData> segments2) {
        Iterator<SegmentData> it = segments.iterator();
        while (it.hasNext()) {
            SegmentData seg = it.next();
            Iterator<SegmentData> it2 = segments2.iterator();
            while (it2.hasNext()) {
                SegmentData seg2 = it2.next();
                long combinedStart = Math.max(seg.getStart(), seg2.getStart());
                long combinedEnd = Math.min(seg.getEnd(), seg2.getEnd());
                if (combinedEnd <= combinedStart) continue;
                it.remove();
                it2.remove();
                ArrayList<SegmentData> newSegments = new ArrayList<SegmentData>(segments);
                newSegments.add(new SegmentData(Long.valueOf(combinedStart), Long.valueOf(combinedEnd)));
                return this.mergeInternal(newSegments, segments2);
            }
        }
        segments.addAll(segments2);
        return segments;
    }

    List<SegmentData> getSegmentsFromSmil(Smil smil) {
        ArrayList<SegmentData> segments = new ArrayList<SegmentData>();
        for (SmilMediaObject elem : smil.getBody().getMediaElements()) {
            if (!(elem instanceof SmilMediaContainer)) continue;
            SmilMediaContainer mediaContainer = (SmilMediaContainer)elem;
            SegmentData tuple = null;
            for (SmilMediaObject video : mediaContainer.getElements()) {
                if (!(video instanceof SmilMediaElement)) continue;
                SmilMediaElement videoElem = (SmilMediaElement)video;
                try {
                    if (tuple != null && videoElem.getClipEndMS() - videoElem.getClipBeginMS() <= tuple.getEnd() - tuple.getStart()) continue;
                    tuple = new SegmentData(Long.valueOf(videoElem.getClipBeginMS()), Long.valueOf(videoElem.getClipEndMS()));
                }
                catch (SmilException e) {
                    logger.warn("Media element '{}' of SMIL catalog '{}' seems to be invalid", new Object[]{videoElem, smil, e});
                }
            }
            if (tuple == null) continue;
            segments.add(tuple);
        }
        return segments;
    }

    public void lockMediaPackage(String mediaPackageId, LockData lockRequest) throws EditorServiceException {
        this.getEvent(mediaPackageId);
        editorLock.lock(mediaPackageId, lockRequest);
    }

    public void unlockMediaPackage(String mediaPackageId, LockData lockRequest) throws EditorServiceException {
        this.getEvent(mediaPackageId);
        editorLock.unlock(mediaPackageId, lockRequest);
    }

    public EditingData getEditData(String mediaPackageId) throws EditorServiceException, UnauthorizedException {
        Event event = this.getEvent(mediaPackageId);
        MediaPackage mp = this.getMediaPackage(event);
        if (!this.isAdmin() && !this.authorizationService.hasPermission(mp, "write")) {
            throw new UnauthorizedException("User has no write access to this event");
        }
        boolean workflowActive = WorkflowUtil.isActive((String)event.getWorkflowState());
        Optional<Publication> internalPubOpt = this.getInternalPublication(mp);
        if (internalPubOpt.isEmpty()) {
            this.errorExit("No internal publication", mediaPackageId, ErrorStatus.NO_INTERNAL_PUBLICATION);
        }
        Publication internalPub = internalPubOpt.get();
        List<SegmentData> segments = this.getSegments(mp);
        segments.addAll(this.getDeletedSegments(mp, segments));
        this.sortSegments(segments);
        ArrayList<WorkflowData> workflows = new ArrayList<WorkflowData>();
        for (WorkflowDefinition workflow : this.getEditingWorkflows()) {
            workflows.add(new WorkflowData(workflow.getId(), workflow.getTitle(), Integer.valueOf(workflow.getDisplayOrder()), workflow.getDescription()));
        }
        Map latestWfProperties = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackageId);
        Collection hiddens = latestWfProperties.entrySet().stream().map(property -> Tuple.tuple((Object)((String)property.getKey()).split("_"), (Object)((String)property.getValue()))).filter(property -> ((String[])property.getA()).length == 3).filter(property -> ((String[])property.getA())[0].equals("hide")).filter(property -> ((String)property.getB()).equals("true")).map(property -> Tuple.tuple((Object)((String[])property.getA())[1], (Object)((String[])property.getA())[2])).collect(Collectors.toSet());
        List<Object> trackList = Arrays.stream(internalPub.getTracks()).filter(this::elementHasPreviewTag).collect(Collectors.toList());
        if (trackList.isEmpty() && (trackList = Arrays.stream(internalPub.getTracks()).filter(this::elementHasPreviewFlavor).collect(Collectors.toList())).isEmpty()) {
            trackList = Arrays.asList(internalPub.getTracks());
        }
        Track[] subtitleTracks = mp.getTracks(this.captionsFlavor);
        ArrayList<EditingData.Subtitle> subtitles = new ArrayList<EditingData.Subtitle>();
        for (Track t : subtitleTracks) {
            try {
                File subtitleFile = this.workspace.get(t.getURI());
                String subtitleString = FileUtils.readFileToString((File)subtitleFile, (Charset)StandardCharsets.UTF_8);
                subtitles.add(new EditingData.Subtitle(t.getIdentifier(), subtitleString, t.getTags()));
            }
            catch (IOException | NotFoundException e) {
                this.errorExit("Could not read subtitle from file", mediaPackageId, ErrorStatus.UNKNOWN);
            }
        }
        List tracks = trackList.stream().map(track -> {
            String uri = this.signIfNecessary(track.getURI());
            boolean audioEnabled = !hiddens.contains(Tuple.tuple((Object)track.getFlavor().getType(), (Object)"audio"));
            TrackSubData audio = new TrackSubData(track.hasAudio(), null, audioEnabled);
            boolean videoEnable = !hiddens.contains(Tuple.tuple((Object)track.getFlavor().getType(), (Object)"video"));
            String videoPreview = Arrays.stream(internalPub.getAttachments()).filter(attachment -> attachment.getFlavor().getType().equals(track.getFlavor().getType())).filter(attachment -> attachment.getFlavor().getSubtype().equals(this.getPreviewVideoSubtype())).map(MediaPackageElement::getURI).map(this::signIfNecessary).findAny().orElse(null);
            TrackSubData video = new TrackSubData(track.hasVideo(), videoPreview, videoEnable);
            String thumbnailURI = Arrays.stream(mp.getAttachments()).filter(attachment -> attachment.getFlavor().getType().equals(track.getFlavor().getType())).filter(attachment -> attachment.getFlavor().getSubtype().equals(this.getThumbnailSubtype())).map(MediaPackageElement::getURI).map(this::signIfNecessary).findAny().orElse(null);
            if (thumbnailURI == null) {
                thumbnailURI = Arrays.stream(internalPub.getAttachments()).filter(attachment -> attachment.getFlavor().getType().equals(track.getFlavor().getType())).filter(attachment -> attachment.getFlavor().getSubtype().equals(this.getThumbnailSubtype())).map(MediaPackageElement::getURI).map(this::signIfNecessary).findAny().orElse(null);
            }
            int priority = this.thumbnailSourcePrimary.indexOf(track.getFlavor());
            if (this.localPublication == null) {
                this.localPublication = this.isLocal(track.getURI());
            }
            return new TrackData(track.getFlavor().getType(), track.getFlavor().getSubtype(), audio, video, uri, track.getIdentifier(), thumbnailURI, priority);
        }).collect(Collectors.toList());
        List waveformList = Arrays.stream(internalPub.getAttachments()).filter(this::elementHasWaveformFlavor).map(MediaPackageElement::getURI).map(this::signIfNecessary).collect(Collectors.toList());
        User user = this.securityService.getUser();
        return new EditingData(segments, tracks, workflows, mp.getDuration(), mp.getTitle(), event.getRecordingStartDate(), event.getSeriesId(), event.getSeriesName(), Boolean.valueOf(workflowActive), waveformList, subtitles, this.localPublication, this.lockingActive, Integer.valueOf(this.lockRefresh), user, "");
    }

    private boolean isAdmin() {
        User currentUser = this.securityService.getUser();
        if (currentUser.hasRole("ROLE_ADMIN")) {
            return true;
        }
        Organization currentOrg = this.securityService.getOrganization();
        return currentUser.getOrganization().getId().equals(currentOrg.getId()) && currentUser.hasRole(currentOrg.getAdminRole());
    }

    private MediaPackage getMediaPackage(Event event) throws EditorServiceException {
        if (event == null) {
            this.errorExit("No Event provided", "", ErrorStatus.UNKNOWN);
            return null;
        }
        try {
            return this.index.getEventMediapackage(event);
        }
        catch (IndexServiceException e) {
            this.errorExit("Not Found", event.getIdentifier(), ErrorStatus.MEDIAPACKAGE_NOT_FOUND);
            return null;
        }
    }

    private void errorExit(String message, String mediaPackageId, ErrorStatus status) throws EditorServiceException {
        this.errorExit(message, mediaPackageId, status, null);
    }

    private void errorExit(String message, String mediaPackageId, ErrorStatus status, Exception e) throws EditorServiceException {
        String errorMessage = MessageFormat.format("{0}. Event ID: {1}", message, mediaPackageId);
        throw new EditorServiceException(errorMessage, status, (Throwable)e);
    }

    public void setEditData(String mediaPackageId, EditingData editingData) throws EditorServiceException, IOException {
        Event event = this.getEvent(mediaPackageId);
        if (WorkflowUtil.isActive((String)event.getWorkflowState())) {
            this.errorExit("Workflow is running", mediaPackageId, ErrorStatus.WORKFLOW_ACTIVE);
        }
        MediaPackage mediaPackage = this.getMediaPackage(event);
        Smil smil = null;
        try {
            smil = this.createSmilCuttingCatalog(editingData, mediaPackage);
        }
        catch (Exception e) {
            this.errorExit("Unable to create SMIL cutting catalog", mediaPackageId, ErrorStatus.UNABLE_TO_CREATE_CATALOG, e);
        }
        HashMap<CallSite, String> workflowProperties = new HashMap<CallSite, String>();
        for (TrackData track : editingData.getTracks()) {
            MediaPackageElementFlavor flavor = track.getFlavor();
            String type = null;
            if (flavor != null) {
                type = flavor.getType();
            } else {
                Track mpTrack = mediaPackage.getTrack(track.getId());
                if (mpTrack != null) {
                    type = mpTrack.getFlavor().getType();
                } else {
                    this.errorExit("Unable to determine track type", mediaPackageId, ErrorStatus.UNKNOWN);
                }
            }
            workflowProperties.put((CallSite)((Object)("hide_" + type + "_audio")), Boolean.toString(!track.getAudio().isEnabled()));
            workflowProperties.put((CallSite)((Object)("hide_" + type + "_video")), Boolean.toString(!track.getVideo().isEnabled()));
        }
        WorkflowPropertiesUtil.storeProperties((AssetManager)this.assetManager, (MediaPackage)mediaPackage, workflowProperties);
        try {
            mediaPackage = this.addSmilToArchive(mediaPackage, smil);
        }
        catch (IOException e) {
            this.errorExit("Unable to add SMIL cutting catalog to archive", mediaPackageId, ErrorStatus.UNKNOWN, e);
        }
        try {
            if (editingData.getSubtitles() != null) {
                mediaPackage = this.processSubtitleTrack(mediaPackage, editingData.getSubtitles());
            }
        }
        catch (IOException e) {
            this.errorExit("Unable to add subtitle track to archive", mediaPackageId, ErrorStatus.UNKNOWN, e);
        }
        catch (IllegalArgumentException e) {
            this.errorExit("Illegal subtitle given", mediaPackageId, ErrorStatus.UNKNOWN, e);
        }
        try {
            mediaPackage = this.addThumbnailsToArchive(editingData, mediaPackage);
        }
        catch (MimeTypeParseException e) {
            this.errorExit("Thumbnail had an illegal MimeType", mediaPackageId, ErrorStatus.UNKNOWN, e);
        }
        catch (IOException e) {
            this.errorExit("Unable to add thumbnail to archive", mediaPackageId, ErrorStatus.UNKNOWN, e);
        }
        try {
            this.assetManager.takeSnapshot(mediaPackage);
        }
        catch (AssetManagerException e) {
            logger.error("Error while adding the updated media package ({}) to the archive", (Object)mediaPackage.getIdentifier(), (Object)e);
            throw new IOException(e);
        }
        try {
            this.index.updateAllEventMetadata(mediaPackageId, editingData.getMetadataJSON(), this.searchIndex);
        }
        catch (IllegalArgumentException | SearchIndexException | IndexServiceException e) {
            this.errorExit("Event metadata can't be updated.", mediaPackageId, ErrorStatus.METADATA_UPDATE_FAIL, (Exception)e);
        }
        catch (NotFoundException e) {
            this.errorExit("Event not found.", mediaPackageId, ErrorStatus.MEDIAPACKAGE_NOT_FOUND, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            this.errorExit("Not authorized to update event metadata .", mediaPackageId, ErrorStatus.NOT_AUTHORIZED, (Exception)((Object)e));
        }
        if (editingData.getPostProcessingWorkflow() != null) {
            String workflowId = editingData.getPostProcessingWorkflow();
            try {
                Map workflowParameters = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackage.getIdentifier().toString());
                Workflows workflows = new Workflows(this.assetManager, this.workflowService);
                workflows.applyWorkflowToLatestVersion(Collections.singletonList(mediaPackage.getIdentifier().toString()), ConfiguredWorkflow.workflow((WorkflowDefinition)this.workflowService.getWorkflowDefinitionById(workflowId), (Map)workflowParameters));
            }
            catch (AssetManagerException e) {
                this.errorExit("Unable to start workflow" + workflowId, mediaPackageId, ErrorStatus.WORKFLOW_ERROR, (Exception)((Object)e));
            }
            catch (WorkflowDatabaseException e) {
                this.errorExit("Unable to load workflow" + workflowId, mediaPackageId, ErrorStatus.WORKFLOW_ERROR, (Exception)((Object)e));
            }
            catch (NotFoundException e) {
                this.errorExit("Unable to load workflow" + workflowId, mediaPackageId, ErrorStatus.WORKFLOW_NOT_FOUND, (Exception)((Object)e));
            }
        }
    }

    public String getMetadata(String mediaPackageId) throws EditorServiceException {
        Event event = this.getEvent(mediaPackageId);
        MediaPackage mediaPackage = this.getMediaPackage(event);
        MetadataList metadataList = new MetadataList();
        List catalogUIAdapters = this.index.getEventCatalogUIAdapters();
        catalogUIAdapters.remove(this.index.getCommonEventCatalogUIAdapter());
        for (EventCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
            metadataList.add(catalogUIAdapter, catalogUIAdapter.getFields(mediaPackage));
        }
        DublinCoreMetadataCollection metadataCollection = null;
        try {
            metadataCollection = EventUtils.getEventMetadata((Event)event, (EventCatalogUIAdapter)this.index.getCommonEventCatalogUIAdapter());
        }
        catch (Exception e) {
            this.errorExit("Unable to retrieve event metadata", mediaPackageId, ErrorStatus.UNKNOWN);
        }
        metadataList.add(this.index.getCommonEventCatalogUIAdapter(), metadataCollection);
        String wfState = event.getWorkflowState();
        if (wfState != null && WorkflowUtil.isActive((WorkflowInstance.WorkflowState)WorkflowInstance.WorkflowState.valueOf((String)wfState))) {
            metadataList.setLocked(MetadataList.Locked.WORKFLOW_RUNNING);
        }
        return MetadataJson.listToJson((MetadataList)metadataList, (boolean)true).toString();
    }

    static {
        DEFAULT_THUMBNAIL_PRIORITY_FLAVOR = new ArrayList<MediaPackageElementFlavor>();
    }
}

