/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.opencastproject.editor.api.EditorServiceException;
import org.opencastproject.editor.api.ErrorStatus;
import org.opencastproject.editor.api.LockData;

public class EditorLock {
    private static LoadingCache<String, LockData> lockedPackages;

    public EditorLock(int timeout) {
        lockedPackages = CacheBuilder.newBuilder().expireAfterWrite((long)timeout, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, LockData>(){

            public LockData load(String mediapackageId) throws Exception {
                return (LockData)lockedPackages.getIfPresent((Object)mediapackageId);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public void lock(String mediaPackage, LockData lockRequest) throws EditorServiceException {
        LockData lockData = (LockData)lockedPackages.getIfPresent((Object)mediaPackage);
        if (null == lockData) {
            lockedPackages.put((Object)mediaPackage, (Object)lockRequest);
            return;
        }
        if (lockRequest.getUUID().equals(lockData.getUUID())) {
            lockedPackages.refresh((Object)mediaPackage);
            return;
        }
        String lockMessage = lockData.toString();
        throw new EditorServiceException(lockMessage, ErrorStatus.MEDIAPACKAGE_LOCKED);
    }

    public void unlock(String mediaPackage, LockData lockRequest) throws EditorServiceException {
        LockData lockData = (LockData)lockedPackages.getIfPresent((Object)mediaPackage);
        if (null != lockData) {
            if (lockRequest.getUUID().equals(lockData.getUUID())) {
                lockedPackages.invalidate((Object)mediaPackage);
            } else {
                String lockMessage = "MediaPackage " + mediaPackage + lockData.toString();
                throw new EditorServiceException(lockMessage, ErrorStatus.MEDIAPACKAGE_LOCKED);
            }
        }
    }

    public boolean isLocked(String mediaPackage) {
        return null != this.getLockData(mediaPackage);
    }

    public LockData getLockData(String mediaPackage) {
        return (LockData)lockedPackages.getIfPresent((Object)mediaPackage);
    }
}

