/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Objects;

public class LockData {
    private final String uuid;
    private final String user;

    public LockData(String uuid, String user) {
        this.uuid = uuid;
        this.user = user;
    }

    public static LockData parse(String json) {
        Objects.requireNonNull(json);
        Gson gson = new Gson();
        LockData lockData = (LockData)gson.fromJson(json, LockData.class);
        return lockData;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getUser() {
        return this.user;
    }

    public String toJSONString() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public String toString() {
        if (!"".equals(this.user)) {
            return "locked by " + this.user;
        }
        return "locked by unknown user";
    }
}

