/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.opencastproject.editor.api.EditingData;
import org.opencastproject.editor.api.EditorService;
import org.opencastproject.editor.api.EditorServiceException;
import org.opencastproject.editor.api.LockData;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EditorRestEndpointBase {
    private static final Logger logger = LoggerFactory.getLogger(EditorRestEndpointBase.class);
    protected EditorService editorService;

    public abstract void setEditorService(EditorService var1);

    @GET
    @Path(value="{mediaPackageId}/edit.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getEditorData", description="Returns all the information required to get the editor tool started", returnDescription="JSON object", pathParameters={@RestParameter(name="mediaPackageId", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Media package found", responseCode=200), @RestResponse(description="Media package not found", responseCode=404)})
    public Response getEditorData(@PathParam(value="mediaPackageId") String mediaPackageId) {
        try {
            EditingData response = this.editorService.getEditData(mediaPackageId);
            if (response != null) {
                return Response.ok((Object)response.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            logger.error("EditorService returned empty response");
            return RestUtil.R.serverError();
        }
        catch (EditorServiceException e) {
            return this.checkErrorState(mediaPackageId, e);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"No write access to this event.").build();
        }
    }

    @POST
    @Path(value="{mediaPackageId}/lock")
    @RestQuery(name="lockMediapackage", description="Creates and updates the lock for a mediapackage in the editor. Requests will create/refreshen a lock at /editor/{mediapackageId}/lock{uuid} (see Location header in response) that will expire after the configured period. Subsequent calls must have the same uuid, which will then freshen the lock.", returnDescription="The lock is returned in the Location header.", pathParameters={@RestParameter(name="mediaPackageId", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="user", isRequired=true, description="The user requesting to lock this mediapackage", type=RestParameter.Type.STRING, defaultValue="admin"), @RestParameter(name="uuid", isRequired=true, description="The unique identitier of the lock", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Lock obtained", responseCode=201), @RestResponse(description="Lock not obtained", responseCode=409), @RestResponse(description="Mediapackage not found", responseCode=404)})
    public Response lockMediapackage(@PathParam(value="mediaPackageId") String mediaPackageId, @FormParam(value="user") String user, @FormParam(value="uuid") String uuid, @Context HttpServletRequest request) {
        try {
            LockData lockData = new LockData(uuid, user);
            this.editorService.lockMediaPackage(mediaPackageId, lockData);
            return RestUtil.R.created((URI)new URI(request.getRequestURI() + "/" + lockData.getUUID()));
        }
        catch (EditorServiceException e) {
            return this.checkErrorState(mediaPackageId, e);
        }
        catch (Exception e) {
            logger.debug("Unable to create lock", (Throwable)e);
            return RestUtil.R.badRequest();
        }
    }

    @DELETE
    @Path(value="{mediaPackageId}/lock/{uuid}")
    @RestQuery(name="unlockMediapackage", description="Releases the lock for a mediapackage in the editor", returnDescription="", pathParameters={@RestParameter(name="mediaPackageId", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="uuid", description="Identifier of editor session", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Lock deleted", responseCode=200), @RestResponse(description="Lock not obtained", responseCode=409), @RestResponse(description="Lock not found", responseCode=404)})
    public Response unlockMediapackage(@PathParam(value="mediaPackageId") String mediaPackageId, @PathParam(value="uuid") String uuid) {
        try {
            this.editorService.unlockMediaPackage(mediaPackageId, new LockData(uuid, ""));
            return RestUtil.R.ok();
        }
        catch (EditorServiceException e) {
            return this.checkErrorState(mediaPackageId, e);
        }
    }

    @POST
    @Path(value="{mediaPackageId}/edit.json")
    @Consumes(value={"application/json"})
    @RestQuery(name="editVideo", description="Takes editing information from the client side and processes it", returnDescription="", pathParameters={@RestParameter(name="mediaPackageId", description="The id of the media package", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Editing information saved and processed", responseCode=200), @RestResponse(description="Media package not found", responseCode=404), @RestResponse(description="The editing information cannot be parsed", responseCode=400)})
    public Response editVideo(@PathParam(value="mediaPackageId") String mediaPackageId, @Context HttpServletRequest request) {
        String details = null;
        try {
            details = this.readInputStream(request);
            logger.debug("Editor POST-Request received: {}", (Object)details);
            EditingData editingInfo = EditingData.parse(details);
            this.editorService.setEditData(mediaPackageId, editingInfo);
        }
        catch (EditorServiceException e) {
            return this.checkErrorState(mediaPackageId, e);
        }
        catch (Exception e) {
            logger.debug("Unable to parse editing information ({})", (Object)details, (Object)e);
            return RestUtil.R.badRequest((String)"Unable to parse details");
        }
        return RestUtil.R.ok();
    }

    protected String readInputStream(HttpServletRequest request) {
        String details;
        try (ServletInputStream is = request.getInputStream();){
            details = IOUtils.toString((InputStream)is, (String)request.getCharacterEncoding());
        }
        catch (IOException e) {
            logger.error("Error reading request body:", (Throwable)e);
            return null;
        }
        return details;
    }

    protected Response checkErrorState(String eventId, EditorServiceException e) {
        switch (e.getErrorStatus()) {
            case MEDIAPACKAGE_NOT_FOUND: {
                return RestUtil.R.notFound((Object)String.format("Event '%s' not Found", eventId), (MediaType)MediaType.TEXT_PLAIN_TYPE);
            }
            case MEDIAPACKAGE_LOCKED: {
                return RestUtil.R.conflict((String)String.format("Event '%s' is %s", eventId, e.getMessage()));
            }
            case WORKFLOW_ACTIVE: {
                return RestUtil.R.locked();
            }
            case NOT_AUTHORIZED: {
                return RestUtil.R.unauthorized((Object)String.format("Unauthorized for event '%s'", eventId));
            }
            case WORKFLOW_NOT_FOUND: 
            case METADATA_UPDATE_FAIL: 
            case NO_INTERNAL_PUBLICATION: {
                return RestUtil.R.badRequest((String)e.getMessage());
            }
        }
        return RestUtil.R.serverError();
    }

    @GET
    @Path(value="{mediaPackageId}/metadata.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getMetadata", description="Returns all the data related to the metadata tab in the event details modal as JSON", returnDescription="All the data related to the event metadata tab as JSON", pathParameters={@RestParameter(name="mediaPackageId", description="The event id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns all the data related to the event metadata tab as JSON", responseCode=200), @RestResponse(description="No event with this identifier was found.", responseCode=404)})
    public Response getEventMetadata(@PathParam(value="mediaPackageId") String eventId) {
        try {
            String response = this.editorService.getMetadata(eventId);
            if (response != null) {
                return Response.ok((Object)response, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            logger.error("EditorService returned empty response");
            return RestUtil.R.serverError();
        }
        catch (EditorServiceException e) {
            return this.checkErrorState(eventId, e);
        }
    }
}

