/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.editor.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.opencastproject.editor.api.SegmentData;
import org.opencastproject.editor.api.SeriesData;
import org.opencastproject.editor.api.TrackData;
import org.opencastproject.editor.api.WorkflowData;
import org.opencastproject.security.api.User;

public class EditingData {
    public static final String WORKFLOW_ACTIVE = "workflow_active";
    public static final String LOCKING_ACTIVE = "locking_active";
    public static final String LOCK_REFRESH = "lock_refresh";
    public static final String LOCK_UUID = "lock_uuid";
    public static final String LOCK_USER = "lock_user";
    private final List<SegmentData> segments;
    private final List<WorkflowData> workflows;
    private final List<TrackData> tracks;
    private final String title;
    private final String date;
    private final Long duration;
    private final SeriesData series;
    @SerializedName(value="workflow_active")
    private final Boolean workflowActive;
    @SerializedName(value="locking_active")
    private final Boolean lockingActive;
    @SerializedName(value="lock_refresh")
    private final Integer lockRefresh;
    @SerializedName(value="lock_uuid")
    private final String lockUUID;
    @SerializedName(value="lock_user")
    private final String lockUser;
    private final List<String> waveformURIs;
    private final List<Subtitle> subtitles;
    private final Boolean local;
    private final String metadataJSON;

    public EditingData(List<SegmentData> segments, List<TrackData> tracks, List<WorkflowData> workflows, Long duration, String title, String recordingStartDate, String seriesId, String seriesName, Boolean workflowActive, List<String> waveformURIs, List<Subtitle> subtitles, Boolean local, Boolean lockingActive, Integer lockRefresh, User user, String metadataJSON) {
        this.segments = segments;
        this.tracks = tracks;
        this.workflows = workflows;
        this.duration = duration;
        this.title = title;
        this.date = recordingStartDate;
        this.series = new SeriesData(seriesId, seriesName);
        this.workflowActive = workflowActive;
        this.waveformURIs = waveformURIs;
        this.subtitles = subtitles;
        this.local = local;
        this.lockingActive = lockingActive;
        this.lockRefresh = lockRefresh * 1000;
        this.lockUUID = UUID.randomUUID().toString();
        this.lockUser = user.getUsername();
        this.metadataJSON = metadataJSON;
    }

    public static EditingData parse(String json) {
        Objects.requireNonNull(json);
        Gson gson = new Gson();
        EditingData editingData = (EditingData)gson.fromJson(json, EditingData.class);
        Objects.requireNonNull(editingData.getTracks());
        Objects.requireNonNull(editingData.getSegments());
        return editingData;
    }

    public List<SegmentData> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public String getPostProcessingWorkflow() {
        return this.workflows != null && this.workflows.size() > 0 ? this.workflows.get(0).getId() : null;
    }

    public List<TrackData> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    public List<Subtitle> getSubtitles() {
        return this.subtitles;
    }

    public String getMetadataJSON() {
        return this.metadataJSON;
    }

    public String toString() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public static final class Subtitle {
        private final String id;
        private final String subtitle;
        private final String[] tags;
        private final boolean deleted;

        public Subtitle(String id, String subtitle, String[] tags) {
            this(id, subtitle, tags, false);
        }

        public Subtitle(String id, String subtitle, String[] tags, boolean deleted) {
            this.id = id;
            this.subtitle = subtitle;
            this.tags = tags;
            this.deleted = deleted;
        }

        public String getId() {
            return this.id;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public String[] getTags() {
            return this.tags;
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

