/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableWorkflowOperationHandlerBase
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurableWorkflowOperationHandlerBase.class);

    abstract DownloadDistributionService getDownloadDistributionService();

    abstract StreamingDistributionService getStreamingDistributionService();

    private void addPublicationElementsToMediaPackage(Publication publication, MediaPackage mp) {
        assert (publication != null && mp != null);
        for (Attachment attachment : publication.getAttachments()) {
            mp.add(attachment);
        }
        for (Attachment attachment : publication.getCatalogs()) {
            mp.add((Catalog)attachment);
        }
        for (Attachment attachment : publication.getTracks()) {
            mp.add((Track)attachment);
        }
    }

    private int retractPublicationElements(String channelId, Publication publication, MediaPackage mp, boolean retractStreaming) throws WorkflowOperationException {
        assert (channelId != null && publication != null && mp != null);
        MediaPackage mediapackageWithPublicationElements = (MediaPackage)mp.clone();
        this.addPublicationElementsToMediaPackage(publication, mediapackageWithPublicationElements);
        HashSet<String> elementIds = new HashSet<String>();
        for (Attachment attachment : publication.getAttachments()) {
            elementIds.add(attachment.getIdentifier());
        }
        for (Attachment attachment : publication.getCatalogs()) {
            elementIds.add(attachment.getIdentifier());
        }
        for (Attachment attachment : publication.getTracks()) {
            elementIds.add(attachment.getIdentifier());
        }
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (elementIds.size() > 0) {
            logger.info("Retracting {} elements of media package {} from publication channel {}", new Object[]{elementIds.size(), mp, channelId});
            try {
                Job retractDownloadDistributionJob = this.getDownloadDistributionService().retract(channelId, mediapackageWithPublicationElements, elementIds);
                if (retractDownloadDistributionJob != null) {
                    jobs.add(retractDownloadDistributionJob);
                }
            }
            catch (DistributionException e) {
                logger.error("Error while retracting '{}' elements of media package {} from channel '{}' of distribution '{}'", new Object[]{elementIds.size(), mp, channelId, this.getDownloadDistributionService(), e});
                throw new WorkflowOperationException((Throwable)e);
            }
            if (retractStreaming) {
                try {
                    Job retractStreamingJob = this.getStreamingDistributionService().retract(channelId, mediapackageWithPublicationElements, elementIds);
                    if (retractStreamingJob != null) {
                        jobs.add(retractStreamingJob);
                    }
                }
                catch (DistributionException e) {
                    logger.error("Error while retracting '{}' elements of media package {} from channel '{}' of distribution '{}'", new Object[]{elementIds.size(), mp, channelId, this.getStreamingDistributionService(), e});
                    throw new WorkflowOperationException((Throwable)e);
                }
            }
            if (!this.waitForStatus(jobs.toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("One of the retraction jobs did not complete successfully");
            }
        } else {
            logger.debug("No publication elements were found for retraction");
        }
        return elementIds.size();
    }

    public List<Publication> getPublications(MediaPackage mp, final String channelId) {
        assert (mp != null && channelId != null);
        List publications = Stream.mk((Object[])mp.getPublications()).filter((Fn)new Fn<Publication, Boolean>(){

            public Boolean apply(Publication a) {
                return channelId.equals(a.getChannel());
            }
        }).toList();
        assert (publications != null);
        return publications;
    }

    public void retract(MediaPackage mp, String channelId, boolean retractStreaming) throws WorkflowOperationException {
        assert (mp != null && channelId != null);
        List<Publication> publications = this.getPublications(mp, channelId);
        if (publications.size() > 0) {
            int retractedElementsCount = 0;
            for (Publication publication : publications) {
                retractedElementsCount += this.retractPublicationElements(channelId, publication, mp, retractStreaming);
                mp.remove((MediaPackageElement)publication);
            }
            logger.info("Successfully retracted {} publications and retracted {} elements from publication channel '{}'", new Object[]{publications.size(), retractedElementsCount, channelId});
        } else {
            logger.info("No publications for channel {} found for media package {}", (Object)channelId, (Object)mp.getIdentifier());
        }
    }
}

