/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.crop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencastproject.crop.api.CropException;
import org.opencastproject.crop.api.CropService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Videosegmentation Workflow Operation Handler", "workflow.operation=crop-video"})
public class CropWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(CropWorkflowOperationHandler.class);
    private static final String PROP_SOURCE_FLAVOR = "source-flavor";
    private static final String PROP_TARGET_FLAVOR = "target-flavor";
    private static final String PROP_TARGET_TAGS = "target-tags";
    private CropService cropService = null;
    private Workspace workspace = null;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext jobContext) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start cropping workflow operation for mediapackage {}", (Object)mediaPackage.getIdentifier().toString());
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetTags = tagsAndFlavors.getTargetTags();
        List targetFlavorOption = tagsAndFlavors.getTargetFlavors();
        MediaPackageElementFlavor targetFlavor = null;
        if (!targetFlavorOption.isEmpty()) {
            targetFlavor = (MediaPackageElementFlavor)targetFlavorOption.get(0);
        }
        MediaPackageElementFlavor trackFlavor = tagsAndFlavors.getSingleSrcFlavor();
        ArrayList<Track> candidates = new ArrayList<Track>();
        candidates.addAll(Arrays.asList(mediaPackage.getTracks(trackFlavor)));
        candidates.removeIf(t -> !t.hasVideo());
        if (candidates.size() == 0) {
            logger.info("No matching tracks available for cropping in workflow {}", (Object)workflowInstance);
            return this.createResult(WorkflowOperationResult.Action.CONTINUE);
        }
        if (candidates.size() > 1) {
            logger.info("Found more than one track to crop");
        }
        HashMap<Job, Track> jobs = new HashMap<Job, Track>();
        for (Track candidate : candidates) {
            try {
                jobs.put(this.cropService.crop(candidate), candidate);
            }
            catch (CropException | MediaPackageException e) {
                throw new WorkflowOperationException("Failed starting crop job", e);
            }
        }
        if (!this.waitForStatus(jobs.keySet().toArray(new Job[0])).isSuccess()) {
            throw new WorkflowOperationException("Crop operation failed");
        }
        long totalTimeInQueue = 0L;
        for (Map.Entry entry : jobs.entrySet()) {
            Track croppedTrack;
            Job job = (Job)entry.getKey();
            Track track = (Track)entry.getValue();
            try {
                croppedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException(String.format("Crop service yielded invalid track: %s", job.getPayload()));
            }
            croppedTrack.setIdentifier(IdImpl.fromUUID().toString());
            try {
                String filename = "cropped_" + croppedTrack.getURI().toString();
                croppedTrack.setURI(this.workspace.moveTo(croppedTrack.getURI(), mediaPackage.getIdentifier().toString(), croppedTrack.getIdentifier(), filename));
            }
            catch (IOException | NotFoundException e) {
                throw new WorkflowOperationException(String.format("Could not move %s to media package %s", croppedTrack.getURI(), mediaPackage.getIdentifier()));
            }
            targetTags.forEach(arg_0 -> ((Track)croppedTrack).addTag(arg_0));
            croppedTrack.setFlavor(targetFlavor);
            mediaPackage.addDerived((MediaPackageElement)croppedTrack, (MediaPackageElement)track);
            totalTimeInQueue += job.getQueueTime() == null ? 0L : job.getQueueTime();
        }
        logger.info("Video cropping completed");
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
    }

    @Reference
    protected void setCropService(CropService cropService) {
        this.cropService = cropService;
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

