/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.crop.remote;

import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.crop.api.CropException;
import org.opencastproject.crop.api.CropService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CropService.class}, property={"service.description=Crop Remote Service Proxy"})
public class CropServiceRemoteImpl
extends RemoteBase
implements CropService {
    private static final Logger logger = LoggerFactory.getLogger(CropServiceRemoteImpl.class);

    public CropServiceRemoteImpl() {
        super("org.opencastproject.crop");
    }

    public Job crop(Track track) throws CropException, MediaPackageException {
        HttpPost post = new HttpPost("/");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("track", MediaPackageElementParser.getAsXml((MediaPackageElement)track)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        }
        catch (Exception e) {
            throw new CropException("Unable to assemble a remote crop request for track" + track, (Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job job = JobParser.parseJob((String)content);
                logger.info("Crop job {} started", (Object)job.getId());
                Job job2 = job;
                return job2;
            }
        }
        catch (Exception e) {
            throw new CropException("Unable to crop track" + track + " using remote crop service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new CropException("Unable to crop track" + track + " using remote crop service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

