/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.crop.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.crop.api.CropException;
import org.opencastproject.crop.api.CropService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CropService.class, ManagedService.class}, property={"service.description=Video Scale Service"})
public class CropServiceImpl
extends AbstractJobProducer
implements CropService,
ManagedService {
    public static final String COLLECTION_ID = "cropping";
    protected String binary = "ffmpeg";
    public static final String FFMPEG_BINARY_CONFIG = "org.opencastproject.composer.ffmpeg.path";
    public static final String FFMPEG_BINARY_DEFAULT = "ffmpeg";
    public static final float DEFAULT_CROP_JOB_LOAD = 1.0f;
    public static final String CROP_JOB_LOAD_KEY = "org.opencastproject.job.load.cropping";
    private float cropJobLoad = 1.0f;
    public static final String CROP_FFMPEG_GREYSCALE_LIMIT = "org.opencastproject.ffmpeg.cropping.greyscale.limit";
    public static final String DEFAULT_CROP_GREYSCALE_LIMIT = "24";
    private String greyScaleLimit = "24";
    public static final String CROP_FFMPEG_ROUND = "org.opencastproject.ffmpeg.cropping.round";
    public static final String DEFAULT_CROP_FFMPEG_ROUND = "16";
    private String round = "16";
    public static final String CROP_FFMPEG_RESET = "org.opencastproject.ffmpeg.cropping.reset";
    public static final String DEFAULT_CROP_FFMPEG_RESET = "240";
    private String reset = "240";
    public static final String CROP_FFMPEG_PARAM = "org.opencastproject.ffmpeg.cropping.additional.param";
    public static final String DEFAULT_CROP_FFMPEG_PARAM = "-max_muxing_queue_size 2000";
    private String additionalParameters = "-max_muxing_queue_size 2000";
    public static final String CROP_FFMPEG_TARGET_EXTENSION = "org.opencastproject.ffmpeg.cropping.extension";
    public static final String DEFAULT_CROP_FFMPEG_TARGET_EXTENSION = ".mp4";
    private String targetExtension = ".mp4";
    public static final String CROP_FFMPEG_REGEX = "org.opencastproject.ffmpeg.cropping.regex";
    public static final String DEFAULT_CROP_FFMPEG_REGEX = "\\[Parsed_cropdetect.* w:(?<widthVideo>\\d*).*x:(?<cropValue>\\d*).* (?<crop>crop=.*)";
    private Pattern regexPattern;
    public static final String CROP_FFMPEG_MAX_CROPPING_RATIO = "org.opencastproject.ffmpeg.cropping.max.ratio";
    public static final Integer DEFAULT_CROP_FFMPEG_MAX_CROPPING_RATIO = 3;
    private Integer maxCroppingRatio = DEFAULT_CROP_FFMPEG_MAX_CROPPING_RATIO;
    private static final Logger logger = LoggerFactory.getLogger(CropServiceImpl.class);
    private ServiceRegistry serviceRegistry = null;
    private Workspace workspace = null;
    private SecurityService securityService = null;
    private OrganizationDirectoryService organizationDirectoryService = null;
    private UserDirectoryService userDirectoryService = null;

    public CropServiceImpl() {
        super("org.opencastproject.crop");
        this.regexPattern = Pattern.compile(DEFAULT_CROP_FFMPEG_REGEX);
    }

    public void activate(ComponentContext cc) {
        super.activate(cc);
        String path = cc.getBundleContext().getProperty(FFMPEG_BINARY_CONFIG);
        this.binary = (String)StringUtils.defaultIfBlank((CharSequence)path, (CharSequence)FFMPEG_BINARY_DEFAULT);
        logger.debug("Configuration {}: {}", (Object)FFMPEG_BINARY_CONFIG, (Object)this.binary);
    }

    private Track startCropping(Track track) throws CropException {
        URI croppedMediaUri;
        File mediaFile;
        if (!track.hasVideo()) {
            throw new CropException("Element is not a video track");
        }
        try {
            mediaFile = this.workspace.get(track.getURI());
        }
        catch (IOException | NotFoundException e) {
            throw new CropException("Error loading the video file into the workspace", e);
        }
        logger.info("Starting cropping of {}", (Object)track);
        File croppedMedia = this.cropFFmpeg(mediaFile);
        String fileName = String.valueOf(UUID.randomUUID()) + "-" + croppedMedia.getName();
        try (FileInputStream fileStream = new FileInputStream(croppedMedia);){
            croppedMediaUri = this.workspace.putInCollection(COLLECTION_ID, fileName, (InputStream)fileStream);
        }
        catch (IOException e) {
            throw new CropException("Error putting output file in workspace collection", (Throwable)e);
        }
        Track cropTrack = (Track)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().newElement(Track.TYPE, track.getFlavor());
        cropTrack.setURI(croppedMediaUri);
        logger.info("Finished video cropping of {}", (Object)track.getURI());
        return cropTrack;
    }

    private File cropFFmpeg(File mediaFile) throws CropException {
        Object[] command = new String[]{this.binary, "-i", mediaFile.getAbsolutePath(), "-vf", "cropdetect=" + this.greyScaleLimit + ":" + this.round + ":" + this.reset, this.additionalParameters, "-f", "null", "-"};
        String commandline = StringUtils.join((Object[])command, (String)" ");
        logger.info("Running {}", (Object)commandline);
        ProcessBuilder pbuilder = new ProcessBuilder(commandline.split(" "));
        pbuilder.redirectErrorStream(true);
        int cropValue = 0;
        int widthVideo = 0;
        String crop = null;
        int exitCode = 1;
        try {
            Process process = pbuilder.start();
            try (BufferedReader errStream = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while (null != (line = errStream.readLine())) {
                    Matcher m = this.regexPattern.matcher(line);
                    while (m.find()) {
                        widthVideo = Integer.valueOf(m.group("widthVideo"));
                        int x = Integer.valueOf(m.group("cropValue"));
                        if (cropValue != 0 && cropValue <= x) continue;
                        cropValue = x;
                        crop = m.group("crop");
                    }
                }
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new CropException("Error extracting crop information from FFmpeg output", (Throwable)e);
            }
            exitCode = process.waitFor();
        }
        catch (IOException e) {
            throw new CropException("Error executing FFmpeg", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new CropException("Waiting for encoder process exited was interrupted unexpected", (Throwable)e);
        }
        if (exitCode != 0) {
            throw new CropException("The encoder process exited abnormally with exit code " + exitCode);
        }
        if (cropValue > widthVideo / this.maxCroppingRatio) {
            logger.info("Black area in the video is considered too large for cropping. File: " + mediaFile.getAbsolutePath() + " will be skipped");
            return mediaFile;
        }
        if (crop == null) {
            logger.info("Unable to detect cropping dimensions. File: " + mediaFile.getAbsolutePath() + " will be skipped");
            return mediaFile;
        }
        logger.info("String for startCropping command: {}", crop);
        String croppedOutputPath = FilenameUtils.removeExtension((String)mediaFile.getAbsolutePath()).concat(RandomStringUtils.randomAlphanumeric((int)8) + this.targetExtension);
        Object[] cropCommand = new String[]{this.binary, "-i", mediaFile.getAbsolutePath(), "-vf", crop, this.additionalParameters, croppedOutputPath};
        String cropCommandline = StringUtils.join((Object[])cropCommand, (String)" ");
        logger.info("Running {}", (Object)cropCommandline);
        try {
            Process process = new ProcessBuilder(cropCommandline.split(" ")).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).start();
            exitCode = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new CropException("Ffmpeg process interrupted", (Throwable)e);
        }
        if (exitCode != 0) {
            throw new CropException("Ffmpeg exited abnormally with status " + exitCode);
        }
        return new File(croppedOutputPath);
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            switch (op.ordinal()) {
                case 0: {
                    Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    Track croppedTrack = this.startCropping(track);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)croppedTrack);
                }
            }
            throw new IllegalStateException("Don't know how to handle operations '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type: " + String.valueOf((Object)op), (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operations '" + String.valueOf((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operations: " + String.valueOf((Object)op), (Throwable)e);
        }
    }

    public Job crop(Track track) throws CropException, MediaPackageException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.crop", Operation.CROP.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)track)), Float.valueOf(this.cropJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new CropException("Unable to create a job", (Throwable)e);
        }
    }

    public void updated(Dictionary<String, ?> dictionary) throws ConfigurationException {
        if (dictionary == null) {
            return;
        }
        logger.debug("Configuring the cropper");
        if (dictionary.get(CROP_FFMPEG_GREYSCALE_LIMIT) != null) {
            String limit = (String)dictionary.get(CROP_FFMPEG_GREYSCALE_LIMIT);
            try {
                this.greyScaleLimit = limit;
                logger.info("Changes greyscale limit to {}", (Object)this.greyScaleLimit);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for greyscale limit", (Object)limit);
            }
        }
        if (dictionary.get(CROP_FFMPEG_ROUND) != null) {
            String r = (String)dictionary.get(CROP_FFMPEG_ROUND);
            try {
                this.round = r;
                logger.info("Changes round to {}", (Object)this.round);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for round", (Object)r);
            }
        }
        if (dictionary.get(CROP_FFMPEG_RESET) != null) {
            String re = (String)dictionary.get(CROP_FFMPEG_RESET);
            try {
                this.reset = re;
                logger.info("Changes reset to {}", (Object)this.reset);
            }
            catch (Exception e) {
                logger.warn("Found illegal value {} for reset", (Object)re);
            }
        }
        if (dictionary.get(CROP_FFMPEG_PARAM) != null) {
            String ffmpegParam = (String)dictionary.get(CROP_FFMPEG_PARAM);
            try {
                this.additionalParameters = ffmpegParam;
                logger.info("Changes additional ffmpeg parameters to {}", (Object)this.additionalParameters);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for additional ffmpeg parameters", (Object)ffmpegParam);
            }
        }
        if (dictionary.get(CROP_FFMPEG_REGEX) != null) {
            String regex = (String)dictionary.get(CROP_FFMPEG_REGEX);
            try {
                this.regexPattern = Pattern.compile(regex);
                logger.info("Changes crop ffmpeg regex {}", (Object)this.regexPattern);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for crop ffmpeg regex", (Object)regex);
            }
        }
        if (dictionary.get(CROP_FFMPEG_TARGET_EXTENSION) != null) {
            String extension = (String)dictionary.get(CROP_FFMPEG_TARGET_EXTENSION);
            try {
                this.targetExtension = extension;
                logger.info("Changes crop ffmpeg target extension {}", (Object)this.targetExtension);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for target extension", (Object)extension);
            }
        }
        if (dictionary.get(CROP_FFMPEG_MAX_CROPPING_RATIO) != null) {
            Integer ratio = (Integer)dictionary.get(CROP_FFMPEG_MAX_CROPPING_RATIO);
            try {
                if (ratio == null || ratio == 0) {
                    throw new IllegalArgumentException();
                }
                this.maxCroppingRatio = ratio;
                logger.info("Changes crop max cropping ratio {}", (Object)this.maxCroppingRatio);
            }
            catch (Exception e) {
                logger.warn("Found illegal value '{}' for max cropping ratio", (Object)this.maxCroppingRatio);
            }
        }
        this.cropJobLoad = LoadUtil.getConfiguredLoadValue(dictionary, (String)CROP_JOB_LOAD_KEY, (Float)Float.valueOf(1.0f), (ServiceRegistry)this.serviceRegistry);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    private static enum Operation {
        CROP;

    }
}

