/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.coverimage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.coverimage.CoverImageException;
import org.opencastproject.coverimage.CoverImageService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.metadata.api.StaticMetadataService;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoverImageWorkflowOperationHandlerBase
extends AbstractWorkflowOperationHandler {
    private static final String EPISODE_FLAVOR = "episodeFlavor";
    private static final String SERIES_FLAVOR = "seriesFlavor";
    private static final String COVERIMAGE_FILENAME = "coverimage.png";
    private static final String XSL_FILE_URL = "stylesheet";
    private static final String XML_METADATA = "metadata";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String POSTERIMAGE_FLAVOR = "posterimage-flavor";
    private static final String POSTERIMAGE_URL = "posterimage";
    private static final Logger logger = LoggerFactory.getLogger(CoverImageWorkflowOperationHandlerBase.class);

    protected abstract CoverImageService getCoverImageService();

    protected abstract Workspace getWorkspace();

    protected abstract StaticMetadataService getStaticMetadataService();

    protected abstract DublinCoreCatalogService getDublinCoreCatalogService();

    protected abstract String getKarafEtc();

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Job generate;
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        logger.info("Cover Image Workflow started for media package '{}'", (Object)mediaPackage.getIdentifier());
        String xml = operation.getConfiguration(XML_METADATA);
        if (xml == null) {
            xml = this.getMetadataXml(mediaPackage, operation);
            logger.debug("Metadata was not part of operation configuration, using Dublin Core as fallback");
        }
        logger.debug("Metadata set to: {}", (Object)xml);
        String xsl = this.loadXsl(operation);
        logger.debug("XSL for transforming metadata to SVG loaded: {}", (Object)xsl);
        int width = this.getIntConfiguration(operation, WIDTH);
        logger.debug("Image width set to {}px", (Object)width);
        int height = this.getIntConfiguration(operation, HEIGHT);
        logger.debug("Image height set to {}px", (Object)height);
        String posterImgUri = this.getPosterImageFileUrl(operation.getConfiguration(POSTERIMAGE_URL));
        if (posterImgUri == null) {
            posterImgUri = this.getPosterImageFileUrl(mediaPackage, operation.getConfiguration(POSTERIMAGE_FLAVOR));
        }
        if (posterImgUri == null) {
            logger.debug("No optional poster image set");
        } else {
            logger.debug("Poster image found at '{}'", (Object)posterImgUri);
        }
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        try {
            generate = this.getCoverImageService().generateCoverImage(xml, xsl, String.valueOf(width), String.valueOf(height), posterImgUri, targetFlavor.toString());
            logger.debug("Job for cover image generation created");
            if (!this.waitForStatus(new Job[]{generate}).isSuccess()) {
                throw new WorkflowOperationException("'Cover image' job did not successfuly end");
            }
            generate = this.serviceRegistry.getJob(generate.getId());
            Attachment coverImage = (Attachment)MediaPackageElementParser.getFromXml((String)generate.getPayload());
            URI attachmentUri = this.getWorkspace().moveTo(coverImage.getURI(), mediaPackage.getIdentifier().toString(), UUID.randomUUID().toString(), COVERIMAGE_FILENAME);
            coverImage.setURI(attachmentUri);
            coverImage.setMimeType(MimeTypes.PNG);
            for (String tag : tagsAndFlavors.getTargetTags()) {
                logger.trace("Tagging image with '{}'", (Object)tag);
                coverImage.addTag(tag);
            }
            mediaPackage.add(coverImage);
        }
        catch (IOException | IllegalArgumentException | CoverImageException | MediaPackageException | ServiceRegistryException | NotFoundException e) {
            throw new WorkflowOperationException(e);
        }
        logger.info("Cover Image Workflow finished successfully for media package '{}' within {}ms", (Object)mediaPackage.getIdentifier(), (Object)generate.getQueueTime());
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, generate.getQueueTime());
    }

    protected String getPosterImageFileUrl(MediaPackage mediaPackage, String posterimageFlavor) throws WorkflowOperationException {
        MediaPackageElementFlavor flavor;
        if (posterimageFlavor == null) {
            logger.debug("Optional configuration key '{}' not set", (Object)POSTERIMAGE_FLAVOR);
            return null;
        }
        try {
            flavor = MediaPackageElementFlavor.parseFlavor((String)posterimageFlavor);
        }
        catch (IllegalArgumentException e) {
            logger.warn("'{}' is not a valid flavor", (Object)posterimageFlavor);
            throw new WorkflowOperationException((Throwable)e);
        }
        Attachment[] atts = mediaPackage.getAttachments(flavor);
        if (atts.length > 1) {
            logger.warn("More than one attachment with the flavor '{}' found in media package '{}'", (Object)posterimageFlavor, (Object)mediaPackage.getIdentifier());
            throw new WorkflowOperationException("More than one attachment with the flavor'" + posterimageFlavor + "' found.");
        }
        if (atts.length == 0) {
            logger.warn("No attachment with the flavor '{}' found in media package '{}'", (Object)posterimageFlavor, (Object)mediaPackage.getIdentifier());
            return null;
        }
        try {
            return this.getWorkspace().get(atts[0].getURI()).getAbsolutePath();
        }
        catch (IOException | NotFoundException e) {
            throw new WorkflowOperationException(e);
        }
    }

    protected String getPosterImageFileUrl(String posterimageUrlOpt) {
        if (StringUtils.isBlank((CharSequence)posterimageUrlOpt)) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(posterimageUrlOpt);
        }
        catch (Exception e) {
            logger.debug("Given poster image URI '{}' is not valid", (Object)posterimageUrlOpt);
        }
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            return url.toExternalForm();
        }
        try {
            File coverImageFile = this.getWorkspace().get(url.toURI());
            return coverImageFile.getPath();
        }
        catch (NotFoundException e) {
            logger.warn("Poster image could not be found at '{}'", (Object)url);
            return null;
        }
        catch (IOException e) {
            logger.warn("Error getting poster image: {}", (Object)e.getMessage());
            return null;
        }
        catch (URISyntaxException e) {
            logger.warn("Given URL '{}' is not a valid URI", (Object)url);
            return null;
        }
    }

    protected int getIntConfiguration(WorkflowOperationInstance operation, String key) throws WorkflowOperationException {
        String confString = operation.getConfiguration(key);
        int confValue = 0;
        if (StringUtils.isBlank((CharSequence)confString)) {
            throw new WorkflowOperationException("Configuration key '" + key + "' must be set");
        }
        try {
            confValue = Integer.parseInt(confString);
            if (confValue < 1) {
                throw new WorkflowOperationException("Configuration key '" + key + "' must be set to a valid positive integer value");
            }
        }
        catch (NumberFormatException e) {
            throw new WorkflowOperationException("Configuration key '" + key + "' must be set to a valid positive integer value");
        }
        return confValue;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String loadXsl(WorkflowOperationInstance operation) throws WorkflowOperationException {
        String string;
        String xslUriString = operation.getConfiguration(XSL_FILE_URL);
        if (this.getKarafEtc() != null) {
            xslUriString = xslUriString.replace("${karaf.etc}", this.getKarafEtc());
        }
        if (StringUtils.isBlank((CharSequence)xslUriString)) {
            throw new WorkflowOperationException("Configuration option 'stylesheet' must not be empty");
        }
        FileReader reader = null;
        try {
            URI xslUri = new URI(xslUriString);
            File xslFile = new File(xslUri);
            reader = new FileReader(xslFile);
            string = IOUtils.toString((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                logger.warn("There is no (xsl) file at the given uri '{}': {}", (Object)xslUriString, (Object)e.getMessage());
                throw new WorkflowOperationException("There is no (XSL) file at the given URI", (Throwable)e);
                catch (URISyntaxException e2) {
                    logger.warn("Given XSL file URI ({}) is not valid: {}", (Object)xslUriString, (Object)e2.getMessage());
                    throw new WorkflowOperationException("Given XSL file URI is not valid", (Throwable)e2);
                }
                catch (IOException e3) {
                    logger.warn("Error while reading XSL file ({}): {}", (Object)xslUriString, (Object)e3.getMessage());
                    throw new WorkflowOperationException("Error while reading XSL file", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    protected String getMetadataXml(MediaPackage mp, WorkflowOperationInstance operation) {
        String configuredEpisodeFlavor = Objects.toString(StringUtils.trimToNull((String)operation.getConfiguration(EPISODE_FLAVOR)), "dublincore/episode");
        String configuredSeriesFlavor = Objects.toString(StringUtils.trimToNull((String)operation.getConfiguration(SERIES_FLAVOR)), "dublincore/series");
        MediaPackageElementFlavor episodeFlavor = MediaPackageElementFlavor.parseFlavor((String)configuredEpisodeFlavor);
        MediaPackageElementFlavor seriesFlavor = MediaPackageElementFlavor.parseFlavor((String)configuredSeriesFlavor);
        Catalog[] catalogs = mp.getCatalogs(new MediaPackageElementFlavor(episodeFlavor.getType(), StringUtils.lowerCase((String)episodeFlavor.getSubtype())));
        DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.getWorkspace(), (MediaPackageElement)catalogs[0]);
        Map data = dc.getValues();
        StringBuilder xml = new StringBuilder();
        xml.append("<metadata xmlns:dcterms=\"http://purl.org/dc/terms/\">");
        block22: for (Map.Entry<EName, List<DublinCoreValue>> entry : data.entrySet()) {
            String currentKey;
            switch (currentKey = ((EName)entry.getKey()).getLocalName()) {
                case "creator": {
                    this.appendXml(xml, "creators", this.getValuesAsString(entry));
                    continue block22;
                }
                case "isPartOf": {
                    Catalog[] seriesCatalogs = mp.getCatalogs(new MediaPackageElementFlavor(seriesFlavor.getType(), seriesFlavor.getSubtype()));
                    if (seriesCatalogs.length == 0) continue block22;
                    xml.append("<series>");
                    DublinCoreCatalog dcSeries = DublinCoreUtil.loadDublinCore((Workspace)this.getWorkspace(), (MediaPackageElement)seriesCatalogs[0]);
                    Map seriesMetadata = dcSeries.getValues();
                    block23: for (Map.Entry<EName, List<DublinCoreValue>> entry2 : seriesMetadata.entrySet()) {
                        String currentSeriesKey;
                        switch (currentSeriesKey = ((EName)entry2.getKey()).getLocalName()) {
                            case "created": {
                                String[] date = ((DublinCoreValue)((List)entry2.getValue()).get(0)).getValue().split("\\.");
                                this.appendXml(xml, "date", date[0]);
                                continue block23;
                            }
                            case "contributor": {
                                this.appendXml(xml, "contributors", this.getValuesAsString(entry2));
                                continue block23;
                            }
                        }
                        String key = ((EName)entry2.getKey()).getLocalName();
                        this.appendXml(xml, key, this.getValuesAsString(entry2));
                    }
                    xml.append("</series>");
                    continue block22;
                }
                case "temporal": {
                    String[] entries = ((DublinCoreValue)((List)entry.getValue()).get(0)).getValue().split(";");
                    entries[0] = entries[0].trim().substring(6);
                    entries[1] = entries[1].trim().substring(4);
                    if (entries[0] != null) {
                        this.appendXml(xml, "start", entries[0]);
                    }
                    if (entries[1] == null) continue block22;
                    this.appendXml(xml, "end", entries[1]);
                    continue block22;
                }
                case "created": {
                    String[] stringArray = ((DublinCoreValue)((List)entry.getValue()).get(0)).getValue().split("\\.");
                    this.appendXml(xml, "date", stringArray[0]);
                    continue block22;
                }
                case "contributor": {
                    this.appendXml(xml, "contributors", this.getValuesAsString(entry));
                    continue block22;
                }
            }
            this.appendXml(xml, ((EName)entry.getKey()).getLocalName(), this.getValuesAsString(entry));
        }
        xml.append("</metadata>");
        return xml.toString();
    }

    protected String getValuesAsString(Map.Entry<EName, List<DublinCoreValue>> entry) {
        List<DublinCoreValue> values = entry.getValue();
        Object stringValues = "";
        try {
            stringValues = (String)stringValues + values.get(0).getValue();
            for (int i = 1; i < values.size(); ++i) {
                stringValues = (String)stringValues + ", " + values.get(i).getValue();
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn("Given Key '{}' has no Entries : {}", (Object)entry.getKey(), (Object)e.getMessage());
        }
        return stringValues;
    }

    protected void appendXml(StringBuilder xml, String name, String body) {
        if (StringUtils.isBlank((CharSequence)body) || StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        xml.append("<");
        xml.append(name);
        xml.append(">");
        xml.append(StringEscapeUtils.escapeXml((String)body));
        xml.append("</");
        xml.append(name);
        xml.append(">");
    }
}

