/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.coverimage.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.coverimage.CoverImageException;
import org.opencastproject.coverimage.CoverImageService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractCoverImageService
extends AbstractJobProducer
implements CoverImageService {
    protected static final String COVERIMAGE_WORKSPACE_COLLECTION = "coverimage";
    protected Workspace workspace = null;
    protected ServiceRegistry serviceRegistry;
    protected SecurityService securityService;
    protected UserDirectoryService userDirectoryService;
    protected OrganizationDirectoryService organizationDirectoryService;
    private static final Logger log = LoggerFactory.getLogger(AbstractCoverImageService.class);

    public AbstractCoverImageService() {
        super("org.opencastproject.coverimage");
    }

    protected String process(Job job) throws Exception {
        List arguments = job.getArguments();
        String xml = (String)arguments.get(0);
        String xsl = (String)arguments.get(1);
        int width = Integer.valueOf((String)arguments.get(2));
        int height = Integer.valueOf((String)arguments.get(3));
        String posterImage = (String)arguments.get(4);
        String targetFlavor = (String)arguments.get(5);
        Operation op = null;
        op = Operation.valueOf(job.getOperation());
        switch (op.ordinal()) {
            case 0: {
                Attachment result = this.generateCoverImageInternal(job, xml, xsl, width, height, posterImage, targetFlavor);
                return MediaPackageElementParser.getAsXml((MediaPackageElement)result);
            }
        }
        throw new IllegalStateException("Don't know how to handle operation '" + job.getOperation() + "'");
    }

    public Job generateCoverImage(String xml, String xsl, String width, String height, String posterImageUri, String targetFlavor) throws CoverImageException {
        if (posterImageUri == null) {
            posterImageUri = "";
        }
        try {
            return this.serviceRegistry.createJob("org.opencastproject.coverimage", Operation.Generate.toString(), Arrays.asList(xml, xsl, width, height, posterImageUri, targetFlavor));
        }
        catch (ServiceRegistryException e) {
            throw new CoverImageException("Unable to create a job", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Attachment generateCoverImageInternal(Job job, String xml, String xsl, int width, int height, String posterImage, String targetFlavor) throws CoverImageException {
        URI result;
        File tempSvg = null;
        File tempPng = null;
        try (StringReader xmlReader = new StringReader(xml);){
            Document xslDoc = AbstractCoverImageService.parseXsl(xsl);
            tempSvg = this.createTempFile(job, ".svg");
            StreamResult svg = new StreamResult(tempSvg);
            InputSource xmlSource = new InputSource(xmlReader);
            AbstractCoverImageService.transformSvg(svg, xmlSource, xslDoc, width, height, posterImage);
            tempPng = this.createTempFile(job, ".png");
            AbstractCoverImageService.rasterizeSvg(tempSvg, tempPng);
            try (FileInputStream in = new FileInputStream(tempPng);){
                result = this.workspace.putInCollection(COVERIMAGE_WORKSPACE_COLLECTION, job.getId() + "_coverimage.png", (InputStream)in);
                log.debug("Put the cover image into the workspace ({})", (Object)result);
            }
            catch (IOException e) {
                log.warn("Error while putting resulting image into workspace collection '{}'", (Object)COVERIMAGE_WORKSPACE_COLLECTION, (Object)e);
                throw new CoverImageException("Error while putting resulting image into workspace collection", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempSvg);
            FileUtils.deleteQuietly(tempPng);
            log.debug("Removed temporary files");
            throw throwable;
        }
        FileUtils.deleteQuietly((File)tempSvg);
        FileUtils.deleteQuietly((File)tempPng);
        log.debug("Removed temporary files");
        return (Attachment)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(result, MediaPackageElement.Type.Attachment, MediaPackageElementFlavor.parseFlavor((String)targetFlavor));
    }

    protected static Document parseXsl(String xsl) throws CoverImageException {
        Document xslDoc;
        if (StringUtils.isBlank((CharSequence)xsl)) {
            throw new IllegalArgumentException("XSL string must not be empty");
        }
        DocumentBuilderFactory dbFactory = XmlSafeParser.newDocumentBuilderFactory();
        dbFactory.setNamespaceAware(true);
        try {
            log.debug("Parse given XSL to a org.w3c.dom.Document object");
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            xslDoc = dBuilder.parse(new InputSource(new ByteArrayInputStream(xsl.getBytes("utf-8"))));
        }
        catch (ParserConfigurationException e) {
            throw new CoverImageException("The XSLT parser has serious configuration errors", (Throwable)e);
        }
        catch (SAXException e) {
            log.warn("Error while parsing the XSLT stylesheet: {}", (Object)e.getMessage());
            throw new CoverImageException("Error while parsing the XSLT stylesheet", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Error while reading the XSLT stylesheet: {}", (Object)e.getMessage());
            throw new CoverImageException("Error while reading the XSLT stylesheet", (Throwable)e);
        }
        return xslDoc;
    }

    protected static void transformSvg(Result svg, InputSource xmlSource, Document xslDoc, int width, int height, String posterImage) throws TransformerFactoryConfigurationError, CoverImageException {
        if (svg == null || xmlSource == null || xslDoc == null) {
            throw new IllegalArgumentException("Neither svg nor xmlSource nor xslDoc must be null");
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(AbstractCoverImageService.class.getClassLoader());
        try {
            Transformer transformer = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null).newTransformer(new DOMSource(xslDoc));
            transformer.setParameter("width", width);
            transformer.setParameter("height", height);
            if (StringUtils.isNotBlank((CharSequence)posterImage)) {
                transformer.setParameter("posterimage", posterImage);
            }
            log.debug("Transform XML source to SVG");
            transformer.transform(new DOMSource(XmlSafeParser.parse((InputSource)xmlSource)), svg);
        }
        catch (TransformerConfigurationException e) {
            throw new CoverImageException("The XSL transformer factory has serious configuration errors", (Throwable)e);
        }
        catch (IOException | TransformerException | SAXException e) {
            log.warn("Error while transforming SVG to image: {}", (Object)e.getMessage());
            throw new CoverImageException("Error while transforming SVG to image", (Throwable)e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    protected File createTempFile(Job job, String suffix) throws CoverImageException {
        File tempFile;
        try {
            tempFile = File.createTempFile(COVERIMAGE_WORKSPACE_COLLECTION, Long.toString(job.getId()) + "_" + suffix);
            log.debug("Created temporary file {}", (Object)tempFile);
        }
        catch (IOException e) {
            log.warn("Error creating temporary file:", (Throwable)e);
            throw new CoverImageException("Error creating temporary file", (Throwable)e);
        }
        return tempFile;
    }

    protected static void rasterizeSvg(File svgSource, File pngResult) throws CoverImageException {
        SVGConverter converter = new SVGConverter();
        converter.setDestinationType(DestinationType.PNG);
        converter.setDst(pngResult);
        converter.setSources(new String[]{svgSource.getAbsolutePath()});
        try {
            log.debug("Start converting SVG to PNG");
            converter.execute();
        }
        catch (SVGConverterException e) {
            log.warn("Error while converting the SVG to a PNG: {}", (Object)e.getMessage());
            throw new CoverImageException("Error while converting the SVG to a PNG", (Throwable)e);
        }
    }

    protected static enum Operation {
        Generate;

    }
}

