/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.handler;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.message.broker.api.series.SeriesItem;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SearchUpdatedEventHandler.class}, property={"service.description=Search Updated Event Handler"})
public class SearchUpdatedEventHandler {
    protected static final Logger logger = LoggerFactory.getLogger(SearchUpdatedEventHandler.class);
    protected ServiceRegistry serviceRegistry = null;
    protected DistributionService distributionService = null;
    protected SearchService searchService = null;
    protected SecurityService securityService = null;
    protected AuthorizationService authorizationService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected DublinCoreCatalogService dublinCoreService = null;
    protected Workspace workspace = null;
    protected String systemAccount = null;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.systemAccount = bundleContext.getProperty("org.opencastproject.security.digest.user");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setDublinCoreCatalogService(DublinCoreCatalogService dublinCoreService) {
        this.dublinCoreService = dublinCoreService;
    }

    @Reference(target="(distribution.channel=download)")
    public void setDistributionService(DistributionService distributionService) {
        this.distributionService = distributionService;
    }

    @Reference
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SeriesItem seriesItem) {
        logger.debug("Handling {}", (Object)seriesItem);
        String seriesId = seriesItem.getSeriesId();
        int jobBarrierPollingRate = 100;
        User prevUser = this.securityService.getUser();
        Organization prevOrg = this.securityService.getOrganization();
        try {
            this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemAccount, (Organization)prevOrg));
            for (Pair seriesData : this.searchService.getSeries(seriesId)) {
                List mpes;
                MediaPackage mp = (MediaPackage)seriesData.getRight();
                Organization org = (Organization)seriesData.getLeft();
                this.securityService.setOrganization(org);
                if (SeriesItem.Type.UpdateAcl.equals((Object)seriesItem.getType())) {
                    Attachment fileRepoCopy;
                    List mpes2;
                    if (Boolean.TRUE.equals(seriesItem.getOverrideEpisodeAcl())) {
                        MediaPackageElement[] distributedEpisodeAcls;
                        for (MediaPackageElement distributedEpisodeAcl : distributedEpisodeAcls = mp.getElementsByFlavor(MediaPackageElements.XACML_POLICY_EPISODE)) {
                            mpes = this.distributionService.retractSync("engage-player", mp, distributedEpisodeAcl.getIdentifier());
                            if (mpes == null) {
                                logger.error("Unable to retract episode XACML {}", (Object)distributedEpisodeAcl.getIdentifier());
                                continue;
                            }
                            this.authorizationService.removeAcl(mp, AclScope.Episode);
                        }
                    }
                    if ((mpes2 = this.distributionService.distributeSync("engage-player", mp, (fileRepoCopy = (Attachment)this.authorizationService.setAcl(mp, AclScope.Series, seriesItem.getAcl()).getB()).getIdentifier())) != null && mpes2.size() == 1) {
                        mp.remove(fileRepoCopy);
                        mp.add((MediaPackageElement)mpes2.get(0));
                    } else {
                        logger.error("Unable to distribute series XACML {}", (Object)fileRepoCopy.getIdentifier());
                        continue;
                    }
                }
                if (SeriesItem.Type.UpdateCatalog.equals((Object)seriesItem.getType())) {
                    DublinCoreCatalog seriesDublinCore = seriesItem.getMetadata();
                    mp.setSeriesTitle(seriesDublinCore.getFirst(DublinCore.PROPERTY_TITLE));
                    Catalog[] seriesCatalogs = mp.getCatalogs(MediaPackageElements.SERIES);
                    if (seriesCatalogs.length == 1) {
                        Catalog c = seriesCatalogs[0];
                        String filename = FilenameUtils.getName((String)c.getURI().toString());
                        URI uri = this.workspace.put(mp.getIdentifier().toString(), c.getIdentifier(), filename, this.dublinCoreService.serialize(seriesDublinCore));
                        c.setURI(uri);
                        c.setChecksum(null);
                        mpes = this.distributionService.distributeSync("engage-player", mp, c.getIdentifier());
                        if (mpes != null && mpes.size() == 1) {
                            mp.remove(c);
                            mp.add((MediaPackageElement)mpes.get(0));
                        } else {
                            logger.error("Unable to distribute series catalog {}", (Object)c.getIdentifier());
                            continue;
                        }
                    }
                }
                if (SeriesItem.Type.Delete.equals((Object)seriesItem.getType())) {
                    mp.setSeries(null);
                    mp.setSeriesTitle(null);
                    boolean retractSeriesCatalog = this.retractSeriesCatalog(mp);
                    boolean updateEpisodeCatalog = this.updateEpisodeCatalog(mp);
                    if (!retractSeriesCatalog || !updateEpisodeCatalog) continue;
                }
                this.searchService.addSynchronously(mp);
            }
            if (SeriesItem.Type.Delete.equals((Object)seriesItem.getType())) {
                this.searchService.deleteSeries(seriesId);
            }
        }
        catch (SearchException e) {
            logger.warn("Unable to find mediapackages for series {} in search: {}", (Object)seriesItem, (Object)e.getMessage());
        }
        catch (IOException | DistributionException | MediaPackageException | UnauthorizedException | ServiceRegistryException | NotFoundException e) {
            logger.warn("Unable to update mediapackages for series {} for user {}: {} {}", new Object[]{seriesId, prevUser.getUsername(), e.getClass().getSimpleName(), e.getMessage()});
        }
        finally {
            this.securityService.setOrganization(prevOrg);
            this.securityService.setUser(prevUser);
        }
    }

    private boolean retractSeriesCatalog(MediaPackage mp) throws DistributionException {
        for (Catalog c : mp.getCatalogs(MediaPackageElements.SERIES)) {
            Job retractJob = this.distributionService.retract("engage-player", mp, c.getIdentifier());
            JobBarrier barrier = new JobBarrier(null, this.serviceRegistry, new Job[]{retractJob});
            JobBarrier.Result jobResult = barrier.waitForJobs();
            if (!((Job.Status)jobResult.getStatus().get(retractJob)).equals((Object)Job.Status.FINISHED)) {
                logger.error("Unable to retract series catalog {}", (Object)c.getIdentifier());
                return false;
            }
            mp.remove(c);
        }
        return true;
    }

    private boolean updateEpisodeCatalog(MediaPackage mp) throws DistributionException, MediaPackageException, NotFoundException, ServiceRegistryException, IllegalArgumentException, IOException {
        for (Catalog episodeCatalog : mp.getCatalogs(MediaPackageElements.EPISODE)) {
            DublinCoreCatalog episodeDublinCore = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)episodeCatalog);
            episodeDublinCore.remove(DublinCore.PROPERTY_IS_PART_OF);
            String filename = FilenameUtils.getName((String)episodeCatalog.getURI().toString());
            URI uri = this.workspace.put(mp.getIdentifier().toString(), episodeCatalog.getIdentifier(), filename, this.dublinCoreService.serialize(episodeDublinCore));
            episodeCatalog.setURI(uri);
            episodeCatalog.setChecksum(null);
            Job distributionJob = this.distributionService.distribute("engage-player", mp, episodeCatalog.getIdentifier());
            JobBarrier barrier = new JobBarrier(null, this.serviceRegistry, new Job[]{distributionJob});
            JobBarrier.Result jobResult = barrier.waitForJobs();
            if (!((Job.Status)jobResult.getStatus().get(distributionJob)).equals((Object)Job.Status.FINISHED)) {
                logger.error("Unable to distribute episode catalog {}", (Object)episodeCatalog.getIdentifier());
                return false;
            }
            mp.remove(episodeCatalog);
            mp.add(MediaPackageElementParser.getFromXml((String)this.serviceRegistry.getJob(distributionJob.getId()).getPayload()));
        }
        return true;
    }
}

