/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.handler;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.message.broker.api.assetmanager.AssetManagerItem;
import org.opencastproject.oaipmh.persistence.OaiPmhDatabase;
import org.opencastproject.oaipmh.persistence.QueryBuilder;
import org.opencastproject.oaipmh.persistence.SearchResult;
import org.opencastproject.oaipmh.persistence.SearchResultItem;
import org.opencastproject.publication.api.OaiPmhPublicationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, OaiPmhUpdatedEventHandler.class}, property={"service.description=OAI-PMH Updated Event Handler", "service.pid=org.opencastproject.event.handler.OaiPmhUpdatedEventHandler"})
public class OaiPmhUpdatedEventHandler
implements ManagedService {
    protected static final Logger logger = LoggerFactory.getLogger(OaiPmhUpdatedEventHandler.class);
    protected static final String CFG_PROPAGATE_EPISODE = "propagate.episode";
    protected static final String CFG_FLAVORS = "flavors";
    protected static final String CFG_TAGS = "tags";
    private boolean propagateEpisode = false;
    private Set<String> flavors = new HashSet<String>();
    private Set<String> tags = new HashSet<String>();
    private SecurityService securityService = null;
    private OaiPmhDatabase oaiPmhPersistence = null;
    private OaiPmhPublicationService oaiPmhPublicationService = null;
    protected String systemAccount = null;
    protected AssetManager assetManager = null;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.systemAccount = bundleContext.getProperty("org.opencastproject.security.digest.user");
    }

    public void updated(Dictionary<String, ?> dictionary) throws ConfigurationException {
        Option flavorsRaw;
        Option propagateEpisode = OsgiUtil.getOptCfgAsBoolean(dictionary, (String)CFG_PROPAGATE_EPISODE);
        if (propagateEpisode.isSome()) {
            this.propagateEpisode = (Boolean)propagateEpisode.get();
        }
        if ((flavorsRaw = OsgiUtil.getOptCfg(dictionary, (String)CFG_FLAVORS)).isSome()) {
            Object[] flavorStrings = ((String)flavorsRaw.get()).split("\\s*,\\s*");
            this.flavors = Collections.set((Object[])flavorStrings);
        } else {
            this.flavors = new HashSet<String>();
        }
        Option tagsRaw = OsgiUtil.getOptCfg(dictionary, (String)CFG_TAGS);
        if (tagsRaw.isSome()) {
            Object[] tags = ((String)tagsRaw.get()).split("\\s*,\\s*");
            this.tags = Collections.set((Object[])tags);
        } else {
            this.tags = new HashSet<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AssetManagerItem.TakeSnapshot snapshotItem) {
        if (!this.propagateEpisode) {
            logger.trace("Skipping automatic propagation of episode meta data to OAI-PMH since it is turned off.");
            return;
        }
        logger.debug("Handling update event for media package {}", (Object)snapshotItem.getId());
        User prevUser = this.securityService.getUser();
        Organization prevOrg = this.securityService.getOrganization();
        try {
            this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemAccount, (Organization)prevOrg));
            String versionStr = Long.toString(snapshotItem.getVersion());
            AQueryBuilder q = this.assetManager.createQuery();
            AResult snapshotQueryResult = q.select(new Target[]{q.snapshot()}).where(q.organizationId().eq((Object)prevOrg.getId()).and(q.mediaPackageId(snapshotItem.getId()).and(q.version().eq((Object)((Version)this.assetManager.toVersion(versionStr).get()))))).run();
            Optional snapshotRecordOpt = snapshotQueryResult.getRecords().stream().findFirst();
            if (snapshotRecordOpt.isPresent()) {
                Snapshot snapshot = (Snapshot)((ARecord)snapshotRecordOpt.get()).getSnapshot().get();
                MediaPackage snapshotMp = snapshot.getMediaPackage();
                SimpleElementSelector mpeSelector = new SimpleElementSelector();
                for (String flavor : this.flavors) {
                    mpeSelector.addFlavor(flavor);
                }
                for (String tag : this.tags) {
                    mpeSelector.addTag(tag);
                }
                Collection elementsToUpdate = mpeSelector.select(snapshotMp, true);
                if (elementsToUpdate == null || elementsToUpdate.isEmpty()) {
                    logger.debug("The media package {} does not contain any elements matching the given flavors and tags", (Object)snapshotMp.getIdentifier().toString());
                    return;
                }
                SearchResult result = this.oaiPmhPersistence.search(QueryBuilder.query().mediaPackageId(snapshotMp).isDeleted(false).build());
                for (SearchResultItem searchResultItem : result.getItems()) {
                    try {
                        this.oaiPmhPublicationService.updateMetadata(snapshotMp, searchResultItem.getRepository(), this.flavors, this.tags, false);
                    }
                    catch (Exception e) {
                        logger.error("Unable to update OAI-PMH publication for the media package {} in repository {}", new Object[]{snapshotItem.getId(), searchResultItem.getRepository(), e});
                    }
                }
            }
        }
        finally {
            this.securityService.setOrganization(prevOrg);
            this.securityService.setUser(prevUser);
        }
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setOaiPmhPersistence(OaiPmhDatabase oaiPmhPersistence) {
        this.oaiPmhPersistence = oaiPmhPersistence;
    }

    @Reference
    public void setOaiPmhPublicationService(OaiPmhPublicationService oaiPmhPublicationService) {
        this.oaiPmhPublicationService = oaiPmhPublicationService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

