/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.handler;

import org.opencastproject.event.handler.AssetManagerUpdatedEventHandler;
import org.opencastproject.event.handler.SearchUpdatedEventHandler;
import org.opencastproject.message.broker.api.series.SeriesItem;
import org.opencastproject.message.broker.api.update.SeriesUpdateHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SeriesUpdateHandler.class}, property={"service.description=Conducting event handler for series events"})
public class ConductingSeriesUpdatedEventHandler
implements SeriesUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConductingSeriesUpdatedEventHandler.class);
    private AssetManagerUpdatedEventHandler assetManagerUpdatedEventHandler;
    private SearchUpdatedEventHandler searchUpdatedEventHandler;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating {}", (Object)ConductingSeriesUpdatedEventHandler.class.getName());
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating {}", (Object)ConductingSeriesUpdatedEventHandler.class.getName());
    }

    public void execute(SeriesItem seriesItem) {
        if (SeriesItem.Type.UpdateElement.equals((Object)seriesItem.getType())) {
            this.assetManagerUpdatedEventHandler.handleEvent(seriesItem);
        } else if (SeriesItem.Type.UpdateCatalog.equals((Object)seriesItem.getType()) || SeriesItem.Type.UpdateAcl.equals((Object)seriesItem.getType()) || SeriesItem.Type.Delete.equals((Object)seriesItem.getType())) {
            this.searchUpdatedEventHandler.handleEvent(seriesItem);
            this.assetManagerUpdatedEventHandler.handleEvent(seriesItem);
        }
    }

    @Reference
    public void setAssetManagerUpdatedEventHandler(AssetManagerUpdatedEventHandler h) {
        this.assetManagerUpdatedEventHandler = h;
    }

    @Reference
    public void setSearchUpdatedEventHandler(SearchUpdatedEventHandler h) {
        this.searchUpdatedEventHandler = h;
    }
}

