/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.handler;

import org.opencastproject.event.handler.OaiPmhUpdatedEventHandler;
import org.opencastproject.message.broker.api.assetmanager.AssetManagerItem;
import org.opencastproject.message.broker.api.update.AssetManagerUpdateHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AssetManagerUpdateHandler.class}, property={"service.description=Conducting event handler for recording events"})
public class ConductingEpisodeUpdatedEventHandler
implements AssetManagerUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConductingEpisodeUpdatedEventHandler.class);
    private OaiPmhUpdatedEventHandler oaiPmhUpdatedEventHandler;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating {}", (Object)ConductingEpisodeUpdatedEventHandler.class.getName());
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating {}", (Object)ConductingEpisodeUpdatedEventHandler.class.getName());
    }

    public void execute(AssetManagerItem messageItem) {
        if (!(messageItem instanceof AssetManagerItem.TakeSnapshot)) {
            return;
        }
        AssetManagerItem.TakeSnapshot snapshotItem = (AssetManagerItem.TakeSnapshot)messageItem;
        if (AssetManagerItem.Type.Update.equals((Object)snapshotItem.getType()) && this.oaiPmhUpdatedEventHandler != null) {
            this.oaiPmhUpdatedEventHandler.handleEvent(snapshotItem);
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, unbind="unsetOaiPmhUpdatedEventHandler")
    public void setOaiPmhUpdatedEventHandler(OaiPmhUpdatedEventHandler h) {
        this.oaiPmhUpdatedEventHandler = h;
    }

    public void unsetOaiPmhUpdatedEventHandler(OaiPmhUpdatedEventHandler h) {
        this.oaiPmhUpdatedEventHandler = null;
    }
}

