/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.event.handler;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.AssetManagerException;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.message.broker.api.series.SeriesItem;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AssetManagerUpdatedEventHandler.class}, property={"service.description=AssetManagerUpdatedEventHandler"})
public class AssetManagerUpdatedEventHandler {
    protected static final Logger logger = LoggerFactory.getLogger(AssetManagerUpdatedEventHandler.class);
    protected AssetManager assetManager = null;
    protected SecurityService securityService = null;
    protected AuthorizationService authorizationService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected DublinCoreCatalogService dublinCoreService = null;
    protected Workspace workspace = null;
    protected String systemAccount = null;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.systemAccount = bundleContext.getProperty("org.opencastproject.security.digest.user");
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setDublinCoreCatalogService(DublinCoreCatalogService dublinCoreService) {
        this.dublinCoreService = dublinCoreService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SeriesItem seriesItem) {
        logger.debug("Handling {}", (Object)seriesItem);
        String seriesId = seriesItem.getSeriesId();
        User prevUser = this.securityService.getUser();
        Organization prevOrg = this.securityService.getOrganization();
        try {
            this.securityService.setUser(SecurityUtil.createSystemUser((String)this.systemAccount, (Organization)prevOrg));
            AQueryBuilder q = this.assetManager.createQuery();
            AResult result = q.select(new Target[]{q.snapshot()}).where(q.seriesId().eq((Object)seriesId).and(q.version().isLatest())).run();
            List snapshots = Enrichments.enrich((AResult)result).getSnapshots();
            Collections.sort(Enrichments.enrich((AResult)result).getSnapshots(), Comparator.comparing(s -> s.getMediaPackage().getIdentifier().toString()));
            for (Snapshot snapshot : snapshots) {
                String orgId = snapshot.getOrganizationId();
                Organization organization = this.organizationDirectoryService.getOrganization(orgId);
                if (organization == null) {
                    logger.warn("Skipping update of episode {} since organization {} is unknown", (Object)snapshot.getMediaPackage().getIdentifier().toString(), (Object)orgId);
                    continue;
                }
                this.securityService.setOrganization(organization);
                MediaPackage mp = snapshot.getMediaPackage();
                Tuple mpAclAttachmentTuple = null;
                if (SeriesItem.Type.UpdateAcl.equals((Object)seriesItem.getType())) {
                    try {
                        if (seriesItem.getOverrideEpisodeAcl().booleanValue()) {
                            this.authorizationService.removeAcl(mp, AclScope.Episode);
                        }
                        mpAclAttachmentTuple = this.authorizationService.setAcl(mp, AclScope.Series, seriesItem.getAcl());
                    }
                    catch (MediaPackageException e) {
                        logger.error("Error setting ACL for media package {}", (Object)mp.getIdentifier(), (Object)e);
                    }
                }
                if (SeriesItem.Type.UpdateCatalog.equals((Object)seriesItem.getType()) || SeriesItem.Type.UpdateElement.equals((Object)seriesItem.getType())) {
                    Catalog[] seriesDublinCore = null;
                    MediaPackageElementFlavor catalogType = null;
                    if (SeriesItem.Type.UpdateCatalog.equals((Object)seriesItem.getType())) {
                        seriesDublinCore = seriesItem.getMetadata();
                        mp.setSeriesTitle(seriesDublinCore.getFirst(DublinCore.PROPERTY_TITLE));
                        catalogType = MediaPackageElements.SERIES;
                    } else {
                        seriesDublinCore = seriesItem.getExtendedMetadata();
                        catalogType = MediaPackageElementFlavor.flavor((String)seriesItem.getElementType(), (String)"series");
                    }
                    Catalog[] seriesCatalogs = mp.getCatalogs(catalogType);
                    if (seriesCatalogs.length == 1) {
                        Catalog c = seriesCatalogs[0];
                        String filename = FilenameUtils.getName((String)c.getURI().toString());
                        URI uri = this.workspace.put(mp.getIdentifier().toString(), c.getIdentifier(), filename, this.dublinCoreService.serialize((DublinCoreCatalog)seriesDublinCore));
                        c.setURI(uri);
                        c.setChecksum(null);
                    }
                }
                if (SeriesItem.Type.Delete.equals((Object)seriesItem.getType())) {
                    mp.setSeries(null);
                    mp.setSeriesTitle(null);
                    for (Catalog seriesCatalog : mp.getCatalogs(MediaPackageElements.SERIES)) {
                        mp.remove(seriesCatalog);
                    }
                    this.authorizationService.removeAcl(mp, AclScope.Series);
                    for (Catalog episodeCatalog : mp.getCatalogs(MediaPackageElements.EPISODE)) {
                        DublinCoreCatalog episodeDublinCore = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)episodeCatalog);
                        episodeDublinCore.remove(DublinCore.PROPERTY_IS_PART_OF);
                        String filename = FilenameUtils.getName((String)episodeCatalog.getURI().toString());
                        URI uri = this.workspace.put(mp.getIdentifier().toString(), episodeCatalog.getIdentifier(), filename, this.dublinCoreService.serialize(episodeDublinCore));
                        episodeCatalog.setURI(uri);
                        episodeCatalog.setChecksum(null);
                    }
                    MediaPackageElementFlavor seriesFlavor = MediaPackageElementFlavor.flavor((String)"*", (String)"series");
                    for (Catalog catalog : mp.getCatalogs()) {
                        if (!catalog.getFlavor().matches(seriesFlavor)) continue;
                        mp.remove(catalog);
                    }
                }
                try {
                    this.assetManager.takeSnapshot(snapshot.getOwner(), mp);
                }
                catch (AssetManagerException e) {
                    logger.error("Error updating mediapackage {}", (Object)mp.getIdentifier().toString(), (Object)e);
                }
                finally {
                    if (mpAclAttachmentTuple == null) continue;
                    try {
                        this.workspace.delete(((Attachment)mpAclAttachmentTuple.getB()).getURI());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IOException | NotFoundException e) {
            logger.warn("Unable to handle update event for series {} for user {}: {}", new Object[]{seriesItem, prevUser.getUsername(), e.getMessage()});
        }
        finally {
            this.securityService.setOrganization(prevOrg);
            this.securityService.setUser(prevUser);
        }
    }
}

