/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.AbstractMediaPackageElementSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Mux Workflow Operation Handler", "workflow.operation=mux"})
public class MuxWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MuxWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running mux workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.mux(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult mux(WorkflowInstance workflowInstance) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        String srcType;
        MediaPackage src = workflowInstance.getMediaPackage();
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List targetTagsOption = tagsAndFlavors.getTargetTags();
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        TrackSelector elementSelector = new TrackSelector();
        HashMap inputTracks = new HashMap();
        for (MediaPackageElementFlavor srcFlavor : tagsAndFlavors.getSrcFlavors()) {
            elementSelector.addFlavor(srcFlavor);
        }
        for (String srcTag : tagsAndFlavors.getSrcTags()) {
            elementSelector.addTag(srcTag);
        }
        Collection srcTracks = elementSelector.select(mediaPackage, false);
        inputTracks.put("video", srcTracks.stream().toList());
        String sourceFlavorPrefix = "source-flavor-";
        String sourceFlavorsPrefix = "source-flavors-";
        String sourceTagPrefix = "source-tag-";
        String sourceTagsPrefix = "source-tags-";
        for (String flavorConfKey : operation.getConfigurationKeys().stream().filter(confKey -> StringUtils.startsWith((CharSequence)confKey, (CharSequence)"source-flavor-") || StringUtils.startsWith((CharSequence)confKey, (CharSequence)"source-flavors-")).collect(Collectors.toSet())) {
            elementSelector = new TrackSelector();
            for (String srcFlavor : StringUtils.split((String)operation.getConfiguration(flavorConfKey), (String)",")) {
                elementSelector.addFlavor(srcFlavor);
            }
            srcType = StringUtils.split((String)flavorConfKey, (String)"-", (int)3)[2];
            for (String srcTag : operation.getConfigurationKeys().stream().filter(confKey -> StringUtils.equals((CharSequence)confKey, (CharSequence)("source-tag-" + srcType)) || StringUtils.equals((CharSequence)confKey, (CharSequence)("source-tags-" + srcType))).collect(Collectors.toSet())) {
                this.asList(StringUtils.trimToNull((String)srcTag)).stream().filter(Objects::nonNull).forEach(arg_0 -> ((AbstractMediaPackageElementSelector)elementSelector).addTag(arg_0));
            }
            srcTracks = elementSelector.select(mediaPackage, false);
            if (srcTracks.isEmpty()) continue;
            if (inputTracks.containsKey(srcType)) {
                ((List)inputTracks.get(srcType)).addAll(srcTracks);
                continue;
            }
            inputTracks.put(srcType, new ArrayList(srcTracks));
        }
        for (String tagConfKey : operation.getConfigurationKeys().stream().filter(confKey -> StringUtils.startsWith((CharSequence)confKey, (CharSequence)"source-tag-") || StringUtils.startsWith((CharSequence)confKey, (CharSequence)"source-tags-")).collect(Collectors.toSet())) {
            srcType = StringUtils.split((String)tagConfKey, (String)"-", (int)3)[2];
            if (inputTracks.containsKey(srcType)) continue;
            elementSelector = new TrackSelector();
            this.asList(StringUtils.trimToNull((String)operation.getConfiguration(tagConfKey))).stream().filter(Objects::nonNull).forEach(arg_0 -> ((AbstractMediaPackageElementSelector)elementSelector).addTag(arg_0));
            srcTracks = elementSelector.select(mediaPackage, false);
            inputTracks.put(srcType, new ArrayList(srcTracks));
        }
        if (inputTracks.isEmpty()) {
            logger.warn("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        String profileOption = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profile"));
        if (profileOption == null) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        String profileId = StringUtils.trim((String)profileOption);
        EncodingProfile profile = this.composerService.getProfile(profileId);
        if (profile == null) {
            throw new WorkflowOperationException("Encoding profile '" + profileId + "' was not found");
        }
        HashMap<String, Track> muxSourceTracksMap = new HashMap<String, Track>();
        for (String srcType2 : inputTracks.keySet()) {
            List srcTypeTracks = (List)inputTracks.get(srcType2);
            for (int i = 0; i < srcTypeTracks.size(); ++i) {
                muxSourceTracksMap.put(String.format("%s.%d", srcType2, i + 1), (Track)srcTypeTracks.get(i));
            }
        }
        Job muxJob = this.composerService.mux(muxSourceTracksMap, profileId);
        if (!this.waitForStatus(new Job[]{muxJob}).isSuccess()) {
            throw new WorkflowOperationException("Mux job did not complete successfully");
        }
        Track encodedTrack = (Track)MediaPackageElementParser.getFromXml((String)muxJob.getPayload());
        encodedTrack.setFlavor(targetFlavor);
        encodedTrack.setTags(targetTagsOption.toArray(new String[0]));
        String fileName = this.getFileNameFromElements((MediaPackageElement)encodedTrack, (MediaPackageElement)encodedTrack);
        encodedTrack.setURI(this.workspace.moveTo(encodedTrack.getURI(), mediaPackage.getIdentifier().toString(), encodedTrack.getIdentifier(), fileName));
        if (muxSourceTracksMap.size() == 1) {
            mediaPackage.addDerived((MediaPackageElement)encodedTrack, (MediaPackageElement)muxSourceTracksMap.get(0));
        } else {
            mediaPackage.add(encodedTrack);
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        logger.debug("Mux operation completed");
        return result;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

