/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Encode Workflow Operation Handler", "workflow.operation=encode"})
public class EncodeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(EncodeWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running parallel encoding workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.encode(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult encode(WorkflowInstance workflowInstance) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        EncodingProfile profile;
        MediaPackage src = workflowInstance.getMediaPackage();
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List targetTagsOption = tagsAndFlavors.getTargetTags();
        List sourceFlavorsOption = tagsAndFlavors.getSrcFlavors();
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        TrackSelector elementSelector = new TrackSelector();
        if (sourceTagsOption.isEmpty() && sourceFlavorsOption.isEmpty()) {
            logger.warn("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        for (MediaPackageElementFlavor flavor : sourceFlavorsOption) {
            elementSelector.addFlavor(flavor);
        }
        for (String tag : sourceTagsOption) {
            elementSelector.addTag(tag);
        }
        String profilesOption = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profiles"));
        ArrayList<EncodingProfile> profiles = new ArrayList<EncodingProfile>();
        for (String profileName : this.asList(profilesOption)) {
            profile = this.composerService.getProfile(profileName);
            if (profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + profileName + "' was not found");
            }
            profiles.add(profile);
        }
        String profileOption = StringUtils.trimToNull((String)operation.getConfiguration("encoding-profile"));
        if (StringUtils.isNotBlank((CharSequence)profileOption)) {
            String profileId = StringUtils.trim((String)profileOption);
            profile = this.composerService.getProfile(profileId);
            if (profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + profileId + "' was not found");
            }
            profiles.add(profile);
        }
        if (profiles.isEmpty()) {
            throw new WorkflowOperationException("No encoding profile was specified");
        }
        Collection elements = elementSelector.select(mediaPackage, false);
        long totalTimeInQueue = 0L;
        HashMap<Job, JobInformation> encodingJobs = new HashMap<Job, JobInformation>();
        for (Track track : elements) {
            for (EncodingProfile profile2 : profiles) {
                EncodingProfile.MediaType inputType = profile2.getApplicableMediaType();
                if (inputType.equals((Object)EncodingProfile.MediaType.Audio) && !track.hasAudio()) {
                    logger.info("Skipping encoding of '{}', since it lacks an audio stream", (Object)track);
                    continue;
                }
                if (inputType.equals((Object)EncodingProfile.MediaType.Visual) && !track.hasVideo()) {
                    logger.info("Skipping encoding of '{}', since it lacks a video stream", (Object)track);
                    continue;
                }
                logger.info("Encoding track {} using encoding profile '{}'", (Object)track, (Object)profile2);
                encodingJobs.put(this.composerService.parallelEncode(track, profile2.getIdentifier()), new JobInformation(track, profile2));
            }
        }
        if (encodingJobs.isEmpty()) {
            logger.info("No matching tracks found");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (!this.waitForStatus(encodingJobs.keySet().toArray(new Job[encodingJobs.size()])).isSuccess()) {
            throw new WorkflowOperationException("One of the encoding jobs did not complete successfully");
        }
        for (Map.Entry entry : encodingJobs.entrySet()) {
            Job job = (Job)entry.getKey();
            Track track = ((JobInformation)entry.getValue()).getTrack();
            totalTimeInQueue += job.getQueueTime().longValue();
            if (job.getPayload().length() <= 0) continue;
            List composedTracks = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
            for (Track encodedTrack : composedTracks) {
                for (String tag : targetTagsOption) {
                    logger.trace("Tagging composed track {} with '{}'", (Object)encodedTrack.toString(), (Object)tag);
                    encodedTrack.addTag(tag);
                }
            }
            if (targetFlavor != null) {
                String flavorType = targetFlavor.getType();
                String flavorSubtype = targetFlavor.getSubtype();
                if ("*".equals(flavorType)) {
                    flavorType = track.getFlavor().getType();
                }
                if ("*".equals(flavorSubtype)) {
                    flavorSubtype = track.getFlavor().getSubtype();
                }
                for (Track encodedTrack : composedTracks) {
                    encodedTrack.setFlavor(new MediaPackageElementFlavor(flavorType, flavorSubtype));
                    logger.debug("Composed track {} has flavor '{}'", (Object)encodedTrack.toString(), (Object)encodedTrack.getFlavor());
                }
            }
            for (Track encodedTrack : composedTracks) {
                mediaPackage.addDerived((MediaPackageElement)encodedTrack, (MediaPackageElement)track);
                String fileName = this.getFileNameFromElements((MediaPackageElement)track, (MediaPackageElement)encodedTrack);
                encodedTrack.setURI(this.workspace.moveTo(encodedTrack.getURI(), mediaPackage.getIdentifier().toString(), encodedTrack.getIdentifier(), fileName));
            }
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
        logger.debug("Parallel encode operation completed");
        return result;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    private static final class JobInformation {
        private Track track = null;
        private EncodingProfile profile = null;

        JobInformation(Track track, EncodingProfile profile) {
            this.track = track;
            this.profile = profile;
        }

        public Track getTrack() {
            return this.track;
        }

        public EncodingProfile getProfile() {
            return this.profile;
        }
    }
}

