/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.api.LaidOutElement;
import org.opencastproject.composer.layout.AbsolutePositionLayoutSpec;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.composer.layout.HorizontalCoverageLayoutSpec;
import org.opencastproject.composer.layout.Layout;
import org.opencastproject.composer.layout.LayoutManager;
import org.opencastproject.composer.layout.MultiShapeLayout;
import org.opencastproject.composer.layout.Serializer;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.attachment.AttachmentImpl;
import org.opencastproject.mediapackage.selector.AbstractMediaPackageElementSelector;
import org.opencastproject.mediapackage.selector.AttachmentSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.JsonObj;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Composite Workflow Operation Handler", "workflow.operation=composite"})
public class CompositeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String COLLECTION = "composite";
    private static final String SOURCE_AUDIO_NAME = "source-audio-name";
    private static final String SOURCE_TAGS_UPPER = "source-tags-upper";
    private static final String SOURCE_FLAVOR_UPPER = "source-flavor-upper";
    private static final String SOURCE_TAGS_LOWER = "source-tags-lower";
    private static final String SOURCE_FLAVOR_LOWER = "source-flavor-lower";
    private static final String SOURCE_TAGS_WATERMARK = "source-tags-watermark";
    private static final String SOURCE_FLAVOR_WATERMARK = "source-flavor-watermark";
    private static final String SOURCE_URL_WATERMARK = "source-url-watermark";
    private static final String ENCODING_PROFILE = "encoding-profile";
    private static final String LAYOUT = "layout";
    private static final String LAYOUT_MULTIPLE = "layout-multiple";
    private static final String LAYOUT_SINGLE = "layout-single";
    private static final String LAYOUT_PREFIX = "layout-";
    private static final String OUTPUT_RESOLUTION = "output-resolution";
    private static final String OUTPUT_BACKGROUND = "output-background";
    private static final String DEFAULT_BG_COLOR = "black";
    private static final Logger logger = LoggerFactory.getLogger(CompositeWorkflowOperationHandler.class);
    private static final Pattern sourceAudioOption = Pattern.compile("lower|upper|both", 2);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running composite workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.composite(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WorkflowOperationResult composite(WorkflowInstance wi) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        Iterator iterator;
        CompositeSettings compositeSettings;
        MediaPackage src = wi.getMediaPackage();
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        try {
            compositeSettings = new CompositeSettings(wi);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to parse composite settings because", (Throwable)e);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        Option watermarkAttachment = Option.none();
        Collection watermarkElements = compositeSettings.getWatermarkSelector().select(mediaPackage, false);
        if (watermarkElements.size() > 1) {
            logger.warn("More than one watermark attachment has been found for compositing, skipping compositing!: {}", (Object)watermarkElements);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (watermarkElements.size() == 0 && compositeSettings.getSourceUrlWatermark() != null) {
            logger.info("No watermark found from flavor and tags, take watermark from URL {}", (Object)compositeSettings.getSourceUrlWatermark());
            AttachmentImpl urlAttachment = new AttachmentImpl();
            urlAttachment.setIdentifier(compositeSettings.getWatermarkIdentifier());
            if (compositeSettings.getSourceUrlWatermark().startsWith("http")) {
                urlAttachment.setURI(UrlSupport.uri((String)compositeSettings.getSourceUrlWatermark()));
            } else {
                InputStream in = null;
                try {
                    in = UrlSupport.url((String)compositeSettings.getSourceUrlWatermark()).openStream();
                    URI imageUrl = this.workspace.putInCollection(COLLECTION, compositeSettings.getWatermarkIdentifier() + "." + FilenameUtils.getExtension((String)compositeSettings.getSourceUrlWatermark()), in);
                    urlAttachment.setURI(imageUrl);
                }
                catch (Exception e) {
                    try {
                        logger.warn("Unable to read watermark source url {}: {}", (Object)compositeSettings.getSourceUrlWatermark(), (Object)e);
                        throw new WorkflowOperationException("Unable to read watermark source url " + compositeSettings.getSourceUrlWatermark(), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            watermarkAttachment = Option.option((Object)urlAttachment);
        } else if (watermarkElements.size() == 0 && compositeSettings.getSourceUrlWatermark() == null) {
            logger.info("No watermark to composite");
        } else {
            for (Attachment a : watermarkElements) {
                watermarkAttachment = Option.option((Object)a);
            }
        }
        Collection upperElements = compositeSettings.getUpperTrackSelector().select(mediaPackage, false);
        Collection lowerElements = compositeSettings.getLowerTrackSelector().select(mediaPackage, false);
        if (upperElements.size() == 1 && lowerElements.size() == 0 || upperElements.size() == 0 && lowerElements.size() == 1) {
            for (Track t : upperElements) {
                compositeSettings.setSingleTrack(t);
            }
            iterator = lowerElements.iterator();
            while (true) {
                Track t;
                if (!iterator.hasNext()) {
                    return this.handleSingleTrack(mediaPackage, compositeSettings, (Option<Attachment>)watermarkAttachment);
                }
                t = (Track)iterator.next();
                compositeSettings.setSingleTrack(t);
            }
        }
        if (upperElements.size() > 1) {
            logger.warn("More than one upper track has been found for compositing, skipping compositing!: {}", (Object)upperElements);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (upperElements.size() == 0) {
            logger.warn("No upper track has been found for compositing, skipping compositing!");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        for (Track t : upperElements) {
            compositeSettings.setUpperTrack(t);
        }
        if (lowerElements.size() > 1) {
            logger.warn("More than one lower track has been found for compositing, skipping compositing!: {}", (Object)lowerElements);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (lowerElements.size() == 0) {
            logger.warn("No lower track has been found for compositing, skipping compositing!");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        iterator = lowerElements.iterator();
        while (iterator.hasNext()) {
            Track t;
            t = (Track)iterator.next();
            compositeSettings.setLowerTrack(t);
        }
        return this.handleMultipleTracks(mediaPackage, compositeSettings, (Option<Attachment>)watermarkAttachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowOperationResult handleSingleTrack(MediaPackage mediaPackage, CompositeSettings compositeSettings, Option<Attachment> watermarkAttachment) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        if (compositeSettings.getSingleSourceLayout() == null) {
            throw new WorkflowOperationException("Single video layout must be set! Please verify that you have a layout-single property in your composite operation in your workflow definition.");
        }
        try {
            VideoStream[] videoStreams = (VideoStream[])TrackSupport.byType((Stream[])compositeSettings.getSingleTrack().getStreams(), VideoStream.class);
            if (videoStreams.length == 0) {
                logger.warn("No video stream available to compose! {}", (Object)compositeSettings.getSingleTrack());
                WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                return workflowOperationResult;
            }
            Dimension videoDimension = Dimension.dimension((int)videoStreams[0].getFrameWidth(), (int)videoStreams[0].getFrameHeight());
            ArrayList<Tuple> shapes = new ArrayList<Tuple>();
            shapes.add(0, Tuple.tuple((Object)videoDimension, (Object)compositeSettings.getSingleSourceLayout()));
            Dimension outputDimension = null;
            String outputResolutionSource = compositeSettings.getOutputResolutionSource();
            if (outputResolutionSource.equals("fixed")) {
                outputDimension = compositeSettings.getOutputDimension();
            } else if (outputResolutionSource.equals("lower")) {
                outputDimension = videoDimension;
            } else if (outputResolutionSource.equals("upper")) {
                outputDimension = videoDimension;
            }
            MultiShapeLayout multiShapeLayout = LayoutManager.multiShapeLayout((Dimension)outputDimension, shapes);
            LaidOutElement lowerLaidOutElement = new LaidOutElement((MediaPackageElement)compositeSettings.getSingleTrack(), (Layout)multiShapeLayout.getShapes().get(0));
            Option<LaidOutElement<Attachment>> watermarkOption = this.createWatermarkLaidOutElement(compositeSettings, outputDimension, watermarkAttachment);
            Job compositeJob = this.composerService.composite(outputDimension, Option.none(), lowerLaidOutElement, watermarkOption, compositeSettings.getProfile().getIdentifier(), compositeSettings.getOutputBackground(), compositeSettings.getSourceAudioName());
            if (!this.waitForStatus(new Job[]{compositeJob}).isSuccess()) {
                throw new WorkflowOperationException("The composite job did not complete successfully");
            }
            if (compositeJob.getPayload().length() > 0) {
                Track compoundTrack = (Track)MediaPackageElementParser.getFromXml((String)compositeJob.getPayload());
                compoundTrack.setURI(this.workspace.moveTo(compoundTrack.getURI(), mediaPackage.getIdentifier().toString(), compoundTrack.getIdentifier(), "composite." + FilenameUtils.getExtension((String)compoundTrack.getURI().toString())));
                for (String tag : compositeSettings.getTargetTags()) {
                    logger.trace("Tagging compound track with '{}'", (Object)tag);
                    compoundTrack.addTag(tag);
                }
                compoundTrack.setFlavor(compositeSettings.getTargetFlavor());
                logger.debug("Compound track has flavor '{}'", (Object)compoundTrack.getFlavor());
                mediaPackage.add(compoundTrack);
                WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, compositeJob.getQueueTime());
                logger.debug("Composite operation completed");
                WorkflowOperationResult workflowOperationResult = result;
                return workflowOperationResult;
            }
            logger.info("Composite operation unsuccessful, no payload returned: {}", (Object)compositeJob);
            WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            return workflowOperationResult;
        }
        finally {
            if (compositeSettings.getSourceUrlWatermark() != null) {
                this.workspace.deleteFromCollection(COLLECTION, compositeSettings.getWatermarkIdentifier() + "." + FilenameUtils.getExtension((String)compositeSettings.getSourceUrlWatermark()));
            }
        }
    }

    private Option<LaidOutElement<Attachment>> createWatermarkLaidOutElement(CompositeSettings compositeSettings, Dimension outputDimension, Option<Attachment> watermarkAttachment) throws WorkflowOperationException {
        Option watermarkOption = Option.none();
        if (watermarkAttachment.isSome() && compositeSettings.getWatermarkLayout().isSome()) {
            BufferedImage image;
            try {
                File watermarkFile = this.workspace.get(((Attachment)watermarkAttachment.get()).getURI());
                image = ImageIO.read(watermarkFile);
            }
            catch (Exception e) {
                logger.warn("Unable to read the watermark image attachment {}: {}", (Object)((Attachment)watermarkAttachment.get()).getURI(), (Object)e);
                throw new WorkflowOperationException("Unable to read the watermark image attachment", (Throwable)e);
            }
            Dimension imageDimension = Dimension.dimension((int)image.getWidth(), (int)image.getHeight());
            ArrayList<Tuple> watermarkShapes = new ArrayList<Tuple>();
            watermarkShapes.add(0, Tuple.tuple((Object)imageDimension, (Object)((AbsolutePositionLayoutSpec)compositeSettings.getWatermarkLayout().get())));
            MultiShapeLayout watermarkLayout = LayoutManager.absoluteMultiShapeLayout((Dimension)outputDimension, watermarkShapes);
            watermarkOption = Option.some((Object)new LaidOutElement((MediaPackageElement)((Attachment)watermarkAttachment.get()), (Layout)watermarkLayout.getShapes().get(0)));
        }
        return watermarkOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowOperationResult handleMultipleTracks(MediaPackage mediaPackage, CompositeSettings compositeSettings, Option<Attachment> watermarkAttachment) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        if (compositeSettings.getMultiSourceLayouts() == null || compositeSettings.getMultiSourceLayouts().size() == 0) {
            throw new WorkflowOperationException("Multi video layout must be set! Please verify that you have a layout-multiple or layout property in your composite operation in your workflow definition to be able to handle multiple videos");
        }
        try {
            Track upperTrack = compositeSettings.getUpperTrack();
            Track lowerTrack = compositeSettings.getLowerTrack();
            List<HorizontalCoverageLayoutSpec> layouts = compositeSettings.getMultiSourceLayouts();
            VideoStream[] upperVideoStreams = (VideoStream[])TrackSupport.byType((Stream[])upperTrack.getStreams(), VideoStream.class);
            if (upperVideoStreams.length == 0) {
                logger.warn("No video stream available in the upper track! {}", (Object)upperTrack);
                WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                return workflowOperationResult;
            }
            VideoStream[] lowerVideoStreams = (VideoStream[])TrackSupport.byType((Stream[])lowerTrack.getStreams(), VideoStream.class);
            if (lowerVideoStreams.length == 0) {
                logger.warn("No video stream available in the lower track! {}", (Object)lowerTrack);
                WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                return workflowOperationResult;
            }
            Dimension upperDimensions = Dimension.dimension((int)upperVideoStreams[0].getFrameWidth(), (int)upperVideoStreams[0].getFrameHeight());
            Dimension lowerDimensions = Dimension.dimension((int)lowerVideoStreams[0].getFrameWidth(), (int)lowerVideoStreams[0].getFrameHeight());
            Dimension outputDimension = null;
            String outputResolutionSource = compositeSettings.getOutputResolutionSource();
            if (outputResolutionSource.equals("fixed")) {
                outputDimension = compositeSettings.getOutputDimension();
            } else if (outputResolutionSource.equals("lower")) {
                outputDimension = lowerDimensions;
            } else if (outputResolutionSource.equals("upper")) {
                outputDimension = upperDimensions;
            }
            ArrayList<Tuple> shapes = new ArrayList<Tuple>();
            shapes.add(0, Tuple.tuple((Object)lowerDimensions, (Object)layouts.get(0)));
            shapes.add(1, Tuple.tuple((Object)upperDimensions, (Object)layouts.get(1)));
            MultiShapeLayout multiShapeLayout = LayoutManager.multiShapeLayout((Dimension)outputDimension, shapes);
            LaidOutElement lowerLaidOutElement = new LaidOutElement((MediaPackageElement)lowerTrack, (Layout)multiShapeLayout.getShapes().get(0));
            LaidOutElement upperLaidOutElement = new LaidOutElement((MediaPackageElement)upperTrack, (Layout)multiShapeLayout.getShapes().get(1));
            Option<LaidOutElement<Attachment>> watermarkOption = this.createWatermarkLaidOutElement(compositeSettings, outputDimension, watermarkAttachment);
            Job compositeJob = this.composerService.composite(outputDimension, Option.option((Object)upperLaidOutElement), lowerLaidOutElement, watermarkOption, compositeSettings.getProfile().getIdentifier(), compositeSettings.getOutputBackground(), compositeSettings.getSourceAudioName());
            if (!this.waitForStatus(new Job[]{compositeJob}).isSuccess()) {
                throw new WorkflowOperationException("The composite job did not complete successfully");
            }
            if (compositeJob.getPayload().length() > 0) {
                Track compoundTrack = (Track)MediaPackageElementParser.getFromXml((String)compositeJob.getPayload());
                compoundTrack.setURI(this.workspace.moveTo(compoundTrack.getURI(), mediaPackage.getIdentifier().toString(), compoundTrack.getIdentifier(), "composite." + FilenameUtils.getExtension((String)compoundTrack.getURI().toString())));
                for (String tag : compositeSettings.getTargetTags()) {
                    logger.trace("Tagging compound track with '{}'", (Object)tag);
                    compoundTrack.addTag(tag);
                }
                compoundTrack.setFlavor(compositeSettings.getTargetFlavor());
                logger.debug("Compound track has flavor '{}'", (Object)compoundTrack.getFlavor());
                mediaPackage.add(compoundTrack);
                WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, compositeJob.getQueueTime());
                logger.debug("Composite operation completed");
                WorkflowOperationResult workflowOperationResult = result;
                return workflowOperationResult;
            }
            logger.info("Composite operation unsuccessful, no payload returned: {}", (Object)compositeJob);
            WorkflowOperationResult workflowOperationResult = this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            return workflowOperationResult;
        }
        finally {
            if (compositeSettings.getSourceUrlWatermark() != null) {
                this.workspace.deleteFromCollection(COLLECTION, compositeSettings.getWatermarkIdentifier() + "." + FilenameUtils.getExtension((String)compositeSettings.getSourceUrlWatermark()));
            }
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    private class CompositeSettings {
        public static final String OUTPUT_RESOLUTION_FIXED = "fixed";
        public static final String OUTPUT_RESOLUTION_LOWER = "lower";
        public static final String OUTPUT_RESOLUTION_UPPER = "upper";
        private String sourceAudioName;
        private String sourceTagsUpper;
        private String sourceFlavorUpper;
        private String sourceTagsLower;
        private String sourceFlavorLower;
        private String sourceTagsWatermark;
        private String sourceFlavorWatermark;
        private String sourceUrlWatermark;
        private String encodingProfile;
        private String layoutMultipleString;
        private String layoutSingleString;
        private String outputResolution;
        private String outputBackground;
        private AbstractMediaPackageElementSelector<Track> upperTrackSelector = new TrackSelector();
        private AbstractMediaPackageElementSelector<Track> lowerTrackSelector = new TrackSelector();
        private AbstractMediaPackageElementSelector<Attachment> watermarkSelector = new AttachmentSelector();
        private String watermarkIdentifier;
        private Option<AbsolutePositionLayoutSpec> watermarkLayout = Option.none();
        private List<HorizontalCoverageLayoutSpec> multiSourceLayouts = new ArrayList<HorizontalCoverageLayoutSpec>();
        private HorizontalCoverageLayoutSpec singleSourceLayout;
        private Track upperTrack;
        private Track lowerTrack;
        private Track singleTrack;
        private String outputResolutionSource;
        private Dimension outputDimension;
        private EncodingProfile profile;
        private List<String> targetTags;
        private MediaPackageElementFlavor targetFlavor = null;

        CompositeSettings(WorkflowInstance wi) throws WorkflowOperationException {
            WorkflowOperationInstance operation = wi.getCurrentOperation();
            ConfiguredTagsAndFlavors tagsAndFlavors = CompositeWorkflowOperationHandler.this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
            this.sourceAudioName = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_AUDIO_NAME));
            if (this.sourceAudioName == null) {
                this.sourceAudioName = "both";
            } else if (!sourceAudioOption.matcher(this.sourceAudioName).matches()) {
                throw new WorkflowOperationException("sourceAudioName if used, must be either upper, lower or both!");
            }
            this.sourceTagsUpper = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_TAGS_UPPER));
            this.sourceFlavorUpper = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_FLAVOR_UPPER));
            this.sourceTagsLower = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_TAGS_LOWER));
            this.sourceFlavorLower = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_FLAVOR_LOWER));
            this.sourceTagsWatermark = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_TAGS_WATERMARK));
            this.sourceFlavorWatermark = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_FLAVOR_WATERMARK));
            this.sourceUrlWatermark = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.SOURCE_URL_WATERMARK));
            this.targetTags = tagsAndFlavors.getTargetTags();
            this.targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
            this.encodingProfile = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.ENCODING_PROFILE));
            this.layoutMultipleString = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.LAYOUT_MULTIPLE));
            if (this.layoutMultipleString == null) {
                this.layoutMultipleString = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.LAYOUT));
            }
            if (this.layoutMultipleString != null && !this.layoutMultipleString.contains(";")) {
                this.layoutMultipleString = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.LAYOUT_PREFIX + this.layoutMultipleString));
            }
            this.layoutSingleString = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.LAYOUT_SINGLE));
            this.outputResolution = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.OUTPUT_RESOLUTION));
            this.outputBackground = StringUtils.trimToNull((String)operation.getConfiguration(CompositeWorkflowOperationHandler.OUTPUT_BACKGROUND));
            this.watermarkIdentifier = UUID.randomUUID().toString();
            if (this.outputBackground == null) {
                this.outputBackground = CompositeWorkflowOperationHandler.DEFAULT_BG_COLOR;
            }
            if (this.layoutMultipleString != null) {
                Tuple<List<HorizontalCoverageLayoutSpec>, Option<AbsolutePositionLayoutSpec>> multipleLayouts = this.parseMultipleLayouts(this.layoutMultipleString);
                this.multiSourceLayouts.addAll((Collection)multipleLayouts.getA());
                this.watermarkLayout = (Option)multipleLayouts.getB();
            }
            if (this.layoutSingleString != null) {
                Tuple<HorizontalCoverageLayoutSpec, Option<AbsolutePositionLayoutSpec>> singleLayouts = this.parseSingleLayouts(this.layoutSingleString);
                this.singleSourceLayout = (HorizontalCoverageLayoutSpec)singleLayouts.getA();
                this.watermarkLayout = (Option)singleLayouts.getB();
            }
            if (this.encodingProfile == null) {
                throw new WorkflowOperationException("Encoding profile must be set!");
            }
            this.profile = CompositeWorkflowOperationHandler.this.composerService.getProfile(this.encodingProfile);
            if (this.profile == null) {
                throw new WorkflowOperationException("Encoding profile '" + this.encodingProfile + "' was not found");
            }
            if (this.outputResolution == null) {
                throw new WorkflowOperationException("Output resolution must be set!");
            }
            if (this.outputResolution.equals(OUTPUT_RESOLUTION_LOWER) || this.outputResolution.equals(OUTPUT_RESOLUTION_UPPER)) {
                this.outputResolutionSource = this.outputResolution;
            } else {
                this.outputResolutionSource = OUTPUT_RESOLUTION_FIXED;
                try {
                    String[] outputResolutionArray = StringUtils.split((String)this.outputResolution, (String)"x");
                    if (outputResolutionArray.length != 2) {
                        throw new WorkflowOperationException("Invalid format of output resolution!");
                    }
                    this.outputDimension = Dimension.dimension((int)Integer.parseInt(outputResolutionArray[0]), (int)Integer.parseInt(outputResolutionArray[1]));
                }
                catch (Exception e) {
                    throw new WorkflowOperationException("Unable to parse output resolution!", (Throwable)e);
                }
            }
            if (this.sourceTagsUpper == null && this.sourceFlavorUpper == null) {
                throw new IllegalArgumentException("No source tags or flavor for the upper video have been specified, not matching anything");
            }
            if (this.sourceTagsLower == null && this.sourceFlavorLower == null) {
                throw new IllegalArgumentException("No source tags or flavor for the lower video have been specified, not matching anything");
            }
            try {
                if ("*".equals(this.targetFlavor.getType()) || "*".equals(this.targetFlavor.getSubtype())) {
                    throw new WorkflowOperationException("Target flavor must have a type and a subtype, '*' are not allowed!");
                }
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Target flavor '" + this.targetFlavor + "' is malformed");
            }
            if (this.sourceFlavorUpper != null) {
                try {
                    this.upperTrackSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)this.sourceFlavorUpper));
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException("Source upper flavor '" + this.sourceFlavorUpper + "' is malformed");
                }
            }
            if (this.sourceFlavorLower != null) {
                try {
                    this.lowerTrackSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)this.sourceFlavorLower));
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException("Source lower flavor '" + this.sourceFlavorLower + "' is malformed");
                }
            }
            if (this.sourceFlavorWatermark != null) {
                try {
                    this.watermarkSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)this.sourceFlavorWatermark));
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException("Source watermark flavor '" + this.sourceFlavorWatermark + "' is malformed");
                }
            }
            for (String tag : CompositeWorkflowOperationHandler.this.asList(this.sourceTagsUpper)) {
                this.upperTrackSelector.addTag(tag);
            }
            for (String tag : CompositeWorkflowOperationHandler.this.asList(this.sourceTagsLower)) {
                this.lowerTrackSelector.addTag(tag);
            }
            for (String tag : CompositeWorkflowOperationHandler.this.asList(this.sourceTagsWatermark)) {
                this.watermarkSelector.addTag(tag);
            }
        }

        private Tuple<List<HorizontalCoverageLayoutSpec>, Option<AbsolutePositionLayoutSpec>> parseMultipleLayouts(String layoutString) throws WorkflowOperationException {
            try {
                String[] layouts = StringUtils.split((String)layoutString, (String)";");
                if (layouts.length < 2) {
                    throw new WorkflowOperationException("Multiple layout doesn't contain the required layouts for (lower, upper, optional watermark)");
                }
                List multipleLayouts = Collections.list((Object[])new HorizontalCoverageLayoutSpec[]{Serializer.horizontalCoverageLayoutSpec((JsonObj)JsonObj.jsonObj((String)layouts[0])), Serializer.horizontalCoverageLayoutSpec((JsonObj)JsonObj.jsonObj((String)layouts[1]))});
                AbsolutePositionLayoutSpec watermarkLayout = null;
                if (layouts.length > 2) {
                    watermarkLayout = Serializer.absolutePositionLayoutSpec((JsonObj)JsonObj.jsonObj((String)layouts[2]));
                }
                return Tuple.tuple((Object)multipleLayouts, (Object)Option.option(watermarkLayout));
            }
            catch (Exception e) {
                throw new WorkflowOperationException("Unable to parse layout!", (Throwable)e);
            }
        }

        private Tuple<HorizontalCoverageLayoutSpec, Option<AbsolutePositionLayoutSpec>> parseSingleLayouts(String layoutString) throws WorkflowOperationException {
            try {
                String[] layouts = StringUtils.split((String)layoutString, (String)";");
                if (layouts.length < 1) {
                    throw new WorkflowOperationException("Single layout doesn't contain the required layouts for (video, optional watermark)");
                }
                HorizontalCoverageLayoutSpec singleLayout = Serializer.horizontalCoverageLayoutSpec((JsonObj)JsonObj.jsonObj((String)layouts[0]));
                AbsolutePositionLayoutSpec watermarkLayout = null;
                if (layouts.length > 1) {
                    watermarkLayout = Serializer.absolutePositionLayoutSpec((JsonObj)JsonObj.jsonObj((String)layouts[1]));
                }
                return Tuple.tuple((Object)singleLayout, (Object)Option.option(watermarkLayout));
            }
            catch (Exception e) {
                throw new WorkflowOperationException("Unable to parse layout!", (Throwable)e);
            }
        }

        public String getSourceUrlWatermark() {
            return this.sourceUrlWatermark;
        }

        public MediaPackageElementFlavor getTargetFlavor() {
            return this.targetFlavor;
        }

        public List<String> getTargetTags() {
            return this.targetTags;
        }

        public String getSourceAudioName() {
            return this.sourceAudioName;
        }

        public String getOutputBackground() {
            return this.outputBackground;
        }

        public AbstractMediaPackageElementSelector<Track> getUpperTrackSelector() {
            return this.upperTrackSelector;
        }

        public AbstractMediaPackageElementSelector<Track> getLowerTrackSelector() {
            return this.lowerTrackSelector;
        }

        public AbstractMediaPackageElementSelector<Attachment> getWatermarkSelector() {
            return this.watermarkSelector;
        }

        public String getWatermarkIdentifier() {
            return this.watermarkIdentifier;
        }

        public Option<AbsolutePositionLayoutSpec> getWatermarkLayout() {
            return this.watermarkLayout;
        }

        public List<HorizontalCoverageLayoutSpec> getMultiSourceLayouts() {
            return this.multiSourceLayouts;
        }

        public HorizontalCoverageLayoutSpec getSingleSourceLayout() {
            return this.singleSourceLayout;
        }

        public Track getUpperTrack() {
            return this.upperTrack;
        }

        public void setUpperTrack(Track upperTrack) {
            this.upperTrack = upperTrack;
        }

        public Track getLowerTrack() {
            return this.lowerTrack;
        }

        public void setLowerTrack(Track lowerTrack) {
            this.lowerTrack = lowerTrack;
        }

        public Track getSingleTrack() {
            return this.singleTrack;
        }

        public void setSingleTrack(Track singleTrack) {
            this.singleTrack = singleTrack;
        }

        public String getOutputResolutionSource() {
            return this.outputResolutionSource;
        }

        public Dimension getOutputDimension() {
            return this.outputDimension;
        }

        public EncodingProfile getProfile() {
            return this.profile;
        }
    }
}

