/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.layout;

import java.util.List;
import org.opencastproject.composer.layout.AbsolutePositionLayoutSpec;
import org.opencastproject.composer.layout.Anchor;
import org.opencastproject.composer.layout.AnchorOffset;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.composer.layout.HorizontalCoverageLayoutSpec;
import org.opencastproject.composer.layout.Layout;
import org.opencastproject.composer.layout.MultiShapeLayout;
import org.opencastproject.composer.layout.Offset;
import org.opencastproject.composer.layout.TwoShapeLayout;
import org.opencastproject.composer.layout.TwoShapeLayouts;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Tuple;

public final class LayoutManager {
    private LayoutManager() {
    }

    public static TwoShapeLayout twoShapeLayout(Dimension canvas, Dimension upper, Dimension lower, TwoShapeLayouts.TwoShapeLayoutSpec spec) {
        return new TwoShapeLayout(canvas, LayoutManager.calcLayout(canvas, upper, spec.getUpper()), LayoutManager.calcLayout(canvas, lower, spec.getLower()));
    }

    private static Layout calcLayout(Dimension canvas, Dimension shape, HorizontalCoverageLayoutSpec posSpec) {
        Dimension slice = new Dimension(LayoutManager.limitMin((double)canvas.getWidth() * posSpec.getHorizontalCoverage(), 0), canvas.getHeight());
        Dimension scaled = LayoutManager.scaleToFit(slice, shape);
        AnchorOffset dist = posSpec.getAnchorOffset();
        Offset anchorOfReference = LayoutManager.offset(dist.getReferenceAnchor(), canvas);
        Offset anchorOfReferring = LayoutManager.offset(dist.getReferringAnchor(), scaled);
        return new Layout(scaled, new Offset(LayoutManager.limitMin(anchorOfReference.getX() + dist.getOffset().getX() - anchorOfReferring.getX(), 0), LayoutManager.limitMin(anchorOfReference.getY() + dist.getOffset().getY() - anchorOfReferring.getY(), 0)));
    }

    private static Layout calcLayout(Dimension canvas, Dimension shape, AbsolutePositionLayoutSpec posSpec) {
        AnchorOffset dist = posSpec.getAnchorOffset();
        Offset anchorOfReference = LayoutManager.offset(dist.getReferenceAnchor(), canvas);
        Offset anchorOfReferring = LayoutManager.offset(dist.getReferringAnchor(), shape);
        return new Layout(shape, new Offset(LayoutManager.limitMin(anchorOfReference.getX() + dist.getOffset().getX() - anchorOfReferring.getX(), 0), LayoutManager.limitMin(anchorOfReference.getY() + dist.getOffset().getY() - anchorOfReferring.getY(), 0)));
    }

    public static MultiShapeLayout multiShapeLayout(final Dimension canvas, List<Tuple<Dimension, HorizontalCoverageLayoutSpec>> shapes) {
        return new MultiShapeLayout(canvas, Monadics.mlist(shapes).map((Function)new Function<Tuple<Dimension, HorizontalCoverageLayoutSpec>, Layout>(){

            public Layout apply(Tuple<Dimension, HorizontalCoverageLayoutSpec> a) {
                return LayoutManager.calcLayout(canvas, (Dimension)a.getA(), (HorizontalCoverageLayoutSpec)a.getB());
            }
        }).value());
    }

    public static MultiShapeLayout absoluteMultiShapeLayout(final Dimension canvas, List<Tuple<Dimension, AbsolutePositionLayoutSpec>> shapes) {
        return new MultiShapeLayout(canvas, Monadics.mlist(shapes).map((Function)new Function<Tuple<Dimension, AbsolutePositionLayoutSpec>, Layout>(){

            public Layout apply(Tuple<Dimension, AbsolutePositionLayoutSpec> a) {
                return LayoutManager.calcLayout(canvas, (Dimension)a.getA(), (AbsolutePositionLayoutSpec)a.getB());
            }
        }).value());
    }

    public static int limitMax(double v, int max) {
        return (int)Math.min(Math.round(v), (long)max);
    }

    public static int limitMin(double v, int min) {
        return (int)Math.max(Math.round(v), (long)min);
    }

    public static boolean fits(Dimension into, Dimension shape) {
        return shape.getHeight() <= into.getHeight() && shape.getWidth() <= into.getHeight();
    }

    public static int area(Dimension a) {
        return a.getWidth() * a.getHeight();
    }

    public static Dimension max(Dimension a, Dimension b) {
        return LayoutManager.area(a) > LayoutManager.area(b) ? a : b;
    }

    public static double aspectRatio(Dimension a) {
        return LayoutManager.d(a.getWidth()) / LayoutManager.d(a.getHeight());
    }

    public static boolean overlap(Layout a, Layout b) {
        return !(!LayoutManager.between(LayoutManager.left(a), LayoutManager.right(a), LayoutManager.left(b)) && !LayoutManager.between(LayoutManager.left(a), LayoutManager.right(a), LayoutManager.right(b)) || !LayoutManager.between(LayoutManager.top(a), LayoutManager.bottom(a), LayoutManager.top(b)) && !LayoutManager.between(LayoutManager.top(a), LayoutManager.bottom(a), LayoutManager.bottom(b)));
    }

    public static int left(Layout a) {
        return a.getOffset().getX();
    }

    public static int right(Layout a) {
        return a.getOffset().getX() + a.getDimension().getWidth();
    }

    public static int top(Layout a) {
        return a.getOffset().getY();
    }

    public static int bottom(Layout a) {
        return a.getOffset().getY() + a.getDimension().getHeight();
    }

    public static Offset offset(Anchor a, Dimension dim) {
        return new Offset(LayoutManager.limitMax(a.getLeft() * LayoutManager.d(dim.getWidth()), dim.getWidth()), LayoutManager.limitMax(a.getTop() * LayoutManager.d(dim.getHeight()), dim.getHeight()));
    }

    public static Dimension scale(Dimension limit, Dimension shape, double scale) {
        return Dimension.dimension(LayoutManager.limitMax(LayoutManager.d(shape.getWidth()) * scale, limit.getWidth()), LayoutManager.limitMax(LayoutManager.d(shape.getHeight()) * scale, limit.getHeight()));
    }

    public static Dimension scaleToFit(Dimension canvas, Dimension d) {
        double scaleToWidth = LayoutManager.d(canvas.getWidth()) / LayoutManager.d(d.getWidth());
        if ((double)d.getHeight() * scaleToWidth > (double)canvas.getHeight()) {
            double scaleToHeight = LayoutManager.d(canvas.getHeight()) / LayoutManager.d(d.getHeight());
            return LayoutManager.scale(canvas, d, scaleToHeight);
        }
        return LayoutManager.scale(canvas, d, scaleToWidth);
    }

    public static boolean between(int a, int b, int x) {
        return a <= x && x <= b;
    }

    private static double d(int v) {
        return v;
    }
}

