/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.api;

import java.util.Comparator;

public class VideoClip
implements Comparable<VideoClip>,
Comparator<VideoClip> {
    private final int srcId;
    private final long start;
    private long end;

    public VideoClip(int indx, double start, double end) {
        this.srcId = indx;
        this.start = (long)(start * 1000.0);
        this.end = (long)(end * 1000.0);
    }

    public VideoClip(int indx, long start, long end) {
        this.srcId = indx;
        this.start = start;
        this.end = end;
    }

    public void setEnd(double newend) {
        this.end = (long)(newend * 1000.0);
    }

    public void setEnd(long newend) {
        this.end = newend;
    }

    public int getSrc() {
        return this.srcId;
    }

    public double getStart() {
        return (double)this.start / 1000.0;
    }

    public double getEnd() {
        return (double)this.end / 1000.0;
    }

    public long getStartMS() {
        return this.start;
    }

    public long getEndMS() {
        return this.end;
    }

    public double getDuration() {
        return (double)(this.end - this.start) / 1000.0;
    }

    public long getDurationMS() {
        return this.end - this.start;
    }

    public String toString() {
        return "VideoClip [srcId=" + this.srcId + ", start=" + this.start + ", end=" + this.end + "]";
    }

    @Override
    public int compareTo(VideoClip other) {
        return (int)(this.start - other.getStartMS());
    }

    @Override
    public int compare(VideoClip o1, VideoClip o2) {
        return (int)(o1.getStartMS() - o2.getStartMS());
    }
}

