/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.util.EqualsUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="profile", namespace="http://composer.opencastproject.org")
@XmlRootElement(name="profile", namespace="http://composer.opencastproject.org")
public class EncodingProfileImpl
implements EncodingProfile {
    @XmlAttribute(name="id")
    @XmlID
    protected String identifier = null;
    @XmlElement(name="name")
    protected String name = null;
    @XmlTransient
    protected Object source;
    @XmlElement(name="outputmediatype")
    protected EncodingProfile.MediaType outputType = null;
    @XmlElement(name="mimetype")
    protected String mimeType = null;
    @XmlElement(name="inputmediatype")
    protected EncodingProfile.MediaType applicableType = null;
    @XmlElement(name="extension")
    @XmlElementWrapper(name="extensions")
    protected List<Extension> extensions = new ArrayList<Extension>();
    @XmlElementWrapper(name="suffixes")
    protected HashMap<String, String> suffixes = new HashMap();
    @XmlElement(name="jobLoad")
    protected Float jobLoad = Float.valueOf(1.5f);

    public EncodingProfileImpl(String identifier, String name, Object source) {
        this.identifier = identifier;
        this.name = name;
        this.source = source;
    }

    public EncodingProfileImpl() {
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public EncodingProfile.MediaType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(EncodingProfile.MediaType type) {
        this.outputType = type;
    }

    @Override
    public String getSuffix() {
        if (this.suffixes.keySet().size() == 0) {
            return null;
        }
        if (this.suffixes.containsKey("default")) {
            return this.suffixes.get("default");
        }
        return this.suffixes.get(this.suffixes.values().toArray()[0]);
    }

    public void setSuffix(String suffix) {
        this.setSuffix("default", suffix);
    }

    public void setSuffix(String tag, String suffix) {
        this.suffixes.put(tag, suffix);
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public EncodingProfile.MediaType getApplicableMediaType() {
        return this.applicableType;
    }

    public void setApplicableType(EncodingProfile.MediaType applicableType) {
        this.applicableType = applicableType;
    }

    @Override
    public boolean isApplicableTo(EncodingProfile.MediaType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        return type.equals((Object)this.applicableType);
    }

    @Override
    public String getExtension(String key) {
        return this.getExtensions().get(key);
    }

    public void addExtension(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("Argument 'key' must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null");
        }
        this.removeExtension(key);
        this.extensions.add(new Extension(key, value));
    }

    @Override
    public Map<String, String> getExtensions() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Extension extension : this.extensions) {
            map.put(extension.getKey(), extension.getValue());
        }
        return map;
    }

    public void setExtensions(Map<String, String> extension) {
        this.extensions.clear();
        for (Map.Entry<String, String> entry : extension.entrySet()) {
            this.extensions.add(new Extension(entry));
        }
    }

    public String removeExtension(String key) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!this.extensions.get(i).getKey().equals(key)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        return this.extensions.remove(index).getValue();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public float getJobLoad() {
        return this.jobLoad.floatValue();
    }

    public void setJobLoad(Float jobLoad) {
        this.jobLoad = jobLoad;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodingProfile) {
            EncodingProfile mf = (EncodingProfile)obj;
            return this.identifier.equals(mf.getIdentifier());
        }
        return false;
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public String getSuffix(String tag) {
        if (this.suffixes.containsKey(tag)) {
            return this.suffixes.get(tag);
        }
        return null;
    }

    @Override
    public List<String> getTags() {
        return new ArrayList<String>(this.suffixes.keySet());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="extension", namespace="http://composer.opencastproject.org")
    public static class Extension {
        @XmlAttribute
        private String key;
        @XmlValue
        private String value;

        public Extension() {
        }

        public Extension(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Extension(Map.Entry<String, String> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Extension) {
                Extension ext = (Extension)obj;
                return this.key.equals(ext.getKey()) && this.value.equals(ext.getValue());
            }
            return false;
        }

        public int hashCode() {
            return EqualsUtil.hash((Object[])new Object[]{this.key, this.value});
        }
    }
}

