/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.api;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;

public interface EncodingProfile {
    public String getIdentifier();

    public String getName();

    public Object getSource();

    public MediaType getOutputType();

    public String getSuffix();

    public String getSuffix(String var1);

    public List<String> getTags();

    public String getMimeType();

    public void setMimeType(String var1);

    public MediaType getApplicableMediaType();

    public boolean isApplicableTo(MediaType var1);

    public boolean hasExtensions();

    public String getExtension(String var1);

    public Map<String, String> getExtensions();

    public float getJobLoad();

    @XmlType(name="media-type", namespace="http://composer.opencastproject.org")
    public static enum MediaType {
        Audio,
        Visual,
        AudioVisual,
        Stream,
        EnhancedAudio,
        Image,
        ImageSequence,
        Cover,
        Nothing,
        Manifest;


        public static MediaType parseString(String type) {
            if (type == null || ((String)type).length() == 0) {
                throw new IllegalArgumentException((String)type + " is not a valid track type definition");
            }
            if ("audiovisual".equalsIgnoreCase((String)type)) {
                return AudioVisual;
            }
            if ("enhancedaudio".equalsIgnoreCase((String)type)) {
                return EnhancedAudio;
            }
            if ("imagesequence".equalsIgnoreCase((String)type)) {
                return ImageSequence;
            }
            type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1).toLowerCase();
            return MediaType.valueOf(((String)type).trim());
        }
    }
}

