/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.impl.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.api.EncodingProfileImpl;
import org.opencastproject.composer.api.EncodingProfileList;
import org.opencastproject.composer.api.LaidOutElement;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.composer.layout.Layout;
import org.opencastproject.composer.layout.Serializer;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.util.JsonObj;
import org.opencastproject.util.LocalHashMap;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/composer/ffmpeg")
@RestService(name="composer", title="Composer", abstractText="This service creates and augments Opencast media packages that include media tracks, metadata catalogs and attachments.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(property={"service.description=Composer REST Endpoint", "opencast.service.type=org.opencastproject.composer", "opencast.service.path=/composer/ffmpeg", "opencast.service.jobproducer=true"}, immediate=true, service={ComposerRestService.class})
@JaxrsResource
public class ComposerRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ComposerRestService.class);
    private static final String VIDEO_TRACK_DEFAULT = "<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>";
    private static final String AUDIO_TRACK_DEFAULT = "<track id=\"track-2\" type=\"presentation/source\">\n  <mimetype>audio/mp3</mimetype>\n  <url>serverUrl/workflow/samples/audio.mp3</url>\n  <checksum type=\"md5\">950f9fa49caa8f1c5bbc36892f6fd062</checksum>\n  <duration>10472</duration>\n  <audio>\n    <channels>2</channels>\n    <bitdepth>0</bitdepth>\n    <bitrate>128004.0</bitrate>\n    <samplingrate>44100</samplingrate>\n  </audio>\n</track>";
    private static final String IMAGE_ATTACHMENT_DEFAULT = "<attachment id=\"track-3\">\n  <mimetype>image/jpeg</mimetype>\n  <url>serverUrl/workflow/samples/image.jpg</url>\n</attachment>";
    protected String serverUrl;
    protected ComposerService composerService = null;
    protected ServiceRegistry serviceRegistry = null;
    protected SmilService smilService = null;

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    public void activate(ComponentContext cc) {
        this.serverUrl = cc == null || cc.getBundleContext().getProperty("org.opencastproject.server.url") == null ? "http://localhost:8080" : cc.getBundleContext().getProperty("org.opencastproject.server.url");
    }

    @POST
    @Path(value="encode")
    @Produces(value={"text/xml"})
    @RestQuery(name="encode", description="Starts an encoding process, based on the specified encoding profile ID and the track", restParameters={@RestParameter(description="The track containing the stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="mp4-medium.http")}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response encode(@FormParam(value="sourceTrack") String sourceTrackAsXml, @FormParam(value="profileId") String profileId) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackAsXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileId must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        try {
            Job job = this.composerService.encode((Track)sourceTrack, profileId);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to encode the track: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="parallelencode")
    @Produces(value={"text/xml"})
    @RestQuery(name="parallelencode", description="Starts an encoding process, based on the specified encoding profile ID and the track", restParameters={@RestParameter(description="The track containing the stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="mp4-medium.http")}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200)}, returnDescription="")
    public Response parallelencode(@FormParam(value="sourceTrack") String sourceTrackAsXml, @FormParam(value="profileId") String profileId) throws Exception {
        if (sourceTrackAsXml == null || profileId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileId must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        Job job = this.composerService.parallelEncode((Track)sourceTrack, profileId);
        if (job == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Encoding failed").build();
        }
        return Response.ok().entity((Object)new JaxbJob(job)).build();
    }

    @POST
    @Path(value="trim")
    @Produces(value={"text/xml"})
    @RestQuery(name="trim", description="Starts a trimming process, based on the specified track, start time and duration in ms", restParameters={@RestParameter(description="The track containing the stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use for trimming", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="trim.work"), @RestParameter(description="The start time in milisecond", isRequired=true, name="start", type=RestParameter.Type.STRING, defaultValue="0"), @RestParameter(description="The duration in milisecond", isRequired=true, name="duration", type=RestParameter.Type.STRING, defaultValue="10000")}, responses={@RestResponse(description="Results in an xml document containing the job for the trimming task", responseCode=200), @RestResponse(description="If the start time is negative or exceeds the track duration", responseCode=400), @RestResponse(description="If the duration is negative or, including the new start time, exceeds the track duration", responseCode=400)}, returnDescription="")
    public Response trim(@FormParam(value="sourceTrack") String sourceTrackAsXml, @FormParam(value="profileId") String profileId, @FormParam(value="start") long start, @FormParam(value="duration") long duration) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackAsXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileId must not be null").build();
        }
        MediaPackageElement sourceElement = MediaPackageElementParser.getFromXml((String)sourceTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceElement.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        Track sourceTrack = (Track)sourceElement;
        if (sourceTrack.getDuration() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element does not have a duration").build();
        }
        if (start < 0L) {
            start = 0L;
        } else if (duration <= 0L) {
            duration = sourceTrack.getDuration() - start;
        } else if (start + duration > sourceTrack.getDuration()) {
            duration = sourceTrack.getDuration() - start;
        }
        try {
            Job job = this.composerService.trim(sourceTrack, profileId, start, duration);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to trim the track: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="mux")
    @Produces(value={"text/xml"})
    @RestQuery(name="mux", description="Starts an encoding process, which will mux the two tracks using the given encoding profile", restParameters={@RestParameter(description="The track containing the audio stream", isRequired=false, name="sourceAudioTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-2\" type=\"presentation/source\">\n  <mimetype>audio/mp3</mimetype>\n  <url>serverUrl/workflow/samples/audio.mp3</url>\n  <checksum type=\"md5\">950f9fa49caa8f1c5bbc36892f6fd062</checksum>\n  <duration>10472</duration>\n  <audio>\n    <channels>2</channels>\n    <bitdepth>0</bitdepth>\n    <bitrate>128004.0</bitrate>\n    <samplingrate>44100</samplingrate>\n  </audio>\n</track>"), @RestParameter(description="The track containing the video stream", isRequired=false, name="sourceVideoTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The track containing the video stream", isRequired=false, name="sourceTracks", type=RestParameter.Type.TEXT), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="mp4-medium.http")}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200), @RestResponse(description="If required parameters aren't set or if the source tracks aren't from the type Track", responseCode=400)}, returnDescription="")
    public Response mux(@FormParam(value="audioSourceTrack") String audioSourceTrackXml, @FormParam(value="videoSourceTrack") String videoSourceTrackXml, @FormParam(value="sourceTracks") String sourceTracksXml, @FormParam(value="profileId") String profileId) throws Exception {
        if (StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"profileId must not be null").build();
        }
        if ((StringUtils.isBlank((CharSequence)audioSourceTrackXml) || StringUtils.isBlank((CharSequence)videoSourceTrackXml)) && StringUtils.isBlank((CharSequence)sourceTracksXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"audioSourceTrack, videoSourceTrack or sourceTracks must not be null").build();
        }
        try {
            Job job;
            HashMap<String, Track> sourceTracks = new HashMap<String, Track>();
            if (StringUtils.isNotBlank((CharSequence)sourceTracksXml)) {
                for (String sourceTrackEntry : StringUtils.splitByWholeSeparator((String)sourceTracksXml, (String)"#|#")) {
                    String[] sourceTrackEntryTuple = StringUtils.splitByWholeSeparator((String)sourceTrackEntry, (String)"#=#", (int)2);
                    if (sourceTrackEntryTuple.length != 2) {
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTracks value invalid").build();
                    }
                    sourceTracks.put(sourceTrackEntryTuple[0], (Track)MediaPackageElementParser.getFromXml((String)sourceTrackEntryTuple[1]));
                }
                job = this.composerService.mux(sourceTracks, profileId);
            } else {
                MediaPackageElement audioSourceTrack = MediaPackageElementParser.getFromXml((String)audioSourceTrackXml);
                if (!Track.TYPE.equals((Object)audioSourceTrack.getElementType())) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"audioSourceTrack must be of type track").build();
                }
                MediaPackageElement videoSourceTrack = MediaPackageElementParser.getFromXml((String)videoSourceTrackXml);
                if (!Track.TYPE.equals((Object)videoSourceTrack.getElementType())) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"videoSourceTrack must be of type track").build();
                }
                job = this.composerService.mux((Track)videoSourceTrack, (Track)audioSourceTrack, profileId);
            }
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to mux tracks: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="image")
    @Produces(value={"text/xml"})
    @RestQuery(name="image", description="Starts an image extraction process, based on the specified encoding profile ID and the source track", restParameters={@RestParameter(description="The track containing the video stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="player-preview.http"), @RestParameter(description="The number of seconds (many numbers can be specified, separated by semicolon) into the video to extract the image", isRequired=false, name="time", type=RestParameter.Type.STRING), @RestParameter(description="An optional set of key=value\\n properties", isRequired=false, name="properties", type=RestParameter.Type.TEXT)}, responses={@RestResponse(description="Results in an xml document containing the image attachment", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="The image extraction job")
    public Response image(@FormParam(value="sourceTrack") String sourceTrackXml, @FormParam(value="profileId") String profileId, @FormParam(value="time") String times, @FormParam(value="properties") LocalHashMap localMap) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileId must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        boolean timeBased = false;
        double[] timeArray = null;
        if (StringUtils.isNotBlank((CharSequence)times)) {
            try {
                timeArray = this.parseTimeArray(times);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"could not parse times: invalid format").build();
            }
            timeBased = true;
        } else if (localMap == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Job job = timeBased ? this.composerService.image((Track)sourceTrack, profileId, timeArray) : this.composerService.image((Track)sourceTrack, profileId, localMap.getMap());
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to extract image(s): " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="imagesync")
    @Produces(value={"text/xml"})
    @RestQuery(name="imagesync", description="Synchronously extracts an image, based on the specified encoding profile ID and the source track", restParameters={@RestParameter(description="The track containing the video stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="player-preview.http"), @RestParameter(description="The number of seconds (many numbers can be specified, separated by semicolon) into the video to extract the image", isRequired=false, name="time", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Results in an xml document containing the image attachment", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="The extracted image")
    public Response imageSync(@FormParam(value="sourceTrack") String sourceTrackXml, @FormParam(value="profileId") String profileId, @FormParam(value="time") String times) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackXml) || StringUtils.isBlank((CharSequence)profileId) || StringUtils.isBlank((CharSequence)times)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack, times, and profileId must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        double[] timeArray = null;
        try {
            timeArray = this.parseTimeArray(times);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"could not parse times: invalid format").build();
        }
        try {
            List result = this.composerService.imageSync((Track)sourceTrack, profileId, timeArray);
            return Response.ok().entity((Object)MediaPackageElementParser.getArrayAsXml((Collection)result)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to extract image(s): " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="composite")
    @Produces(value={"text/xml"})
    @RestQuery(name="composite", description="Starts a video compositing process, based on the specified resolution, encoding profile ID, the source elements and their layouts", restParameters={@RestParameter(description="The resolution size of the resulting video as JSON", isRequired=true, name="compositeSize", type=RestParameter.Type.STRING), @RestParameter(description="The lower source track containing the lower video", isRequired=true, name="lowerTrack", type=RestParameter.Type.TEXT), @RestParameter(description="The lower layout containing the JSON definition of the layout", isRequired=true, name="lowerLayout", type=RestParameter.Type.TEXT), @RestParameter(description="The upper source track containing the upper video", isRequired=false, name="upperTrack", type=RestParameter.Type.TEXT), @RestParameter(description="The upper layout containing the JSON definition of the layout", isRequired=false, name="upperLayout", type=RestParameter.Type.TEXT), @RestParameter(description="The watermark source attachment containing watermark image", isRequired=false, name="watermarkTrack", type=RestParameter.Type.TEXT), @RestParameter(description="The watermark layout containing the JSON definition of the layout", isRequired=false, name="watermarkLayout", type=RestParameter.Type.TEXT), @RestParameter(description="The background color", isRequired=false, name="background", type=RestParameter.Type.TEXT, defaultValue="black"), @RestParameter(description="The name of the audio source (lower or upper or both)", isRequired=false, name="audioSourceName", type=RestParameter.Type.TEXT, defaultValue="both"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Results in an xml document containing the compound video track", responseCode=200), @RestResponse(description="If required parameters aren't set or if the source elements aren't from the right type", responseCode=400)}, returnDescription="")
    public Response composite(@FormParam(value="compositeSize") String compositeSizeJson, @FormParam(value="lowerTrack") String lowerTrackXml, @FormParam(value="lowerLayout") String lowerLayoutJson, @FormParam(value="upperTrack") String upperTrackXml, @FormParam(value="upperLayout") String upperLayoutJson, @FormParam(value="watermarkAttachment") String watermarkAttachmentXml, @FormParam(value="watermarkLayout") String watermarkLayoutJson, @FormParam(value="profileId") String profileId, @FormParam(value="background") @DefaultValue(value="black") String background, @FormParam(value="sourceAudioName") @DefaultValue(value="both") String sourceAudioName) throws Exception {
        if (StringUtils.isBlank((CharSequence)compositeSizeJson) || StringUtils.isBlank((CharSequence)lowerTrackXml) || StringUtils.isBlank((CharSequence)lowerLayoutJson) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"One of the required parameters must not be null").build();
        }
        MediaPackageElement lowerTrack = MediaPackageElementParser.getFromXml((String)lowerTrackXml);
        Layout lowerLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)lowerLayoutJson));
        if (!Track.TYPE.equals((Object)lowerTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"lowerTrack element must be of type track").build();
        }
        LaidOutElement lowerLaidOutElement = new LaidOutElement((MediaPackageElement)((Track)lowerTrack), lowerLayout);
        Option upperLaidOutElement = Option.none();
        if (StringUtils.isNotBlank((CharSequence)upperTrackXml)) {
            MediaPackageElement upperTrack = MediaPackageElementParser.getFromXml((String)upperTrackXml);
            Layout upperLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)upperLayoutJson));
            if (!Track.TYPE.equals((Object)upperTrack.getElementType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"upperTrack element must be of type track").build();
            }
            upperLaidOutElement = Option.option((Object)new LaidOutElement((MediaPackageElement)((Track)upperTrack), upperLayout));
        }
        Option watermarkLaidOutElement = Option.none();
        if (StringUtils.isNotBlank((CharSequence)watermarkAttachmentXml)) {
            Layout watermarkLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)watermarkLayoutJson));
            MediaPackageElement watermarkAttachment = MediaPackageElementParser.getFromXml((String)watermarkAttachmentXml);
            if (!Attachment.TYPE.equals((Object)watermarkAttachment.getElementType())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"watermarkTrack element must be of type track").build();
            }
            watermarkLaidOutElement = Option.some((Object)new LaidOutElement((MediaPackageElement)((Attachment)watermarkAttachment), watermarkLayout));
        }
        Dimension compositeTrackSize = Serializer.dimension((JsonObj)JsonObj.jsonObj((String)compositeSizeJson));
        try {
            Job job = this.composerService.composite(compositeTrackSize, upperLaidOutElement, lowerLaidOutElement, watermarkLaidOutElement, profileId, background, sourceAudioName);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to composite video: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="concat")
    @Produces(value={"text/xml"})
    @RestQuery(name="concat", description="Starts a video concating process from multiple videos, based on the specified encoding profile ID and the source tracks", restParameters={@RestParameter(description="The source tracks to concat as XML", isRequired=true, name="sourceTracks", type=RestParameter.Type.TEXT), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING), @RestParameter(description="The resolution dimension of the concat video as JSON", isRequired=false, name="outputDimension", type=RestParameter.Type.STRING), @RestParameter(description="The  frame rate of the concat video (should be positive, e.g. 25.0). Negative values and zero will cause no FFmpeg fps filter to be used in the filter chain.", isRequired=false, name="outputFrameRate", type=RestParameter.Type.STRING), @RestParameter(description="The source files have the same codecs and should not be re-encoded", isRequired=false, name="sameCodec", type=RestParameter.Type.TEXT, defaultValue="false")}, responses={@RestResponse(description="Results in an xml document containing the video track", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTracks aren't from the type Track or not at least two tracks are present", responseCode=400)}, returnDescription="")
    public Response concat(@FormParam(value="sourceTracks") String sourceTracksXml, @FormParam(value="profileId") String profileId, @FormParam(value="outputDimension") String outputDimension, @FormParam(value="outputFrameRate") String outputFrameRate, @FormParam(value="sameCodec") String sameCodec) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTracksXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTracks and profileId must not be null").build();
        }
        List tracks = MediaPackageElementParser.getArrayFromXml((String)sourceTracksXml);
        if (tracks.size() < 2) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"At least two tracks must be set to concat").build();
        }
        for (MediaPackageElement elem : tracks) {
            if (Track.TYPE.equals((Object)elem.getElementType())) continue;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTracks must be of type track").build();
        }
        float fps = NumberUtils.toFloat((String)outputFrameRate, (float)-1.0f);
        try {
            Dimension dimension = null;
            if (StringUtils.isNotBlank((CharSequence)outputDimension)) {
                dimension = Serializer.dimension((JsonObj)JsonObj.jsonObj((String)outputDimension));
            }
            boolean hasSameCodec = Boolean.parseBoolean(sameCodec);
            Job job = null;
            job = fps > 0.0f ? this.composerService.concat(profileId, dimension, fps, hasSameCodec, tracks.toArray(new Track[tracks.size()])) : this.composerService.concat(profileId, dimension, hasSameCodec, tracks.toArray(new Track[tracks.size()]));
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to concat videos: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="imagetovideo")
    @Produces(value={"text/xml"})
    @RestQuery(name="imagetovideo", description="Starts an image converting process to a video, based on the specified encoding profile ID and the source image attachment", restParameters={@RestParameter(description="The resulting video time in seconds", isRequired=false, name="time", type=RestParameter.Type.STRING, defaultValue="1"), @RestParameter(description="The attachment containing the image to convert", isRequired=true, name="sourceAttachment", type=RestParameter.Type.TEXT), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Results in an xml document containing the video track", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceAttachment isn't from the type Attachment", responseCode=400)}, returnDescription="")
    public Response imageToVideo(@FormParam(value="sourceAttachment") String sourceAttachmentXml, @FormParam(value="profileId") String profileId, @FormParam(value="time") @DefaultValue(value="1") String timeString) throws Exception {
        Double time;
        if (StringUtils.isBlank((CharSequence)sourceAttachmentXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAttachment and profileId must not be null").build();
        }
        try {
            time = Double.parseDouble(timeString);
        }
        catch (Exception e) {
            logger.info("Unable to parse time {} as long value!", (Object)timeString);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Could not parse time: invalid format").build();
        }
        MediaPackageElement sourceAttachment = MediaPackageElementParser.getFromXml((String)sourceAttachmentXml);
        if (!Attachment.TYPE.equals((Object)sourceAttachment.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAttachment element must be of type attachment").build();
        }
        try {
            Job job = this.composerService.imageToVideo((Attachment)sourceAttachment, profileId, time.doubleValue());
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to convert image to video: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="convertimage")
    @Produces(value={"text/xml"})
    @RestQuery(name="convertimage", description="Starts an image conversion process, based on the specified encoding profile ID and the source image", restParameters={@RestParameter(description="The original image", isRequired=true, name="sourceImage", type=RestParameter.Type.TEXT, defaultValue="<attachment id=\"track-3\">\n  <mimetype>image/jpeg</mimetype>\n  <url>serverUrl/workflow/samples/image.jpg</url>\n</attachment>"), @RestParameter(description="A comma separated list of encoding profiles to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="image-conversion.http")}, responses={@RestResponse(description="Results in an xml document containing the image attachment", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceImage isn't from the type Attachment", responseCode=400)}, returnDescription="")
    public Response convertImage(@FormParam(value="sourceImage") String sourceImageXml, @FormParam(value="profileId") String profileId) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceImageXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceImage and profileId must not be null").build();
        }
        MediaPackageElement sourceImage = MediaPackageElementParser.getFromXml((String)sourceImageXml);
        if (!Attachment.TYPE.equals((Object)sourceImage.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceImage element must be of type track").build();
        }
        try {
            Job job = this.composerService.convertImage((Attachment)sourceImage, StringUtils.split((String)profileId, (char)','));
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to convert image: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="demux")
    @Produces(value={"text/xml"})
    @RestQuery(name="demux", description="Starts an demux process that produces multiple outputs, based on the specified encoding profile ID and the track", restParameters={@RestParameter(description="The track containing the stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The encoding profile to use", isRequired=true, name="profileId", type=RestParameter.Type.STRING, defaultValue="demux.work")}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response demux(@FormParam(value="sourceTrack") String sourceTrackAsXml, @FormParam(value="profileId") String profileId) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackAsXml) || StringUtils.isBlank((CharSequence)profileId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileId must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        try {
            Job job = this.composerService.demux((Track)sourceTrack, profileId);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to encode the track: " + String.valueOf((Object)e));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="processsmil")
    @Produces(value={"text/xml"})
    @RestQuery(name="processsmil", description="Starts an encoding process, based on the tracks and edit points in the smil and specified encoding profile IDs", restParameters={@RestParameter(description="The smil containing the tracks and edit points", isRequired=true, name="smilAsXml", type=RestParameter.Type.TEXT), @RestParameter(description="The id (paramgroup) of the track to encode", isRequired=false, name="trackId", type=RestParameter.Type.STRING, defaultValue=""), @RestParameter(description="MediaType - v for video only, a for audio only, audiovisual otherwise", isRequired=false, name="mediaType", type=RestParameter.Type.STRING, defaultValue="o"), @RestParameter(description="The encoding profiles to use", isRequired=true, name="profileIds", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response processSmil(@FormParam(value="smilAsXml") String smilAsXml, @FormParam(value="trackId") String trackId, @FormParam(value="mediaType") String mediaType, @FormParam(value="profileIds") String profileIds) throws Exception {
        Smil smil;
        if (StringUtils.isBlank((CharSequence)smilAsXml) || StringUtils.isBlank((CharSequence)profileIds)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"smil and profileId must not be null").build();
        }
        String[] profiles = StringUtils.split((String)profileIds, (String)",");
        try {
            smil = this.smilService.fromXml(smilAsXml).getSmil();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"smil must be readable").build();
        }
        try {
            Job job = this.composerService.processSmil(smil, trackId, mediaType, Arrays.asList(profiles));
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to process the smil: " + String.valueOf((Object)e));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="multiencode")
    @Produces(value={"text/xml"})
    @RestQuery(name="multiencode", description="Starts an encoding process that produces multiple outputs, based on the specified encoding profile ID and the track", restParameters={@RestParameter(description="The track containing the stream", isRequired=true, name="sourceTrack", type=RestParameter.Type.TEXT, defaultValue="<track id=\"track-1\" type=\"presentation/source\">\n  <mimetype>video/quicktime</mimetype>\n  <url>http://localhost:8080/workflow/samples/camera.mpg</url>\n  <checksum type=\"md5\">43b7d843b02c4a429b2f547a4f230d31</checksum>\n  <duration>14546</duration>\n  <video>\n    <device type=\"UFG03\" version=\"30112007\" vendor=\"Unigraf\" />\n    <encoder type=\"H.264\" version=\"7.4\" vendor=\"Apple Inc\" />\n    <resolution>640x480</resolution>\n    <scanType type=\"progressive\" />\n    <bitrate>540520</bitrate>\n    <frameRate>2</frameRate>\n  </video>\n</track>"), @RestParameter(description="The comma-delimited encoding profiles to use", isRequired=true, name="profileIds", type=RestParameter.Type.STRING, defaultValue="mp4-medium.http,mp4-low.http")}, responses={@RestResponse(description="Results in an xml document containing the job for the encoding task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response multiEncode(@FormParam(value="sourceTrack") String sourceTrackAsXml, @FormParam(value="profileIds") String profileIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceTrackAsXml) || StringUtils.isBlank((CharSequence)profileIds)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack and profileIds must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceTrack element must be of type track").build();
        }
        try {
            String[] profiles = StringUtils.split((String)profileIds, (String)",");
            Job job = this.composerService.multiEncode((Track)sourceTrack, Arrays.asList(profiles));
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to encode the track: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="convertimagesync")
    @Produces(value={"text/xml"})
    @RestQuery(name="convertimagesync", description="Synchronously converts an image, based on the specified encoding profiles and the source image", restParameters={@RestParameter(description="The original image", isRequired=true, name="sourceImage", type=RestParameter.Type.TEXT, defaultValue="<attachment id=\"track-3\">\n  <mimetype>image/jpeg</mimetype>\n  <url>serverUrl/workflow/samples/image.jpg</url>\n</attachment>"), @RestParameter(description="The encoding profiles to use", isRequired=true, name="profileIds", type=RestParameter.Type.STRING, defaultValue="image-conversion.http")}, responses={@RestResponse(description="Results in an xml document containing the image attachments", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceImage isn't from the type attachment", responseCode=400)}, returnDescription="")
    public Response convertImageSync(@FormParam(value="sourceImage") String sourceImageXml, @FormParam(value="profileIds") String profileIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceImageXml) || StringUtils.isBlank((CharSequence)profileIds)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceImage and profileIds must not be null").build();
        }
        MediaPackageElement sourceImage = MediaPackageElementParser.getFromXml((String)sourceImageXml);
        if (!Attachment.TYPE.equals((Object)sourceImage.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceImage element must be of type track").build();
        }
        try {
            List results = this.composerService.convertImageSync((Attachment)sourceImage, StringUtils.split((String)profileIds, (char)','));
            return Response.ok().entity((Object)MediaPackageElementParser.getArrayAsXml((Collection)results)).build();
        }
        catch (EncoderException e) {
            logger.warn("Unable to convert image: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="profiles.xml")
    @Produces(value={"text/xml"})
    @RestQuery(name="profiles", description="Retrieve the encoding profiles", responses={@RestResponse(description="Results in an xml document describing the available encoding profiles", responseCode=200)}, returnDescription="")
    public EncodingProfileList listProfiles() {
        ArrayList<EncodingProfileImpl> list = new ArrayList<EncodingProfileImpl>();
        for (EncodingProfile p : this.composerService.listProfiles()) {
            list.add((EncodingProfileImpl)p);
        }
        return new EncodingProfileList(list);
    }

    @GET
    @Path(value="profile/{id}.xml")
    @Produces(value={"text/xml"})
    @RestQuery(name="profilesID", description="Retrieve an encoding profile", pathParameters={@RestParameter(name="id", description="the profile ID", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Results in an xml document describing the requested encoding profile", responseCode=200), @RestResponse(description="If profile has not been found", responseCode=404)}, returnDescription="")
    public Response getProfile(@PathParam(value="id") String profileId) throws NotFoundException {
        EncodingProfileImpl profile = (EncodingProfileImpl)this.composerService.getProfile(profileId);
        if (profile == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)profile).build();
    }

    public JobProducer getService() {
        if (this.composerService instanceof JobProducer) {
            return (JobProducer)this.composerService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected double[] parseTimeArray(String times) {
        String[] timeStringArray = times.split(";");
        LinkedList<Double> parsedTimeArray = new LinkedList<Double>();
        for (String timeString : timeStringArray) {
            String trimmed = StringUtils.trim((String)timeString);
            if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
            parsedTimeArray.add(Double.parseDouble(timeString));
        }
        double[] timeArray = new double[parsedTimeArray.size()];
        for (int i = 0; i < parsedTimeArray.size(); ++i) {
            timeArray[i] = (Double)parsedTimeArray.get(i);
        }
        return timeArray;
    }
}

