/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.api.LaidOutElement;
import org.opencastproject.composer.api.VideoClip;
import org.opencastproject.composer.impl.EncoderEngine;
import org.opencastproject.composer.impl.EncodingProfileScanner;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.composer.layout.Layout;
import org.opencastproject.composer.layout.Serializer;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.mediapackage.AdaptivePlaylist;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.Incidents;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;
import org.opencastproject.util.FileSupport;
import org.opencastproject.util.JsonObj;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.ReadinessIndicator;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composer (Encoder) Local Service", "service.pid=org.opencastproject.composer.impl.ComposerServiceImpl"}, immediate=true, service={ComposerService.class, ManagedService.class})
public class ComposerServiceImpl
extends AbstractJobProducer
implements ComposerService,
ManagedService {
    private static final int BACKGROUND_COLOR_INDEX = 6;
    private static final int COMPOSITE_TRACK_SIZE_INDEX = 5;
    private static final int LOWER_TRACK_INDEX = 1;
    private static final int LOWER_TRACK_LAYOUT_INDEX = 2;
    private static final int PROFILE_ID_INDEX = 0;
    private static final int UPPER_TRACK_INDEX = 3;
    private static final int UPPER_TRACK_LAYOUT_INDEX = 4;
    private static final int WATERMARK_INDEX = 8;
    private static final int WATERMARK_LAYOUT_INDEX = 9;
    private static final int AUDIO_SOURCE_INDEX = 7;
    private static final int WORKSPACE_GET_IO_EXCEPTION = 1;
    private static final int WORKSPACE_GET_NOT_FOUND = 2;
    private static final int WORKSPACE_PUT_COLLECTION_IO_EXCEPTION = 3;
    private static final int PROFILE_NOT_FOUND = 4;
    private static final int ENCODING_FAILED = 7;
    private static final int TRIMMING_FAILED = 8;
    private static final int COMPOSITE_FAILED = 9;
    private static final int CONCAT_FAILED = 10;
    private static final int CONCAT_LESS_TRACKS = 11;
    private static final int CONCAT_NO_DIMENSION = 12;
    private static final int IMAGE_TO_VIDEO_FAILED = 13;
    private static final int CONVERT_IMAGE_FAILED = 14;
    private static final int IMAGE_EXTRACTION_FAILED = 15;
    private static final int IMAGE_EXTRACTION_UNKNOWN_DURATION = 16;
    private static final int IMAGE_EXTRACTION_TIME_OUTSIDE_DURATION = 17;
    private static final int IMAGE_EXTRACTION_NO_VIDEO = 18;
    private static final int PROCESS_SMIL_FAILED = 19;
    private static final int MULTI_ENCODE_FAILED = 20;
    private static final int NO_STREAMS = 23;
    private static final Logger logger = LoggerFactory.getLogger(ComposerServiceImpl.class);
    private static final String FFMPEG_BINARY_DEFAULT = "ffmpeg";
    private static final String CONFIG_FFMPEG_PATH = "org.opencastproject.composer.ffmpeg.path";
    private static final String COLLECTION = "composer";
    private static final String NOT_AVAILABLE = "n/a";
    private static final DecimalFormat df = new DecimalFormat("#.#");
    public static final String PROCESS_SMIL_CLIP_TRANSITION_DURATION = "org.composer.process_smil.edit.transition.duration";
    public static final float DEFAULT_PROCESS_SMIL_CLIP_TRANSITION_DURATION = 2.0f;
    public static final float DEFAULT_JOB_LOAD_MAX_MULTIPLE_PROFILES = 0.8f;
    public static final float DEFAULT_PROCESS_SMIL_JOB_LOAD_FACTOR = 0.5f;
    public static final float DEFAULT_MULTI_ENCODE_JOB_LOAD_FACTOR = 0.5f;
    public static final String JOB_LOAD_MAX_MULTIPLE_PROFILES = "job.load.max.multiple.profiles";
    public static final String JOB_LOAD_FACTOR_PROCESS_SMIL = "job.load.factor.process.smil";
    public static final String JOB_LOAD_FACTOR_MULTI_ENCODE = "job.load.factor.multiencode";
    private float maxMultipleProfilesJobLoad = 0.8f;
    private float processSmilJobLoadFactor = 0.5f;
    private float multiEncodeJobLoadFactor = 0.5f;
    public static final int DEFAULT_MULTI_ENCODE_TRIM_MILLISECONDS = 0;
    public static final String MULTI_ENCODE_TRIM_MILLISECONDS = "org.composer.multi_encode.trim.milliseconds";
    private int multiEncodeTrim = 0;
    public static final int DEFAULT_MULTI_ENCODE_FADE_MILLISECONDS = 0;
    public static final String MULTI_ENCODE_FADE_MILLISECONDS = "org.composer.multi_encode.fade.milliseconds";
    private int multiEncodeFade = 0;
    private int transitionDuration = 2000;
    private Set<EncoderEngine> activeEncoder = new HashSet<EncoderEngine>();
    private EncodingProfileScanner profileScanner = null;
    private MediaInspectionService inspectionService = null;
    private Workspace workspace = null;
    private ServiceRegistry serviceRegistry;
    private OrganizationDirectoryService organizationDirectoryService = null;
    private SecurityService securityService = null;
    private SmilService smilService;
    private UserDirectoryService userDirectoryService = null;
    private String ffmpegBinary = "ffmpeg";

    public ComposerServiceImpl() {
        super("org.opencastproject.composer");
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        this.ffmpegBinary = StringUtils.defaultString((String)cc.getBundleContext().getProperty(CONFIG_FFMPEG_PATH), (String)FFMPEG_BINARY_DEFAULT);
        logger.debug("ffmpeg binary: {}", (Object)this.ffmpegBinary);
        logger.info("Activating composer service");
    }

    @Deactivate
    public void deactivate() {
        logger.info("Deactivating composer service");
        for (EncoderEngine engine : this.activeEncoder) {
            engine.close();
        }
        logger.debug("Closed encoder engine factory");
    }

    public Job encode(Track sourceTrack, String profileId) throws EncoderException, MediaPackageException {
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Encode.toString(), Arrays.asList(profileId, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)), Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    private File loadTrackIntoWorkspace(Job job, String name, Track track, boolean unique) throws EncoderException {
        try {
            return this.workspace.get(track.getURI(), unique);
        }
        catch (NotFoundException e) {
            this.incident().recordFailure(job, 2, (Throwable)e, this.getWorkspaceMediapackageParams(name, (MediaPackageElement)track), Incidents.NO_DETAILS);
            throw new EncoderException(String.format("%s track %s not found", name, track));
        }
        catch (IOException e) {
            this.incident().recordFailure(job, 1, (Throwable)e, this.getWorkspaceMediapackageParams(name, (MediaPackageElement)track), Incidents.NO_DETAILS);
            throw new EncoderException(String.format("Unable to access %s track %s", name, track));
        }
    }

    private File loadURIIntoWorkspace(Job job, String name, URI uri) throws EncoderException {
        try {
            return this.workspace.get(uri);
        }
        catch (NotFoundException e) {
            this.incident().recordFailure(job, 2, (Throwable)e, this.getWorkspaceCollectionParams(name, name, uri), Incidents.NO_DETAILS);
            throw new EncoderException(String.format("%s uri %s not found", name, uri));
        }
        catch (IOException e) {
            this.incident().recordFailure(job, 1, (Throwable)e, this.getWorkspaceCollectionParams(name, name, uri), Incidents.NO_DETAILS);
            throw new EncoderException(String.format("Unable to access %s uri %s", name, uri));
        }
    }

    private Option<Track> encode(Job job, Map<String, Track> tracks, String profileId) throws EncoderException, MediaPackageException {
        return this.encode(job, tracks, profileId, null);
    }

    private Option<Track> encode(Job job, Map<String, Track> tracks, String profileId, Map<String, String> properties) throws EncoderException, MediaPackageException {
        List<File> output;
        String targetTrackId = IdImpl.fromUUID().toString();
        HashMap<String, File> files = new HashMap<String, File>();
        for (Map.Entry<String, Track> trackEntry : tracks.entrySet()) {
            files.put(trackEntry.getKey(), this.loadTrackIntoWorkspace(job, trackEntry.getKey(), trackEntry.getValue(), false));
        }
        EncodingProfile profile = this.getProfile(job, profileId);
        HashMap<String, String> props = new HashMap<String, String>();
        if (properties != null) {
            props.putAll(properties);
        }
        String substitutionKey = String.format("if-input-count-eq-%d", tracks.size());
        String substitution = profile.getExtension(StringUtils.join((Object[])new Serializable[]{"ffmpeg.command", Character.valueOf('.'), substitutionKey}));
        if (StringUtils.isNotBlank((CharSequence)substitution)) {
            props.put(substitutionKey, substitution);
        }
        for (int i = 1; i <= tracks.size(); ++i) {
            substitutionKey = String.format("if-input-count-geq-%d", i);
            substitution = profile.getExtension(StringUtils.join((Object[])new Serializable[]{"ffmpeg.command", Character.valueOf('.'), substitutionKey}));
            if (!StringUtils.isNotBlank((CharSequence)substitution)) continue;
            props.put(substitutionKey, substitution);
        }
        tracks.entrySet().stream().map(e -> new Tuple((Object)((String)e.getKey()), Arrays.stream(((Track)e.getValue()).getTags()).filter(t -> StringUtils.startsWith((CharSequence)t, (CharSequence)"lang:")).map(t -> StringUtils.substring((String)t, (int)5)).filter(StringUtils::isNotBlank).findFirst())).filter(e -> ((Optional)e.getB()).isPresent()).forEach(e -> props.put(String.format("in.%s.language", e.getA()), LocaleUtils.toLocale((String)((String)((Optional)e.getB()).get())).getISO3Language()));
        logger.info("Encoding {} into {} using profile {}", new Object[]{tracks.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), ((Track)entry.getValue()).getIdentifier())).collect(Collectors.joining(", ")), targetTrackId, profileId});
        EncoderEngine encoder = this.getEncoderEngine();
        try {
            output = encoder.process(files, profile, props);
        }
        catch (EncoderException e2) {
            HashMap<String, String> params = new HashMap<String, String>();
            tracks.forEach((key, value) -> params.put((String)key, value.getIdentifier()));
            params.put("profile", profile.getIdentifier());
            params.put("properties", "EMPTY");
            this.incident().recordFailure(job, 7, (Throwable)e2, params, ComposerServiceImpl.detailsFor(e2, encoder));
            throw e2;
        }
        finally {
            this.activeEncoder.remove(encoder);
        }
        if (output.isEmpty()) {
            return Option.none();
        }
        if (output.size() != 1) {
            for (File file : output) {
                FileUtils.deleteQuietly((File)file);
            }
            throw new EncoderException("Composite does not support multiple files as output");
        }
        URI workspaceURI = this.putToCollection(job, output.get(0), "encoded file");
        Track inspectedTrack = this.inspect(job, workspaceURI);
        inspectedTrack.setIdentifier(targetTrackId);
        return Option.some((Object)inspectedTrack);
    }

    private List<Track> parallelEncode(Job job, Track mediaTrack, String profileId) throws EncoderException, MediaPackageException {
        if (job == null) {
            throw new EncoderException("The Job parameter must not be null");
        }
        File mediaFile = this.loadTrackIntoWorkspace(job, "source", mediaTrack, false);
        EncodingProfile profile = this.getProfile(profileId);
        EncoderEngine encoderEngine = this.getEncoderEngine();
        Optional<VideoStream> videoStream = Arrays.stream(mediaTrack.getStreams()).filter(stream -> stream instanceof VideoStream).map(stream -> (VideoStream)stream).findFirst();
        int height = videoStream.map(vs -> vs.getFrameHeight()).orElse(0);
        int width = videoStream.map(vs -> vs.getFrameWidth()).orElse(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String key : profile.getExtensions().keySet()) {
            if (key.startsWith("ffmpeg.command.if-height-geq-")) {
                int heightCondition = Integer.parseInt(key.substring("ffmpeg.command.if-height-geq-".length()));
                if (heightCondition > height) continue;
                properties.put(key, profile.getExtension(key));
                continue;
            }
            if (key.startsWith("ffmpeg.command.if-height-lt-")) {
                int heightCondition = Integer.parseInt(key.substring("ffmpeg.command.if-height-lt-".length()));
                if (heightCondition <= height) continue;
                properties.put(key, profile.getExtension(key));
                continue;
            }
            if (!key.startsWith("ffmpeg.command.if-width-or-height-geq-")) continue;
            String[] resCondition = key.substring("ffmpeg.command.if-width-or-height-geq-".length()).split("-");
            int widthCondition = Integer.parseInt(resCondition[0]);
            int heightCondition = Integer.parseInt(resCondition[1]);
            if (heightCondition > height && widthCondition > width) continue;
            properties.put(key, profile.getExtension(key));
        }
        LinkedList<Track> encodedTracks = new LinkedList<Track>();
        HashMap<String, File> source = new HashMap<String, File>();
        source.put("video", mediaFile);
        List<File> outputFiles = encoderEngine.process(source, profile, properties);
        ArrayList<URI> returnURLs = new ArrayList<URI>();
        ArrayList<List<String>> tagsForUrls = new ArrayList<List<String>>();
        this.activeEncoder.remove(encoderEngine);
        int i = 0;
        HashMap<String, CallSite> fileMapping = new HashMap<String, CallSite>();
        for (File file : outputFiles) {
            fileMapping.put(file.getName(), (CallSite)((Object)(job.getId() + "_" + i + "." + FilenameUtils.getExtension((String)file.getName()))));
            ++i;
        }
        boolean isHLS = false;
        for (File file : outputFiles) {
            if (AdaptivePlaylist.isPlaylist((File)file)) {
                isHLS = true;
                logger.debug("Rewriting HLS references in {}", (Object)file);
                try {
                    AdaptivePlaylist.hlsRewriteFileReference((File)file, fileMapping);
                }
                catch (IOException e) {
                    throw new EncoderException("Unable to rewrite HLS references", (Throwable)e);
                }
            }
            List tags = profile.getTags();
            try (FileInputStream in = new FileInputStream(file);){
                String encodedFileName = file.getName();
                String workspaceFilename = (String)fileMapping.get(encodedFileName);
                URI url = this.workspace.putInCollection(COLLECTION, workspaceFilename, (InputStream)in);
                returnURLs.add(url);
                ArrayList<String> tagsForUrl = new ArrayList<String>();
                for (String tag : tags) {
                    if (!encodedFileName.endsWith(profile.getSuffix(tag))) continue;
                    tagsForUrl.add(tag);
                }
                tagsForUrls.add(tagsForUrl);
                logger.info("Copied the encoded file to the workspace at {}", (Object)url);
            }
            catch (Exception e) {
                throw new EncoderException("Unable to put the encoded file into the workspace", (Throwable)e);
            }
        }
        for (Track inspectedTrack : this.inspect(job, returnURLs, tagsForUrls)) {
            String targetTrackId = IdImpl.fromUUID().toString();
            inspectedTrack.setIdentifier(targetTrackId);
            if (isHLS) {
                AdaptivePlaylist.setLogicalName((Track)inspectedTrack);
            }
            encodedTracks.add(inspectedTrack);
        }
        for (File encodingOutput : outputFiles) {
            if (encodingOutput.delete()) {
                logger.info("Deleted the local copy of the encoded file at {}", (Object)encodingOutput.getAbsolutePath());
                continue;
            }
            logger.warn("Unable to delete the encoding output at {}", (Object)encodingOutput);
        }
        return encodedTracks;
    }

    public Job parallelEncode(Track sourceTrack, String profileId) throws EncoderException, MediaPackageException {
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            logger.info("Starting parallel encode with profile {} with job load {}", (Object)profileId, (Object)df.format(profile.getJobLoad()));
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.ParallelEncode.toString(), Arrays.asList(profileId, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)), Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    public Job trim(Track sourceTrack, String profileId, long start, long duration) throws EncoderException, MediaPackageException {
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Trim.toString(), Arrays.asList(profileId, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack), Long.toString(start), Long.toString(duration)), Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    private Option<Track> trim(Job job, Track sourceTrack, String profileId, long start, long duration) throws EncoderException {
        File output;
        String targetTrackId = IdImpl.fromUUID().toString();
        File trackFile = this.loadTrackIntoWorkspace(job, "source", sourceTrack, false);
        EncodingProfile profile = this.getProfile(job, profileId);
        EncoderEngine encoderEngine = this.getEncoderEngine();
        try {
            output = encoderEngine.trim(trackFile, profile, start, duration, null);
        }
        catch (EncoderException e) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("track", sourceTrack.getURI().toString());
            params.put("profile", profile.getIdentifier());
            params.put("start", Long.toString(start));
            params.put("duration", Long.toString(duration));
            this.incident().recordFailure(job, 8, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
            throw e;
        }
        finally {
            this.activeEncoder.remove(encoderEngine);
        }
        if (!output.exists() || output.length() == 0L) {
            return Option.none();
        }
        URI workspaceURI = this.putToCollection(job, output, "trimmed file");
        Track inspectedTrack = this.inspect(job, workspaceURI);
        inspectedTrack.setIdentifier(targetTrackId);
        return Option.some((Object)inspectedTrack);
    }

    public Job mux(Track videoTrack, Track audioTrack, String profileId) throws EncoderException, MediaPackageException {
        return this.mux(Collections.map((Tuple[])new Tuple[]{Tuple.tuple((Object)"video", (Object)videoTrack), Tuple.tuple((Object)"audio", (Object)audioTrack)}), profileId);
    }

    public Job mux(Map<String, Track> sourceTracks, String profileId) throws EncoderException, MediaPackageException {
        try {
            if (sourceTracks == null || sourceTracks.size() < 2) {
                throw new EncoderException("At least two source tracks must be given.");
            }
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            ArrayList<String> jobArgs = new ArrayList<String>();
            jobArgs.add(profileId);
            for (Map.Entry<String, Track> entry : sourceTracks.entrySet()) {
                jobArgs.add(entry.getKey());
                jobArgs.add(MediaPackageElementParser.getAsXml((MediaPackageElement)((MediaPackageElement)entry.getValue())));
            }
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Mux.toString(), jobArgs, Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    private Option<Track> mux(Job job, Map<String, Track> tracks, String profileId) throws EncoderException, MediaPackageException {
        return this.encode(job, tracks, profileId);
    }

    public Job composite(Dimension compositeTrackSize, Option<LaidOutElement<Track>> upperTrack, LaidOutElement<Track> lowerTrack, Option<LaidOutElement<Attachment>> watermark, String profileId, String background, String sourceAudioName) throws EncoderException, MediaPackageException {
        ArrayList<String> arguments = new ArrayList<String>(10);
        arguments.add(0, profileId);
        arguments.add(1, MediaPackageElementParser.getAsXml((MediaPackageElement)lowerTrack.getElement()));
        arguments.add(2, Serializer.json((Layout)lowerTrack.getLayout()).toJson());
        if (upperTrack.isNone()) {
            arguments.add(3, NOT_AVAILABLE);
            arguments.add(4, NOT_AVAILABLE);
        } else {
            arguments.add(3, MediaPackageElementParser.getAsXml((MediaPackageElement)((LaidOutElement)upperTrack.get()).getElement()));
            arguments.add(4, Serializer.json((Layout)((LaidOutElement)upperTrack.get()).getLayout()).toJson());
        }
        arguments.add(5, Serializer.json((Dimension)compositeTrackSize).toJson());
        arguments.add(6, background);
        arguments.add(7, sourceAudioName);
        if (watermark.isSome()) {
            LaidOutElement watermarkLaidOutElement = (LaidOutElement)watermark.get();
            arguments.add(8, MediaPackageElementParser.getAsXml((MediaPackageElement)watermarkLaidOutElement.getElement()));
            arguments.add(9, Serializer.json((Layout)watermarkLaidOutElement.getLayout()).toJson());
        }
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Composite.toString(), arguments, Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create composite job", (Throwable)e);
        }
    }

    private Option<Track> composite(Job job, Dimension compositeTrackSize, LaidOutElement<Track> lowerLaidOutElement, Option<LaidOutElement<Track>> upperLaidOutElement, Option<LaidOutElement<Attachment>> watermarkOption, String profileId, String backgroundColor, String audioSourceName) throws EncoderException, MediaPackageException {
        EncodingProfile profile = this.getProfile(job, profileId);
        EncoderEngine encoderEngine = this.getEncoderEngine();
        String targetTrackId = IdImpl.fromUUID().toString();
        Option upperVideoFile = Option.none();
        try {
            List<File> output;
            File lowerVideoFile = this.loadTrackIntoWorkspace(job, "lower video", (Track)lowerLaidOutElement.getElement(), false);
            if (upperLaidOutElement.isSome()) {
                upperVideoFile = Option.option((Object)this.loadTrackIntoWorkspace(job, "upper video", (Track)((LaidOutElement)upperLaidOutElement.get()).getElement(), false));
            }
            File watermarkFile = null;
            if (watermarkOption.isSome()) {
                try {
                    watermarkFile = this.workspace.get(((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getURI());
                }
                catch (NotFoundException e) {
                    this.incident().recordFailure(job, 2, (Throwable)e, this.getWorkspaceMediapackageParams("watermark image", ((LaidOutElement)watermarkOption.get()).getElement()), Incidents.NO_DETAILS);
                    throw new EncoderException("Requested watermark image " + String.valueOf(((LaidOutElement)watermarkOption.get()).getElement()) + " is not found");
                }
                catch (IOException e) {
                    this.incident().recordFailure(job, 1, (Throwable)e, this.getWorkspaceMediapackageParams("watermark image", ((LaidOutElement)watermarkOption.get()).getElement()), Incidents.NO_DETAILS);
                    throw new EncoderException("Unable to access right watermark image " + String.valueOf(((LaidOutElement)watermarkOption.get()).getElement()));
                }
                if (upperLaidOutElement.isSome()) {
                    logger.info("Composing lower video track {} {} and upper video track {} {} including watermark {} {} into {}", new Object[]{((Track)lowerLaidOutElement.getElement()).getIdentifier(), ((Track)lowerLaidOutElement.getElement()).getURI(), ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).getIdentifier(), ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).getURI(), ((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getIdentifier(), ((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getURI(), targetTrackId});
                } else {
                    logger.info("Composing video track {} {} including watermark {} {} into {}", new Object[]{((Track)lowerLaidOutElement.getElement()).getIdentifier(), ((Track)lowerLaidOutElement.getElement()).getURI(), ((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getIdentifier(), ((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getURI(), targetTrackId});
                }
            } else if (upperLaidOutElement.isSome()) {
                logger.info("Composing lower video track {} {} and upper video track {} {} into {}", new Object[]{((Track)lowerLaidOutElement.getElement()).getIdentifier(), ((Track)lowerLaidOutElement.getElement()).getURI(), ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).getIdentifier(), ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).getURI(), targetTrackId});
            } else {
                logger.info("Composing video track {} {} into {}", new Object[]{((Track)lowerLaidOutElement.getElement()).getIdentifier(), ((Track)lowerLaidOutElement.getElement()).getURI(), targetTrackId});
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            Layout lowerLayout = lowerLaidOutElement.getLayout();
            String lowerPosition = lowerLayout.getOffset().getX() + ":" + lowerLayout.getOffset().getY();
            String scaleLower = lowerLayout.getDimension().getWidth() + ":" + lowerLayout.getDimension().getHeight();
            String padLower = compositeTrackSize.getWidth() + ":" + compositeTrackSize.getHeight() + ":" + lowerPosition + ":" + backgroundColor;
            properties.put("scaleLower", scaleLower);
            properties.put("padLower", padLower);
            if (upperVideoFile.isSome() && upperLaidOutElement.isSome()) {
                Layout upperLayout = ((LaidOutElement)upperLaidOutElement.get()).getLayout();
                String upperPosition = upperLayout.getOffset().getX() + ":" + upperLayout.getOffset().getY();
                String scaleUpper = upperLayout.getDimension().getWidth() + ":" + upperLayout.getDimension().getHeight();
                properties.put("scaleUpper", scaleUpper);
                properties.put("upperPosition", upperPosition);
                properties.put("upperFile", ((File)upperVideoFile.get()).getAbsolutePath());
                boolean lowerAudio = ((Track)lowerLaidOutElement.getElement()).hasAudio();
                boolean upperAudio = ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).hasAudio();
                if (lowerAudio && upperAudio && ("both".equalsIgnoreCase(audioSourceName) || StringUtils.isBlank((CharSequence)audioSourceName))) {
                    properties.put("ffmpeg.command.audioMapping", ";[0:a][1:a]amix=inputs=2[aout] -map [out] -map [aout]");
                } else if (lowerAudio && !"upper".equalsIgnoreCase(audioSourceName)) {
                    properties.put("ffmpeg.command.audioMapping", " -map [out] -map 0:a");
                } else if (upperAudio && !"lower".equalsIgnoreCase(audioSourceName)) {
                    properties.put("ffmpeg.command.audioMapping", " -map [out] -map 1:a");
                } else {
                    properties.put("ffmpeg.command.audioMapping", " -map [out]");
                }
            }
            if (watermarkOption.isSome()) {
                LaidOutElement watermarkLayout = (LaidOutElement)watermarkOption.get();
                String watermarkPosition = watermarkLayout.getLayout().getOffset().getX() + ":" + watermarkLayout.getLayout().getOffset().getY();
                properties.put("watermarkPosition", watermarkPosition);
                properties.put("watermarkFile", watermarkFile.getAbsoluteFile().toString());
            }
            for (String key : profile.getExtensions().keySet()) {
                if (key.startsWith("ffmpeg.command.if-single-stream") && (upperLaidOutElement.isNone() || upperVideoFile.isNone())) {
                    properties.put(key, profile.getExtension(key));
                    continue;
                }
                if (key.startsWith("ffmpeg.command.if-dual-stream") && upperVideoFile.isSome() && upperLaidOutElement.isSome()) {
                    properties.put(key, profile.getExtension(key));
                    continue;
                }
                if (key.startsWith("ffmpeg.command.if-watermark") && watermarkOption.isSome()) {
                    properties.put(key, profile.getExtension(key));
                    continue;
                }
                if (!key.startsWith("ffmpeg.command.if-no-watermark") || !watermarkOption.isNone()) continue;
                properties.put(key, profile.getExtension(key));
            }
            try {
                HashMap<String, File> source = new HashMap<String, File>();
                if (upperVideoFile.isSome()) {
                    source.put("audio", (File)upperVideoFile.get());
                }
                source.put("video", lowerVideoFile);
                output = encoderEngine.process(source, profile, properties);
            }
            catch (EncoderException e) {
                HashMap<String, String> params = new HashMap<String, String>();
                if (upperLaidOutElement.isSome()) {
                    params.put("upper", ((Track)((LaidOutElement)upperLaidOutElement.get()).getElement()).getURI().toString());
                }
                params.put("lower", ((Track)lowerLaidOutElement.getElement()).getURI().toString());
                if (watermarkFile != null) {
                    params.put("watermark", ((Attachment)((LaidOutElement)watermarkOption.get()).getElement()).getURI().toString());
                }
                params.put("profile", profile.getIdentifier());
                params.put("properties", ((Object)properties).toString());
                this.incident().recordFailure(job, 9, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
                throw e;
            }
            finally {
                this.activeEncoder.remove(encoderEngine);
            }
            if (output.size() != 1) {
                for (File file : output) {
                    FileUtils.deleteQuietly((File)file);
                }
                throw new EncoderException("Composite does not support multiple files as output");
            }
            URI workspaceURI = this.putToCollection(job, output.get(0), "compound file");
            Track inspectedTrack = this.inspect(job, workspaceURI);
            inspectedTrack.setIdentifier(targetTrackId);
            return Option.some((Object)inspectedTrack);
        }
        catch (Exception e) {
            if (upperLaidOutElement.isSome()) {
                logger.warn("Error composing {}  and {}:", new Object[]{lowerLaidOutElement.getElement(), ((LaidOutElement)upperLaidOutElement.get()).getElement(), e});
            } else {
                logger.warn("Error composing {}:", (Object)lowerLaidOutElement.getElement(), (Object)e);
            }
            if (e instanceof EncoderException) {
                throw (EncoderException)((Object)e);
            }
            throw new EncoderException((Throwable)e);
        }
    }

    public Job concat(String profileId, Dimension outputDimension, boolean sameCodec, Track ... tracks) throws EncoderException, MediaPackageException {
        return this.concat(profileId, outputDimension, -1.0f, sameCodec, tracks);
    }

    public Job concat(String profileId, Dimension outputDimension, float outputFrameRate, boolean sameCodec, Track ... tracks) throws EncoderException, MediaPackageException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(0, profileId);
        if (outputDimension != null) {
            arguments.add(1, Serializer.json((Dimension)outputDimension).toJson());
        } else {
            arguments.add(1, "");
        }
        arguments.add(2, String.format(Locale.US, "%f", Float.valueOf(outputFrameRate)));
        arguments.add(3, Boolean.toString(sameCodec));
        for (int i = 0; i < tracks.length; ++i) {
            arguments.add(i + 4, MediaPackageElementParser.getAsXml((MediaPackageElement)tracks[i]));
        }
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Concat.toString(), arguments, Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create concat job", (Throwable)e);
        }
    }

    private Option<Track> concat(Job job, List<Track> tracks, String profileId, Dimension outputDimension, float outputFrameRate, boolean sameCodec) throws EncoderException, MediaPackageException {
        File output;
        Object concatCommand;
        if (tracks.size() < 2) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tracks-size", Integer.toString(tracks.size()));
            params.put("tracks", StringUtils.join(tracks, (String)","));
            this.incident().recordFailure(job, 11, params);
            throw new EncoderException("The track parameter must at least have two tracks present");
        }
        boolean onlyAudio = true;
        for (Track t : tracks) {
            if (!t.hasVideo()) continue;
            onlyAudio = false;
            break;
        }
        if (!sameCodec && !onlyAudio && outputDimension == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tracks", StringUtils.join(tracks, (String)","));
            this.incident().recordFailure(job, 12, params);
            throw new EncoderException("The output dimension id parameter must not be null when concatenating video");
        }
        String targetTrackId = IdImpl.fromUUID().toString();
        ArrayList<File> trackFiles = new ArrayList<File>();
        int i = 0;
        for (Track track : tracks) {
            if (!track.hasAudio() && !track.hasVideo()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("track-id", track.getIdentifier());
                params.put("track-url", track.getURI().toString());
                this.incident().recordFailure(job, 23, params);
                throw new EncoderException("Track has no audio or video stream available: " + String.valueOf(track));
            }
            trackFiles.add(i++, this.loadTrackIntoWorkspace(job, "concat", track, false));
        }
        EncoderEngine encoderEngine = this.getEncoderEngine();
        if (onlyAudio) {
            logger.info("Concatenating audio tracks {} into {}", trackFiles, (Object)targetTrackId);
        } else {
            logger.info("Concatenating video tracks {} into {}", trackFiles, (Object)targetTrackId);
        }
        EncodingProfile profile = this.getProfile(job, profileId);
        File fileList = null;
        if (sameCodec) {
            fileList = new File(this.workspace.rootDirectory(), "concat_tracklist_" + job.getId() + ".txt");
            fileList.deleteOnExit();
            try (PrintWriter printer = new PrintWriter(new FileWriter(fileList, true));){
                for (Track track : tracks) {
                    printer.append("file '").append(this.workspace.get(track.getURI()).getAbsolutePath()).append("'\n");
                }
            }
            catch (IOException e) {
                throw new EncoderException("Cannot create file list for concat", (Throwable)e);
            }
            catch (NotFoundException e) {
                throw new EncoderException("Cannot find track filename in workspace for concat", (Throwable)e);
            }
            concatCommand = "-f concat -safe 0 -i " + fileList.getAbsolutePath();
        } else {
            concatCommand = this.buildConcatCommand(onlyAudio, outputDimension, outputFrameRate, trackFiles, tracks);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ffmpeg.command.concatCommand", (String)concatCommand);
        try {
            output = encoderEngine.encode((File)trackFiles.get(0), profile, properties);
        }
        catch (EncoderException e) {
            HashMap<String, String> params = new HashMap<String, String>();
            ArrayList<String> trackList = new ArrayList<String>();
            for (Track t : tracks) {
                trackList.add(t.getURI().toString());
            }
            params.put("tracks", StringUtils.join(trackList, (String)","));
            params.put("profile", profile.getIdentifier());
            params.put("properties", ((Object)properties).toString());
            this.incident().recordFailure(job, 10, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
            throw e;
        }
        finally {
            this.activeEncoder.remove(encoderEngine);
            if (fileList != null) {
                FileSupport.deleteQuietly((File)fileList);
            }
        }
        if (!output.exists() || output.length() == 0L) {
            return Option.none();
        }
        URI workspaceURI = this.putToCollection(job, output, "concatenated file");
        Track inspectedTrack = this.inspect(job, workspaceURI);
        inspectedTrack.setIdentifier(targetTrackId);
        return Option.some((Object)inspectedTrack);
    }

    public Job imageToVideo(Attachment sourceImageAttachment, String profileId, double time) throws EncoderException, MediaPackageException {
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            if (profile == null) {
                throw new MediaPackageException(String.format("Encoding profile %s not found", profileId));
            }
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.ImageToVideo.toString(), Arrays.asList(profileId, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceImageAttachment), Double.toString(time)), Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create image to video job", (Throwable)e);
        }
    }

    private Option<Track> imageToVideo(Job job, Attachment sourceImage, String profileId, Double time) throws EncoderException, MediaPackageException {
        File output;
        File imageFile;
        EncodingProfile profile = this.getProfile(job, profileId);
        String targetTrackId = IdImpl.fromUUID().toString();
        try {
            imageFile = this.workspace.get(sourceImage.getURI());
        }
        catch (NotFoundException e) {
            this.incident().recordFailure(job, 2, (Throwable)e, this.getWorkspaceMediapackageParams("source image", (MediaPackageElement)sourceImage), Incidents.NO_DETAILS);
            throw new EncoderException("Requested source image " + String.valueOf(sourceImage) + " is not found");
        }
        catch (IOException e) {
            this.incident().recordFailure(job, 1, (Throwable)e, this.getWorkspaceMediapackageParams("source image", (MediaPackageElement)sourceImage), Incidents.NO_DETAILS);
            throw new EncoderException("Unable to access source image " + String.valueOf(sourceImage));
        }
        EncoderEngine encoderEngine = this.getEncoderEngine();
        logger.info("Converting image attachment {} into video {}", (Object)sourceImage.getIdentifier(), (Object)targetTrackId);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (time == -1.0) {
            time = 0.0;
        }
        DecimalFormatSymbols ffmpegFormat = new DecimalFormatSymbols();
        ffmpegFormat.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("0.000", ffmpegFormat);
        properties.put("time", df.format(time));
        try {
            output = encoderEngine.encode(imageFile, profile, properties);
        }
        catch (EncoderException e) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("image", sourceImage.getURI().toString());
            params.put("profile", profile.getIdentifier());
            params.put("properties", ((Object)properties).toString());
            this.incident().recordFailure(job, 13, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
            throw e;
        }
        finally {
            this.activeEncoder.remove(encoderEngine);
        }
        if (!output.exists() || output.length() == 0L) {
            return Option.none();
        }
        URI workspaceURI = this.putToCollection(job, output, "converted image file");
        Track inspectedTrack = this.inspect(job, workspaceURI);
        inspectedTrack.setIdentifier(targetTrackId);
        return Option.some((Object)inspectedTrack);
    }

    public Job image(Track sourceTrack, String profileId, double ... times) throws EncoderException, MediaPackageException {
        if (sourceTrack == null) {
            throw new IllegalArgumentException("SourceTrack cannot be null");
        }
        if (times.length == 0) {
            throw new IllegalArgumentException("At least one time argument has to be specified");
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(profileId);
        parameters.add(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack));
        parameters.add(Boolean.TRUE.toString());
        for (double time : times) {
            parameters.add(Double.toString(time));
        }
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Image.toString(), parameters, Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    public List<Attachment> imageSync(Track sourceTrack, String profileId, double ... time) throws EncoderException, MediaPackageException {
        List<Attachment> list;
        Job job = null;
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            job = this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Image.toString(), null, null, false, Float.valueOf(profile.getJobLoad()));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            List<Attachment> images = this.extractImages(job, sourceTrack, profileId, null, time);
            job.setStatus(Job.Status.FINISHED);
            list = images;
        }
        catch (ServiceRegistryException | NotFoundException e) {
            try {
                throw new EncoderException("Unable to create a job", e);
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return list;
    }

    public Job image(Track sourceTrack, String profileId, Map<String, String> properties) throws EncoderException, MediaPackageException {
        if (sourceTrack == null) {
            throw new IllegalArgumentException("SourceTrack cannot be null");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(profileId);
        arguments.add(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack));
        arguments.add(Boolean.FALSE.toString());
        arguments.add(this.getPropertiesAsString(properties));
        try {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Image.toString(), arguments, Float.valueOf(profile.getJobLoad()));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    private List<Attachment> extractImages(Job job, Track sourceTrack, String profileId, Map<String, String> properties, double ... times) throws EncoderException {
        List<File> encodingOutput;
        if (sourceTrack == null) {
            throw new EncoderException("SourceTrack cannot be null");
        }
        logger.info("creating an image using video track {}", (Object)sourceTrack.getIdentifier());
        EncodingProfile profile = this.getProfile(job, profileId);
        EncoderEngine encoderEngine = this.getEncoderEngine();
        File videoFile = this.loadTrackIntoWorkspace(job, "video", sourceTrack, true);
        try {
            encodingOutput = encoderEngine.extract(videoFile, profile, properties, times);
            if (encodingOutput == null || encodingOutput.isEmpty()) {
                logger.error("Image extraction from video {} with profile {} failed: no images were produced", (Object)sourceTrack.getURI(), (Object)profile.getIdentifier());
                throw new EncoderException("Image extraction failed: no images were produced");
            }
        }
        catch (EncoderException e) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("video", sourceTrack.getURI().toString());
            params.put("profile", profile.getIdentifier());
            params.put("positions", Arrays.toString(times));
            this.incident().recordFailure(job, 15, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
            throw e;
        }
        finally {
            this.activeEncoder.remove(encoderEngine);
        }
        int i = 0;
        LinkedList<URI> workspaceURIs = new LinkedList<URI>();
        for (File output : encodingOutput) {
            if (!output.exists() || output.length() == 0L) {
                logger.warn("Extracted image {} is empty!", (Object)output);
                throw new EncoderException("Extracted image " + output.toString() + " is empty!");
            }
            try (FileInputStream in = new FileInputStream(output);){
                URI returnURL = this.workspace.putInCollection(COLLECTION, job.getId() + "_" + i++ + "." + FilenameUtils.getExtension((String)output.getAbsolutePath()), (InputStream)in);
                logger.debug("Copied image file to the workspace at {}", (Object)returnURL);
                workspaceURIs.add(returnURL);
            }
            catch (Exception e) {
                this.cleanup(encodingOutput.toArray(new File[encodingOutput.size()]));
                this.cleanupWorkspace(workspaceURIs.toArray(new URI[workspaceURIs.size()]));
                this.incident().recordFailure(job, 3, (Throwable)e, this.getWorkspaceCollectionParams("extracted image file", COLLECTION, output.toURI()), Incidents.NO_DETAILS);
                throw new EncoderException("Unable to put image file into the workspace", (Throwable)e);
            }
        }
        this.cleanup(encodingOutput.toArray(new File[encodingOutput.size()]));
        this.cleanup(videoFile);
        MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        LinkedList<Attachment> imageAttachments = new LinkedList<Attachment>();
        for (URI url : workspaceURIs) {
            Attachment attachment = (Attachment)builder.elementFromURI(url, Attachment.TYPE, null);
            try {
                attachment.setSize(this.workspace.get(url).length());
            }
            catch (IOException | NotFoundException e) {
                logger.warn("Could not get file size of {}", (Object)url);
            }
            imageAttachments.add(attachment);
        }
        return imageAttachments;
    }

    public Job convertImage(Attachment image, String ... profileIds) throws EncoderException, MediaPackageException {
        if (image == null) {
            throw new IllegalArgumentException("Source image cannot be null");
        }
        if (profileIds == null) {
            throw new IllegalArgumentException("At least one encoding profile must be set");
        }
        Gson gson = new Gson();
        List<String> params = Arrays.asList(gson.toJson((Object)profileIds), MediaPackageElementParser.getAsXml((MediaPackageElement)image));
        float jobLoad = Arrays.stream(profileIds).map(p -> Float.valueOf(this.profileScanner.getProfile((String)p).getJobLoad())).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
        try {
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.ImageConversion.toString(), params, Float.valueOf(jobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    public List<Attachment> convertImageSync(Attachment image, String ... profileIds) throws EncoderException, MediaPackageException {
        List<Attachment> list;
        Job job = null;
        try {
            float jobLoad = (float)Arrays.stream(profileIds).map(p -> this.profileScanner.getProfile((String)p)).mapToDouble(EncodingProfile::getJobLoad).max().orElse(0.0);
            job = this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Image.toString(), null, null, false, Float.valueOf(jobLoad));
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            List<Attachment> results = this.convertImage(job, image, profileIds);
            job.setStatus(Job.Status.FINISHED);
            if (results.isEmpty()) {
                throw new EncoderException(String.format("Unable to convert image %s with encoding profiles %s. The result set is empty.", image.getURI().toString(), profileIds));
            }
            list = results;
        }
        catch (ServiceRegistryException | NotFoundException e) {
            try {
                throw new EncoderException("Unable to create a job", e);
            }
            catch (Throwable throwable) {
                this.finallyUpdateJob(job);
                throw throwable;
            }
        }
        this.finallyUpdateJob(job);
        return list;
    }

    private List<Attachment> convertImage(Job job, Attachment sourceImage, String ... profileIds) throws EncoderException, MediaPackageException {
        ArrayList<Attachment> convertedImages = new ArrayList<Attachment>();
        EncoderEngine encoderEngine = this.getEncoderEngine();
        try {
            for (String profileId : profileIds) {
                File output;
                File imageFile;
                logger.info("Converting {} using encoding profile {}", (Object)sourceImage, (Object)profileId);
                EncodingProfile profile = this.getProfile(job, profileId);
                try {
                    imageFile = this.workspace.get(sourceImage.getURI());
                }
                catch (NotFoundException e) {
                    this.incident().recordFailure(job, 2, (Throwable)e, this.getWorkspaceMediapackageParams("source image", (MediaPackageElement)sourceImage), Incidents.NO_DETAILS);
                    throw new EncoderException("Requested attachment " + String.valueOf(sourceImage) + " was not found", (Throwable)e);
                }
                catch (IOException e) {
                    this.incident().recordFailure(job, 1, (Throwable)e, this.getWorkspaceMediapackageParams("source image", (MediaPackageElement)sourceImage), Incidents.NO_DETAILS);
                    throw new EncoderException("Error accessing attachment " + String.valueOf(sourceImage), (Throwable)e);
                }
                try {
                    output = encoderEngine.encode(imageFile, profile, null);
                }
                catch (EncoderException e) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("image", sourceImage.getURI().toString());
                    params.put("profile", profile.getIdentifier());
                    this.incident().recordFailure(job, 14, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
                    throw e;
                }
                if (!output.exists() || output.length() == 0L) {
                    throw new EncoderException(String.format("Image conversion job %d didn't created an output file for the source image %s with encoding profile %s", job.getId(), sourceImage.getURI().toString(), profileId));
                }
                URI workspaceURI = this.putToCollection(job, output, "converted image file");
                MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
                Attachment convertedImage = (Attachment)builder.elementFromURI(workspaceURI, Attachment.TYPE, null);
                convertedImage.setSize(output.length());
                convertedImage.setIdentifier(IdImpl.fromUUID().toString());
                try {
                    convertedImage.setMimeType(MimeTypes.fromURI((URI)convertedImage.getURI()));
                }
                catch (UnknownFileTypeException e) {
                    logger.warn("Mime type unknown for file {}. Setting none.", (Object)convertedImage.getURI(), (Object)e);
                }
                convertedImages.add(convertedImage);
            }
        }
        catch (Throwable t) {
            for (Attachment convertedImage : convertedImages) {
                try {
                    this.workspace.delete(convertedImage.getURI());
                }
                catch (NotFoundException profileId) {
                }
                catch (IOException ex) {
                    logger.warn("Unable to delete converted image {} from workspace", (Object)convertedImage.getURI(), (Object)ex);
                }
            }
            throw t;
        }
        finally {
            this.activeEncoder.remove(encoderEngine);
        }
        return convertedImages;
    }

    protected String process(Job job) throws ServiceRegistryException {
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            Operation op = Operation.valueOf(operation);
            String encodingProfile = (String)arguments.get(0);
            return switch (op.ordinal()) {
                case 0 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    yield (String)this.encode(job, Collections.map((Tuple[])new Tuple[]{Tuple.tuple((Object)"video", (Object)firstTrack)}), encodingProfile).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 8 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    yield MediaPackageElementParser.getArrayAsXml(this.parallelEncode(job, firstTrack, encodingProfile));
                }
                case 1 -> {
                    List<Attachment> resultingElements;
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    if (Boolean.parseBoolean((String)arguments.get(2))) {
                        double[] times = new double[arguments.size() - 3];
                        for (int i = 3; i < arguments.size(); ++i) {
                            times[i - 3] = Double.parseDouble((String)arguments.get(i));
                        }
                        resultingElements = this.extractImages(job, firstTrack, encodingProfile, null, times);
                    } else {
                        Map<String, String> properties = this.parseProperties((String)arguments.get(3));
                        resultingElements = this.extractImages(job, firstTrack, encodingProfile, properties, new double[0]);
                    }
                    yield MediaPackageElementParser.getArrayAsXml(resultingElements);
                }
                case 2 -> {
                    Gson gson = new Gson();
                    String[] encodingProfilesArr = (String[])gson.fromJson((String)arguments.get(0), String[].class);
                    Attachment sourceImage = (Attachment)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    List<Attachment> convertedImages = this.convertImage(job, sourceImage, encodingProfilesArr);
                    yield MediaPackageElementParser.getArrayAsXml(convertedImages);
                }
                case 3 -> {
                    HashMap<String, Track> sourceTracks = new HashMap<String, Track>();
                    for (int i = 1; i < arguments.size(); i += 2) {
                        String key = (String)arguments.get(i);
                        Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(i + 1)));
                        sourceTracks.put(key, firstTrack);
                    }
                    yield (String)this.mux(job, sourceTracks, encodingProfile).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 4 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    long start = Long.parseLong((String)arguments.get(2));
                    long duration = Long.parseLong((String)arguments.get(3));
                    yield (String)this.trim(job, firstTrack, encodingProfile, start, duration).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 5 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    Layout lowerLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)((String)arguments.get(2))));
                    LaidOutElement lowerLaidOutElement = new LaidOutElement((MediaPackageElement)firstTrack, lowerLayout);
                    Option upperLaidOutElement = Option.none();
                    if (NOT_AVAILABLE.equals(arguments.get(3)) && NOT_AVAILABLE.equals(arguments.get(4))) {
                        logger.trace("This composite action does not use a second track.");
                    } else {
                        Track secondTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(3)));
                        Layout upperLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)((String)arguments.get(4))));
                        upperLaidOutElement = Option.option((Object)new LaidOutElement((MediaPackageElement)secondTrack, upperLayout));
                    }
                    Dimension compositeTrackSize = Serializer.dimension((JsonObj)JsonObj.jsonObj((String)((String)arguments.get(5))));
                    String backgroundColor = (String)arguments.get(6);
                    String audioSourceName = (String)arguments.get(7);
                    Option watermarkOption = Option.none();
                    if (arguments.size() > 8 && arguments.size() <= 10) {
                        Attachment watermarkAttachment = (Attachment)MediaPackageElementParser.getFromXml((String)((String)arguments.get(8)));
                        Layout watermarkLayout = Serializer.layout((JsonObj)JsonObj.jsonObj((String)((String)arguments.get(9))));
                        watermarkOption = Option.some((Object)new LaidOutElement((MediaPackageElement)watermarkAttachment, watermarkLayout));
                    } else if (arguments.size() > 10) {
                        throw new IndexOutOfBoundsException("Too many composite arguments!");
                    }
                    yield (String)this.composite(job, compositeTrackSize, (LaidOutElement<Track>)lowerLaidOutElement, (Option<LaidOutElement<Track>>)upperLaidOutElement, (Option<LaidOutElement<Attachment>>)watermarkOption, encodingProfile, backgroundColor, audioSourceName).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 6 -> {
                    String dimensionString = (String)arguments.get(1);
                    String frameRateString = (String)arguments.get(2);
                    Dimension outputDimension = null;
                    if (StringUtils.isNotBlank((CharSequence)dimensionString)) {
                        outputDimension = Serializer.dimension((JsonObj)JsonObj.jsonObj((String)dimensionString));
                    }
                    float outputFrameRate = NumberUtils.toFloat((String)frameRateString, (float)-1.0f);
                    boolean sameCodec = Boolean.parseBoolean((String)arguments.get(3));
                    ArrayList<Track> tracks = new ArrayList<Track>();
                    for (int i = 4; i < arguments.size(); ++i) {
                        tracks.add(i - 4, (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(i))));
                    }
                    yield (String)this.concat(job, tracks, encodingProfile, outputDimension, outputFrameRate, sameCodec).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 7 -> {
                    Attachment image = (Attachment)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    double time = Double.parseDouble((String)arguments.get(2));
                    yield (String)this.imageToVideo(job, image, encodingProfile, time).map(MediaPackageElementParser.getAsXml()).getOrElse((Object)"");
                }
                case 9 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                    List<Track> outTracks = this.demux(job, firstTrack, encodingProfile);
                    yield StringUtils.trimToEmpty((String)MediaPackageElementParser.getArrayAsXml(outTracks));
                }
                case 10 -> {
                    Smil smil = this.smilService.fromXml((String)arguments.get(0)).getSmil();
                    String trackParamGroupId = (String)arguments.get(1);
                    String mediaType = (String)arguments.get(2);
                    List<String> encodingProfiles = arguments.subList(3, arguments.size());
                    List<Track> outTracks = this.processSmil(job, smil, trackParamGroupId, mediaType, encodingProfiles);
                    yield StringUtils.trimToEmpty((String)MediaPackageElementParser.getArrayAsXml(outTracks));
                }
                case 11 -> {
                    Track firstTrack = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    List<String> encodingProfiles2 = arguments.subList(1, arguments.size());
                    List<Track> outTracks = this.multiEncode(job, firstTrack, encodingProfiles2);
                    yield StringUtils.trimToEmpty((String)MediaPackageElementParser.getArrayAsXml(outTracks));
                }
                default -> throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
            };
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException(String.format("Cannot handle operations of type '%s'", operation), (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException(String.format("Invalid arguments for operation '%s'", operation), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException(String.format("Error handling operation '%s'", operation), (Throwable)e);
        }
    }

    public EncodingProfile[] listProfiles() {
        Collection<EncodingProfile> profiles = this.profileScanner.getProfiles().values();
        return profiles.toArray(new EncodingProfile[profiles.size()]);
    }

    public EncodingProfile getProfile(String profileId) {
        return this.profileScanner.getProfiles().get(profileId);
    }

    protected List<Track> inspect(Job job, List<URI> uris, List<List<String>> tags) throws EncoderException {
        Job[] inspectionJobs = new Job[uris.size()];
        for (int i = 0; i < uris.size(); ++i) {
            try {
                inspectionJobs[i] = this.inspectionService.inspect(uris.get(i));
                continue;
            }
            catch (MediaInspectionException e) {
                this.incident().recordJobCreationIncident(job, (Throwable)e);
                throw new EncoderException(String.format("Media inspection of %s failed", uris.get(i)), (Throwable)e);
            }
        }
        JobBarrier barrier = new JobBarrier(job, this.serviceRegistry, inspectionJobs);
        if (!barrier.waitForJobs().isSuccess()) {
            for (Map.Entry result : barrier.getStatus().getStatus().entrySet()) {
                if (result.getValue() == Job.Status.FINISHED) continue;
                logger.error("Media inspection failed in job {}: {}", result.getKey(), result.getValue());
            }
            throw new EncoderException("Inspection of encoded file failed");
        }
        ArrayList<Track> results = new ArrayList<Track>(uris.size());
        int i = 0;
        for (Job inspectionJob : inspectionJobs) {
            try {
                Track track = (Track)MediaPackageElementParser.getFromXml((String)inspectionJob.getPayload());
                List<String> tagsForTrack = tags.get(i);
                for (String tag : tagsForTrack) {
                    track.addTag(tag);
                }
                results.add(track);
            }
            catch (MediaPackageException e) {
                throw new EncoderException((Throwable)e);
            }
            ++i;
        }
        return results;
    }

    protected List<Track> inspect(Job job, List<URI> uris) throws EncoderException {
        List<List<String>> tags = java.util.Collections.nCopies(uris.size(), new ArrayList());
        return this.inspect(job, uris, tags);
    }

    protected Track inspect(Job job, URI workspaceURI) throws EncoderException {
        return this.inspect(job, java.util.Collections.singletonList(workspaceURI)).get(0);
    }

    private void cleanup(File ... encodingOutput) {
        for (File file : encodingOutput) {
            if (file == null || !file.isFile()) continue;
            String path = file.getAbsolutePath();
            if (file.delete()) {
                logger.info("Deleted local copy of encoding file at {}", (Object)path);
                continue;
            }
            logger.warn("Could not delete local copy of encoding file at {}", (Object)path);
        }
    }

    private void cleanupWorkspace(URI ... workspaceURIs) {
        for (URI url : workspaceURIs) {
            try {
                this.workspace.delete(url);
            }
            catch (Exception e) {
                logger.warn("Could not delete {} from workspace: {}", (Object)url, (Object)e.getMessage());
            }
        }
    }

    private EncoderEngine getEncoderEngine() {
        EncoderEngine engine = new EncoderEngine(this.ffmpegBinary);
        this.activeEncoder.add(engine);
        return engine;
    }

    private EncodingProfile getProfile(Job job, String profileId) throws EncoderException {
        EncodingProfile profile = this.profileScanner.getProfile(profileId);
        if (profile == null) {
            String msg = String.format("Profile %s is unknown", profileId);
            logger.error(msg);
            this.incident().recordFailure(job, 4, Collections.map((Tuple[])new Tuple[]{Tuple.tuple((Object)"profile", (Object)profileId)}));
            throw new EncoderException(msg);
        }
        return profile;
    }

    private Map<String, String> getWorkspaceMediapackageParams(String description, MediaPackageElement element) {
        return Collections.map((Tuple[])new Tuple[]{Tuple.tuple((Object)"description", (Object)description), Tuple.tuple((Object)"type", (Object)element.getElementType().toString()), Tuple.tuple((Object)"url", (Object)element.getURI().toString())});
    }

    private Map<String, String> getWorkspaceCollectionParams(String description, String collectionId, URI url) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("description", description);
        params.put("collection", collectionId);
        params.put("url", url.toString());
        return params;
    }

    private String buildConcatCommand(boolean onlyAudio, Dimension dimension, float outputFrameRate, List<File> files, List<Track> tracks) {
        StringBuilder sb = new StringBuilder();
        for (File f : files) {
            sb.append("-i ").append(f.getAbsolutePath()).append(" ");
        }
        sb.append("-filter_complex ");
        boolean hasAudio = false;
        if (!onlyAudio) {
            int i;
            String fpsFilter = "";
            if (outputFrameRate > 0.0f) {
                fpsFilter = String.format(Locale.US, "fps=fps=%f,", Float.valueOf(outputFrameRate));
            }
            int characterCount = 0;
            for (i = 0; i < files.size(); ++i) {
                if (i % 25 == 0) {
                    ++characterCount;
                }
                sb.append("[").append(i).append(":v]").append(fpsFilter).append("scale=iw*min(").append(dimension.getWidth()).append("/iw\\,").append(dimension.getHeight()).append("/ih):ih*min(").append(dimension.getWidth()).append("/iw\\,").append(dimension.getHeight()).append("/ih),pad=").append(dimension.getWidth()).append(":").append(dimension.getHeight()).append(":(ow-iw)/2:(oh-ih)/2").append(",setdar=").append((float)dimension.getWidth() / (float)dimension.getHeight()).append("[");
                int character = 97 + i + 1 - (characterCount - 1) * 25;
                for (int y = 0; y < characterCount; ++y) {
                    sb.append((char)character);
                }
                sb.append("];");
                if (!tracks.get(i).hasAudio()) continue;
                hasAudio = true;
            }
            if (hasAudio) {
                for (i = 0; i < files.size(); ++i) {
                    if (tracks.get(i).hasAudio()) continue;
                    sb.append("aevalsrc=0:d=1[silent").append(i + 1).append("];");
                }
            }
        }
        int characterCount = 0;
        for (int i = 0; i < files.size(); ++i) {
            if (i % 25 == 0) {
                ++characterCount;
            }
            int character = 97 + i + 1 - (characterCount - 1) * 25;
            if (!onlyAudio) {
                sb.append("[");
                for (int y = 0; y < characterCount; ++y) {
                    sb.append((char)character);
                }
                sb.append("]");
            }
            if (tracks.get(i).hasAudio()) {
                sb.append("[").append(i).append(":a]");
                continue;
            }
            if (!hasAudio) continue;
            sb.append("[silent").append(i + 1).append("]");
        }
        sb.append("concat=n=").append(files.size()).append(":v=");
        if (onlyAudio) {
            sb.append("0");
        } else {
            sb.append("1");
        }
        sb.append(":a=");
        if (!onlyAudio) {
            if (hasAudio) {
                sb.append("1[v][a] -map [v] -map [a] ");
            } else {
                sb.append("0[v] -map [v] ");
            }
        } else {
            sb.append("1[a] -map [a]");
        }
        return sb.toString();
    }

    protected void hlsFixReference(long id, List<File> outputs) throws IOException {
        Map<String, String> nameMap = outputs.stream().collect(Collectors.toMap(file -> FilenameUtils.getName((String)file.getAbsolutePath()), file -> this.renameJobFile(id, (File)file)));
        for (File file2 : outputs) {
            if (!AdaptivePlaylist.isPlaylist((File)file2)) continue;
            AdaptivePlaylist.hlsRewriteFileReference((File)file2, nameMap);
        }
    }

    private String renameJobFile(long jobId, File file) {
        return this.workspace.toSafeName(String.format("%s.%s", jobId, FilenameUtils.getName((String)file.getAbsolutePath())));
    }

    protected void hlsSetReference(Track track) throws IOException {
        if (!AdaptivePlaylist.checkForMaster((File)new File(track.getURI().getPath()))) {
            track.setLogicalName(FilenameUtils.getName((String)track.getURI().getPath()));
        }
    }

    private List<URI> putToCollection(Job job, List<File> files, String description) throws EncoderException {
        ArrayList<URI> returnURLs = new ArrayList<URI>(files.size());
        for (File file : files) {
            try (FileInputStream in = new FileInputStream(file);){
                URI newFileURI = this.workspace.putInCollection(COLLECTION, this.renameJobFile(job.getId(), file), (InputStream)in);
                logger.info("Copied the {} to the workspace at {}", (Object)description, (Object)newFileURI);
                returnURLs.add(newFileURI);
            }
            catch (Exception e) {
                try {
                    this.incident().recordFailure(job, 3, (Throwable)e, this.getWorkspaceCollectionParams(description, COLLECTION, file.toURI()), Incidents.NO_DETAILS);
                    returnURLs.forEach(xva$0 -> this.cleanupWorkspace((URI)xva$0));
                    throw new EncoderException("Unable to put the " + description + " into the workspace", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.cleanup(file);
                    throw throwable;
                }
            }
            this.cleanup(file);
        }
        return returnURLs;
    }

    private URI putToCollection(Job job, File output, String description) throws EncoderException {
        return this.putToCollection(job, java.util.Collections.singletonList(output), description).get(0);
    }

    private static List<Tuple<String, String>> detailsFor(EncoderException ex, EncoderEngine engine) {
        ArrayList<Tuple<String, String>> d = new ArrayList<Tuple<String, String>>();
        d.add(Tuple.tuple((Object)"encoder-engine-class", (Object)engine.getClass().getName()));
        return d;
    }

    private Map<String, String> parseProperties(String serializedProperties) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = IOUtils.toInputStream((String)serializedProperties, (String)"UTF-8");){
            properties.load(in);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                map.put((String)e.getKey(), (String)e.getValue());
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    private String getPropertiesAsString(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Reference
    protected void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.inspectionService = mediaInspectionService;
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    protected void setProfileScanner(EncodingProfileScanner scanner) {
        this.profileScanner = scanner;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference(target="(artifact=encodingprofile)")
    public void setEncodingProfileReadinessIndicator(ReadinessIndicator unused) {
    }

    public Job demux(Track sourceTrack, String profileId) throws EncoderException, MediaPackageException {
        try {
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.Demux.toString(), Arrays.asList(profileId, MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    private List<Track> demux(Job job, Track videoTrack, String encodingProfile) throws EncoderException {
        if (job == null) {
            throw new IllegalArgumentException("The Job parameter must not be null");
        }
        try {
            List<File> outputs;
            File videoFile = videoTrack != null ? this.loadTrackIntoWorkspace(job, "source", videoTrack, false) : null;
            EncodingProfile profile = this.getProfile(job, encodingProfile);
            logger.info("Encoding video track {} using profile '{}'", (Object)videoTrack.getIdentifier(), (Object)profile);
            EncoderEngine encoderEngine = this.getEncoderEngine();
            try {
                HashMap<String, File> source = new HashMap<String, File>();
                source.put("video", videoFile);
                outputs = encoderEngine.process(source, profile, null);
            }
            catch (EncoderException e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("video", videoFile != null ? videoTrack.getURI().toString() : "EMPTY");
                params.put("profile", profile.getIdentifier());
                params.put("properties", "EMPTY");
                this.incident().recordFailure(job, 7, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
                throw e;
            }
            finally {
                this.activeEncoder.remove(encoderEngine);
            }
            if (outputs.isEmpty() || !outputs.get(0).exists() || outputs.get(0).length() == 0L) {
                return null;
            }
            List<URI> workspaceURIs = this.putToCollection(job, outputs, "demuxed file");
            List<Track> tracks = this.inspect(job, workspaceURIs);
            tracks.forEach(track -> track.setIdentifier(IdImpl.fromUUID().toString()));
            return tracks;
        }
        catch (Exception e) {
            logger.warn("Demux/MultiOutputEncode operation failed to encode " + String.valueOf(videoTrack), (Throwable)e);
            if (e instanceof EncoderException) {
                throw (EncoderException)((Object)e);
            }
            throw new EncoderException((Throwable)e);
        }
    }

    @Modified
    public void modified(Map<String, Object> config) throws ConfigurationException {
        logger.debug("Modified");
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        this.maxMultipleProfilesJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)JOB_LOAD_MAX_MULTIPLE_PROFILES, (Float)Float.valueOf(0.8f), (ServiceRegistry)this.serviceRegistry);
        this.processSmilJobLoadFactor = LoadUtil.getConfiguredLoadValue(properties, (String)JOB_LOAD_FACTOR_PROCESS_SMIL, (Float)Float.valueOf(0.5f), (ServiceRegistry)this.serviceRegistry);
        this.multiEncodeJobLoadFactor = LoadUtil.getConfiguredLoadValue(properties, (String)JOB_LOAD_FACTOR_MULTI_ENCODE, (Float)Float.valueOf(0.5f), (ServiceRegistry)this.serviceRegistry);
        String multiEncodeFadeStr = StringUtils.trimToNull((String)((String)properties.get(MULTI_ENCODE_FADE_MILLISECONDS)));
        this.multiEncodeTrim = 0;
        if (multiEncodeFadeStr != null) {
            this.multiEncodeFade = Integer.parseInt(multiEncodeFadeStr);
        }
        String multiEncodeTrimStr = StringUtils.trimToNull((String)((String)properties.get(MULTI_ENCODE_TRIM_MILLISECONDS)));
        this.multiEncodeTrim = 0;
        if (multiEncodeTrimStr != null) {
            this.multiEncodeTrim = Integer.parseInt(multiEncodeTrimStr);
        }
        this.transitionDuration = (int)(1000.0f * LoadUtil.getConfiguredLoadValue(properties, (String)PROCESS_SMIL_CLIP_TRANSITION_DURATION, (Float)Float.valueOf(2.0f), (ServiceRegistry)this.serviceRegistry));
    }

    public Job processSmil(Smil smil, String trackparamId, String mediaType, List<String> profileIds) throws EncoderException, MediaPackageException {
        try {
            ArrayList<String> al = new ArrayList<String>();
            al.add(smil.toXML());
            al.add(trackparamId);
            al.add(mediaType);
            for (String string : profileIds) {
                al.add(string);
            }
            float load = this.calculateJobLoadForMultipleProfiles(profileIds, this.processSmilJobLoadFactor);
            try {
                for (SmilMediaParamGroup paramGroup : smil.getHead().getParamGroups()) {
                    for (SmilMediaParam param : paramGroup.getParams()) {
                        if (!"track-id".equals(param.getName()) || trackparamId != null && !trackparamId.equals(paramGroup.getId())) continue;
                        al.set(1, paramGroup.getId());
                        return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.ProcessSmil.toString(), al, Float.valueOf(load));
                    }
                }
            }
            catch (ServiceRegistryException serviceRegistryException) {
                throw new EncoderException("Unable to create a job", (Throwable)serviceRegistryException);
            }
            catch (Exception exception) {
                throw new EncoderException("Unable to create a job - Exception in Parsing Smil", (Throwable)exception);
            }
        }
        catch (Exception e) {
            throw new EncoderException("Unable to create a job - Exception processing XML in ProcessSmil", (Throwable)e);
        }
        throw new EncoderException("Unable to create a job - Cannot find paramGroup");
    }

    private List<EncodingProfile> findSuitableProfiles(List<String> encodingProfiles, String mediaType) {
        ArrayList<EncodingProfile> profiles = new ArrayList<EncodingProfile>();
        for (String profileId1 : encodingProfiles) {
            EncodingProfile profile = this.profileScanner.getProfile(profileId1);
            if ("v".equals(mediaType) && profile.getApplicableMediaType() == EncodingProfile.MediaType.Audio) {
                logger.warn("Profile '{}' supports {} but media is Video Only", (Object)profileId1, (Object)profile.getApplicableMediaType());
            } else if ("a".equals(mediaType) && profile.getApplicableMediaType() == EncodingProfile.MediaType.Visual) {
                logger.warn("Profile '{}' supports {} but media is Audio Only", (Object)profileId1, (Object)profile.getApplicableMediaType());
            }
            profiles.add(profile);
        }
        return profiles;
    }

    private SmilMediaParamGroup getSmilMediaParamGroup(Smil smil, String trackParamGroupId) throws EncoderException {
        try {
            if (trackParamGroupId == null) {
                block2: for (SmilMediaParamGroup paramGroup : smil.getHead().getParamGroups()) {
                    for (SmilMediaParam param : paramGroup.getParams()) {
                        if (!"track-id".equals(param.getName())) continue;
                        trackParamGroupId = paramGroup.getId();
                        continue block2;
                    }
                }
            }
            return (SmilMediaParamGroup)smil.get(trackParamGroupId);
        }
        catch (SmilException ex) {
            throw new EncoderException("Smil does not contain a paramGroup element with Id " + trackParamGroupId, (Throwable)ex);
        }
    }

    protected List<Track> processSmil(Job job, Smil smil, String trackParamGroupId, String mediaType, List<String> encodingProfiles) throws EncoderException, MediaPackageException, URISyntaxException {
        List<EncodingProfile> profiles = this.findSuitableProfiles(encodingProfiles, mediaType);
        if (profiles.size() == 0) {
            throw new EncoderException("ProcessSmil - Media is not supported by the assigned encoding Profiles '" + String.valueOf(encodingProfiles) + "'");
        }
        ArrayList<String> inputfile = new ArrayList<String>();
        HashMap<Object, String> props = new HashMap<Object, String>();
        ArrayList<VideoClip> videoclips = new ArrayList<VideoClip>();
        SmilMediaParamGroup trackParamGroup = this.getSmilMediaParamGroup(smil, trackParamGroupId);
        String sourceTrackId = null;
        MediaPackageElementFlavor sourceTrackFlavor = null;
        String sourceTrackUri = null;
        File sourceFile = null;
        for (SmilMediaParam param : trackParamGroup.getParams()) {
            if ("track-id".equals(param.getName())) {
                sourceTrackId = param.getValue();
                continue;
            }
            if ("track-src".equals(param.getName())) {
                sourceTrackUri = param.getValue();
                continue;
            }
            if (!"track-flavor".equals(param.getName())) continue;
            sourceTrackFlavor = MediaPackageElementFlavor.parseFlavor((String)param.getValue());
        }
        logger.info("ProcessSmil: Start processing track {}", sourceTrackUri);
        sourceFile = this.loadURIIntoWorkspace(job, "source", new URI(sourceTrackUri));
        inputfile.add(sourceFile.getAbsolutePath());
        props.put("in.video.path", sourceFile.getAbsolutePath());
        int srcIndex = inputfile.indexOf(sourceFile.getAbsolutePath());
        try {
            List<File> outputs;
            for (Object element : smil.getBody().getMediaElements()) {
                if (!element.isContainer()) continue;
                SmilMediaContainer smilMediaContainer = (SmilMediaContainer)element;
                if (SmilMediaContainer.ContainerType.PAR == smilMediaContainer.getContainerType()) {
                    for (SmilMediaObject elementChild : smilMediaContainer.getElements()) {
                        if (!elementChild.isContainer()) {
                            SmilMediaElement media = (SmilMediaElement)elementChild;
                            if (!trackParamGroupId.equals(media.getParamGroup())) continue;
                            long begin = media.getClipBeginMS();
                            long end = media.getClipEndMS();
                            URI clipTrackURI = media.getSrc();
                            File clipSourceFile = null;
                            if (clipTrackURI != null) {
                                clipSourceFile = this.loadURIIntoWorkspace(job, "Source", clipTrackURI);
                            }
                            if (sourceFile == null) {
                                sourceFile = clipSourceFile;
                            }
                            int index = -1;
                            if (clipSourceFile != null) {
                                index = inputfile.indexOf(clipSourceFile.getAbsolutePath());
                                if (index < 0) {
                                    inputfile.add(clipSourceFile.getAbsolutePath());
                                    props.put("in.video.path" + index, sourceFile.getAbsolutePath());
                                    index = inputfile.indexOf(clipSourceFile.getAbsolutePath());
                                }
                            } else {
                                index = srcIndex;
                            }
                            logger.debug("Adding edit clip index " + index + " begin " + begin + " end " + end + " to " + sourceTrackId);
                            videoclips.add(new VideoClip(index, begin, end));
                            continue;
                        }
                        throw new EncoderException("Smil container '" + ((SmilMediaContainer)elementChild).getContainerType().toString() + "'is not supported yet");
                    }
                    continue;
                }
                throw new EncoderException("Smil container '" + smilMediaContainer.getContainerType().toString() + "'is not supported yet");
            }
            ArrayList<Long> edits = new ArrayList<Long>();
            for (VideoClip videoClip : videoclips) {
                edits.add(Long.valueOf(videoClip.getSrc()));
                edits.add(videoClip.getStartMS());
                edits.add(videoClip.getEndMS());
            }
            ArrayList<File> inputs = new ArrayList<File>();
            for (String f : inputfile) {
                inputs.add(new File(f));
            }
            EncoderEngine encoderEngine = this.getEncoderEngine();
            try {
                outputs = encoderEngine.multiTrimConcat(inputs, edits, profiles, this.transitionDuration, !"a".equals(mediaType), !"v".equals(mediaType));
            }
            catch (EncoderException e) {
                HashMap<String, String> params = new HashMap<String, String>();
                ArrayList<String> profileList = new ArrayList<String>();
                for (EncodingProfile p : profiles) {
                    profileList.add(p.getIdentifier().toString());
                }
                params.put("videos", StringUtils.join(inputs, (String)","));
                params.put("profiles", StringUtils.join(profileList, (String)","));
                this.incident().recordFailure(job, 19, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
                throw e;
            }
            finally {
                this.activeEncoder.remove(encoderEngine);
            }
            logger.info("ProcessSmil returns {} media files ", (Object)outputs.size());
            boolean isHLS = outputs.parallelStream().anyMatch(AdaptivePlaylist.isHLSFilePred);
            if (isHLS) {
                this.hlsFixReference(job.getId(), outputs);
            }
            logger.info("ProcessSmil/MultiTrimConcat returns {} media files {}", (Object)outputs.size(), outputs);
            List<URI> workspaceURIs = this.putToCollection(job, outputs, "processSmil files");
            List<Track> tracks = this.inspect(job, workspaceURIs);
            if (isHLS) {
                tracks.forEach(eachtrack -> AdaptivePlaylist.setLogicalName((Track)eachtrack));
            }
            tracks.forEach(track -> track.setIdentifier(IdImpl.fromUUID().toString()));
            return tracks;
        }
        catch (Exception e) {
            throw new EncoderException("ProcessSmil operation failed to run ", (Throwable)e);
        }
    }

    public Job multiEncode(Track sourceTrack, List<String> profileIds) throws EncoderException, MediaPackageException {
        try {
            float load = this.calculateJobLoadForMultipleProfiles(profileIds, this.multiEncodeJobLoadFactor);
            ArrayList<String> args = new ArrayList<String>();
            args.add(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack));
            args.addAll(profileIds);
            return this.serviceRegistry.createJob("org.opencastproject.composer", Operation.MultiEncode.toString(), args, Float.valueOf(load));
        }
        catch (ServiceRegistryException e) {
            throw new EncoderException("Unable to create a job", (Throwable)e);
        }
    }

    protected List<Track> multiEncode(Job job, Track track, List<String> profileIds) throws EncoderException, IllegalArgumentException {
        if (job == null) {
            throw new IllegalArgumentException("The Job parameter must not be null");
        }
        if (track == null) {
            throw new IllegalArgumentException("Source track cannot be null");
        }
        if (profileIds == null || profileIds.isEmpty()) {
            throw new IllegalArgumentException("Cannot encode without encoding profiles");
        }
        List<File> outputs = null;
        try {
            File videoFile = this.loadTrackIntoWorkspace(job, "source", track, false);
            ArrayList<EncodingProfile> profiles = new ArrayList<EncodingProfile>();
            for (String profileId : profileIds) {
                EncodingProfile profile = this.getProfile(job, profileId);
                profiles.add(profile);
            }
            long nominalTrim = this.multiEncodeTrim;
            ArrayList<Long> edits = null;
            if (nominalTrim > 0L) {
                edits = new ArrayList<Long>();
                edits.add(0L);
                edits.add(nominalTrim);
                edits.add(track.getDuration() - nominalTrim);
            }
            logger.info("Encoding source track {} using profiles '{}'", (Object)track.getIdentifier(), profileIds);
            EncoderEngine encoderEngine = this.getEncoderEngine();
            try {
                outputs = encoderEngine.multiTrimConcat(Arrays.asList(videoFile), null, profiles, this.multiEncodeFade, track.hasVideo(), track.hasAudio());
            }
            catch (EncoderException e) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("videos", videoFile.getName());
                params.put("profiles", StringUtils.join(profileIds, (String)","));
                this.incident().recordFailure(job, 20, (Throwable)e, params, ComposerServiceImpl.detailsFor(e, encoderEngine));
                throw e;
            }
            finally {
                this.activeEncoder.remove(encoderEngine);
            }
            logger.info("MultiEncode returns {} media files {} ", (Object)outputs.size(), outputs);
            List<File> saveFiles = outputs;
            boolean isHLS = outputs.parallelStream().anyMatch(AdaptivePlaylist.isHLSFilePred);
            if (isHLS) {
                this.hlsFixReference(job.getId(), outputs);
            }
            List<URI> workspaceURIs = this.putToCollection(job, saveFiles, "multiencode files");
            List<Track> tracks = this.inspect(job, workspaceURIs);
            if (isHLS) {
                tracks.forEach(eachtrack -> AdaptivePlaylist.setLogicalName((Track)eachtrack));
            }
            tracks.forEach(eachtrack -> eachtrack.setIdentifier(IdImpl.fromUUID().toString()));
            return tracks;
        }
        catch (Exception e) {
            throw new EncoderException("MultiEncode operation failed to run ", (Throwable)e);
        }
    }

    private float calculateJobLoadForMultipleProfiles(List<String> profileIds, float adjustmentFactor) throws EncoderException {
        float load = 0.0f;
        for (String profileId : profileIds) {
            EncodingProfile profile = this.profileScanner.getProfile(profileId);
            if (profile == null) {
                throw new EncoderException("Encoding profile not found: " + profileId);
            }
            load += profile.getJobLoad();
        }
        if ((load *= adjustmentFactor) > this.maxMultipleProfilesJobLoad) {
            load = this.maxMultipleProfilesJobLoad;
        }
        return load;
    }

    static enum Operation {
        Encode,
        Image,
        ImageConversion,
        Mux,
        Trim,
        Composite,
        Concat,
        ImageToVideo,
        ParallelEncode,
        Demux,
        ProcessSmil,
        MultiEncode;

    }
}

