/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.composer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.api.EncodingProfileImpl;
import org.opencastproject.util.ConfigurationException;
import org.opencastproject.util.ReadinessIndicator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Encoding Profile Scanner"}, immediate=true, service={EncodingProfileScanner.class, ArtifactInstaller.class})
public class EncodingProfileScanner
implements ArtifactInstaller {
    private static final String PROP_PREFIX = "profile.";
    private static final String PROP_NAME = ".name";
    private static final String PROP_APPLICABLE = ".input";
    private static final String PROP_OUTPUT = ".output";
    private static final String PROP_SUFFIX = ".suffix";
    private static final String PROP_JOBLOAD = ".jobload";
    private BundleContext bundleCtx = null;
    private int sumInstalledFiles = 0;
    private int sumUnparsableFiles = 0;
    private Map<String, EncodingProfile> profiles = new HashMap<String, EncodingProfile>();
    private static final Logger logger = LoggerFactory.getLogger(EncodingProfileScanner.class);

    public Map<String, EncodingProfile> getProfiles() {
        return this.profiles;
    }

    @Activate
    void activate(BundleContext ctx) {
        this.bundleCtx = ctx;
    }

    public EncodingProfile getProfile(String id) {
        return this.profiles.get(id);
    }

    Map<String, EncodingProfile> loadFromProperties(File artifact) throws IOException {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(artifact), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        ArrayList<String> profileNames = new ArrayList<String>();
        for (Object fullKey : properties.keySet()) {
            String key = fullKey.toString();
            if (!key.startsWith(PROP_PREFIX) || !key.endsWith(PROP_NAME)) continue;
            int separatorLocation = fullKey.toString().lastIndexOf(46);
            if (!profileNames.contains(key = key.substring(PROP_PREFIX.length(), separatorLocation))) {
                profileNames.add(key);
                continue;
            }
            throw new ConfigurationException("Found duplicate definition for encoding profile '" + key + "'");
        }
        HashMap<String, EncodingProfile> profiles = new HashMap<String, EncodingProfile>();
        for (String profileId : profileNames) {
            logger.debug("Enabling media format " + profileId);
            EncodingProfile profile = this.loadProfile(profileId, properties, artifact);
            profiles.put(profileId, profile);
        }
        return profiles;
    }

    private EncodingProfile loadProfile(String profile, Properties properties, File artifact) throws ConfigurationException {
        ArrayList<String> defaultProperties = new ArrayList<String>(10);
        String name = EncodingProfileScanner.getDefaultProperty(profile, PROP_NAME, properties, defaultProperties);
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new ConfigurationException("Distribution profile '" + profile + "' is missing a name (.name).");
        }
        EncodingProfileImpl df = new EncodingProfileImpl(profile, name, (Object)artifact);
        String type = EncodingProfileScanner.getDefaultProperty(profile, PROP_OUTPUT, properties, defaultProperties);
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new ConfigurationException("Output type (.output) of profile '" + profile + "' is missing");
        }
        try {
            df.setOutputType(EncodingProfile.MediaType.parseString((String)StringUtils.trimToEmpty((String)type)));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Output type (.output) '" + type + "' of profile '" + profile + "' is unknown");
        }
        List<String> tags = EncodingProfileScanner.getTags(profile, properties, defaultProperties);
        if (tags.size() > 0) {
            for (String tag : tags) {
                String prop = ".suffix." + tag;
                String suffixObj = EncodingProfileScanner.getDefaultProperty(profile, prop, properties, defaultProperties);
                df.setSuffix(tag, StringUtils.trim((String)suffixObj));
            }
        } else {
            String suffixObj = EncodingProfileScanner.getDefaultProperty(profile, PROP_SUFFIX, properties, defaultProperties);
            if (StringUtils.isBlank((CharSequence)suffixObj)) {
                throw new ConfigurationException("Suffix (.suffix) of profile '" + profile + "' is missing");
            }
            df.setSuffix(StringUtils.trim((String)suffixObj));
        }
        String applicableObj = EncodingProfileScanner.getDefaultProperty(profile, PROP_APPLICABLE, properties, defaultProperties);
        if (StringUtils.isBlank((CharSequence)applicableObj)) {
            throw new ConfigurationException("Input type (.input) of profile '" + profile + "' is missing");
        }
        df.setApplicableType(EncodingProfile.MediaType.parseString((String)StringUtils.trimToEmpty((String)applicableObj)));
        String jobLoad = EncodingProfileScanner.getDefaultProperty(profile, PROP_JOBLOAD, properties, defaultProperties);
        if (!StringUtils.isBlank((CharSequence)jobLoad)) {
            df.setJobLoad(Float.valueOf(jobLoad));
            logger.debug("Setting job load for profile {} to {}", (Object)profile, (Object)jobLoad);
        }
        String extensionKey = PROP_PREFIX + profile + ".";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(extensionKey) || defaultProperties.contains(key)) continue;
            String k = key.substring(extensionKey.length());
            String v = StringUtils.trimToEmpty((String)entry.getValue().toString());
            df.addExtension(k, v);
        }
        return df;
    }

    private static String getDefaultProperty(String profile, String keySuffix, Properties properties, List<String> list) {
        String key = PROP_PREFIX + profile + keySuffix;
        list.add(key);
        return StringUtils.trimToNull((String)properties.getProperty(key));
    }

    private static List<String> getTags(String profile, Properties properties, List<String> list) {
        Set<Object> keys = properties.keySet();
        String key = PROP_PREFIX + profile + PROP_SUFFIX;
        ArrayList<String> tags = new ArrayList<String>();
        for (Object o : keys) {
            String k = o.toString();
            if (!k.startsWith(key) || k.substring(key.length()).length() <= 0) continue;
            list.add(k);
            tags.add(k.substring(key.length() + 1));
        }
        return tags;
    }

    public boolean canHandle(File artifact) {
        return "encoding".equals(artifact.getParentFile().getName()) && artifact.getName().endsWith(".properties");
    }

    public void install(File artifact) throws Exception {
        logger.info("Registering encoding profiles from {}", (Object)artifact);
        try {
            Map<String, EncodingProfile> profileMap = this.loadFromProperties(artifact);
            for (Map.Entry<String, EncodingProfile> entry : profileMap.entrySet()) {
                EncodingProfile profile = entry.getValue();
                logger.info("Installed profile {} (load {})", (Object)profile.getIdentifier(), (Object)Float.valueOf(profile.getJobLoad()));
                this.profiles.put(entry.getKey(), profile);
            }
            ++this.sumInstalledFiles;
        }
        catch (Exception e) {
            logger.error("Encoding profiles could not be read from {}: {}", (Object)artifact, (Object)e.getMessage());
            ++this.sumUnparsableFiles;
        }
        String[] filesInDirectory = artifact.getParentFile().list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String name) {
                return name.endsWith(".properties");
            }
        });
        if (filesInDirectory.length == this.sumInstalledFiles + this.sumUnparsableFiles) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("artifact", "encodingprofile");
            logger.debug("Indicating readiness of encoding profiles");
            this.bundleCtx.registerService(ReadinessIndicator.class.getName(), (Object)new ReadinessIndicator(), properties);
            if (filesInDirectory.length == this.sumInstalledFiles) {
                logger.info("All {} encoding profiles installed", (Object)filesInDirectory.length);
            } else {
                logger.warn("{} encoding profile(s) installed, {} encoding profile(s) could not be installed", (Object)this.sumInstalledFiles, (Object)this.sumUnparsableFiles);
            }
        } else {
            logger.debug("{} of {} encoding profiles installed", (Object)this.sumInstalledFiles, (Object)filesInDirectory.length);
        }
    }

    public void uninstall(File artifact) throws Exception {
        Iterator<EncodingProfile> iter = this.profiles.values().iterator();
        while (iter.hasNext()) {
            EncodingProfile profile = iter.next();
            if (!artifact.equals(profile.getSource())) continue;
            logger.info("Uninstalling profile {}", (Object)profile.getIdentifier());
            iter.remove();
        }
    }

    public void update(File artifact) throws Exception {
        this.uninstall(artifact);
        this.install(artifact);
    }
}

