/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.impl.jpa;

import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.util.EqualsUtil;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="oc_role", uniqueConstraints={@UniqueConstraint(columnNames={"name", "organization"})}, indexes={@Index(name="IX_oc_role_pk", columnList="name, organization")})
@NamedQueries(value={@NamedQuery(name="Role.findByQuery", query="select r from JpaRole r where r.organization.id=:org and UPPER(r.name) like :query or UPPER(r.description) like :query"), @NamedQuery(name="Role.findByName", query="Select r FROM JpaRole r where r.name = :name and r.organization.id = :org"), @NamedQuery(name="Role.findAll", query="Select r FROM JpaRole r where r.organization.id = :org")})
public final class JpaRole
implements Role {
    @Id
    @Column(name="id")
    @GeneratedValue
    private Long id;
    @Column(name="name", length=128)
    private String name;
    @OneToOne
    @JoinColumn(name="organization")
    private JpaOrganization organization;
    @Column(name="description", nullable=true)
    private String description;
    @Transient
    private Role.Type type = Role.Type.INTERNAL;

    public JpaRole() {
    }

    public JpaRole(String name, JpaOrganization organization) {
        this.name = name;
        this.organization = organization;
    }

    public JpaRole(String name, JpaOrganization organization, String description) {
        this(name, organization);
        this.description = description;
    }

    public JpaRole(String name, JpaOrganization organization, String description, Role.Type type) {
        this(name, organization, description);
        this.type = type;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrganizationId() {
        return this.organization.getId();
    }

    public JpaOrganization getJpaOrganization() {
        return this.organization;
    }

    public Role.Type getType() {
        return this.type;
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.name, this.getOrganizationId()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        return this.name.equals(other.getName()) && Objects.equals(this.getOrganizationId(), other.getOrganizationId());
    }

    public String toString() {
        return this.name + ":" + this.getOrganizationId();
    }
}

