/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.job.jpa;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobImpl;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.User;
import org.opencastproject.serviceregistry.impl.jpa.ServiceRegistrationJpaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="Job")
@Access(value=AccessType.FIELD)
@Table(name="oc_job", indexes={@Index(name="IX_oc_job_parent", columnList="parent"), @Index(name="IX_oc_job_root", columnList="root"), @Index(name="IX_oc_job_creator_service", columnList="creator_service"), @Index(name="IX_oc_job_processor_service", columnList="processor_service"), @Index(name="IX_oc_job_status", columnList="status"), @Index(name="IX_oc_job_date_created", columnList="date_created"), @Index(name="IX_oc_job_date_completed", columnList="date_completed"), @Index(name="IX_oc_job_dispatchable", columnList="dispatchable"), @Index(name="IX_oc_job_operation", columnList="operation")})
@NamedQueries(value={@NamedQuery(name="Job", query="SELECT j FROM Job j where j.status = :status and j.creatorServiceRegistration.serviceType = :serviceType order by j.dateCreated"), @NamedQuery(name="Job.type", query="SELECT j FROM Job j where j.creatorServiceRegistration.serviceType = :serviceType order by j.dateCreated"), @NamedQuery(name="Job.status", query="SELECT j FROM Job j where j.status = :status order by j.dateCreated"), @NamedQuery(name="Job.statuses", query="SELECT j FROM Job j where j.status in :statuses order by j.dateCreated"), @NamedQuery(name="Job.countByOrganizationAndHost", query="SELECT j.organization, j.processorServiceRegistration.hostRegistration.baseUrl, count(j) FROM Job j WHERE j.status in :statuses GROUP BY j.organization, j.processorServiceRegistration.hostRegistration.baseUrl"), @NamedQuery(name="Job.countTypeByOrganization", query="SELECT j.organization, count(j) FROM Job j WHERE j.operation = :operation and j.status in :statuses GROUP BY j.organization"), @NamedQuery(name="Job.all", query="SELECT j FROM Job j order by j.dateCreated"), @NamedQuery(name="Job.dispatchable.status", query="SELECT j FROM Job j where j.dispatchable = true and j.status in :statuses order by j.dateCreated"), @NamedQuery(name="Job.dispatchable.status.idfilter", query="SELECT j.id FROM Job j WHERE j.dispatchable = true AND j.status IN :statuses AND j.id IN :jobids ORDER BY j.dateCreated"), @NamedQuery(name="Job.undispatchable.status", query="SELECT j FROM Job j where j.dispatchable = false and j.status in :statuses order by j.dateCreated"), @NamedQuery(name="Job.payload", query="SELECT j.payload FROM Job j where j.operation = :operation order by j.dateCreated"), @NamedQuery(name="Job.processinghost.status", query="SELECT j FROM Job j where j.status in :statuses and j.processorServiceRegistration is not null and j.processorServiceRegistration.serviceType = :serviceType and j.processorServiceRegistration.hostRegistration.baseUrl = :host order by j.dateCreated"), @NamedQuery(name="Job.root.children", query="SELECT j FROM Job j WHERE j.rootJob.id = :id ORDER BY j.dateCreated"), @NamedQuery(name="Job.children", query="SELECT j FROM Job j WHERE j.parentJob.id = :id ORDER BY j.dateCreated"), @NamedQuery(name="Job.withoutParent", query="SELECT j FROM Job j WHERE j.parentJob IS NULL"), @NamedQuery(name="Job.avgOperation", query="SELECT j.operation, AVG(j.runTime), AVG(j.queueTime) FROM Job j GROUP BY j.operation"), @NamedQuery(name="Job.count", query="SELECT COUNT(j) FROM Job j where j.status = :status and j.creatorServiceRegistration.serviceType = :serviceType"), @NamedQuery(name="Job.count.all", query="SELECT COUNT(j) FROM Job j"), @NamedQuery(name="Job.count.nullType", query="SELECT COUNT(j) FROM Job j where j.status = :status"), @NamedQuery(name="Job.count.nullStatus", query="SELECT COUNT(j) FROM Job j where j.creatorServiceRegistration.serviceType = :serviceType"), @NamedQuery(name="Job.countByHost", query="SELECT COUNT(j) FROM Job j where j.status = :status and j.processorServiceRegistration is not null and j.processorServiceRegistration.serviceType = :serviceType and j.creatorServiceRegistration.hostRegistration.baseUrl = :host"), @NamedQuery(name="Job.countByHost.nullType", query="SELECT COUNT(j) FROM Job j where j.status = :status and j.processorServiceRegistration is not null and j.creatorServiceRegistration.hostRegistration.baseUrl = :host"), @NamedQuery(name="Job.countByOperation", query="SELECT COUNT(j) FROM Job j where j.status = :status and j.operation = :operation and j.creatorServiceRegistration.serviceType = :serviceType"), @NamedQuery(name="Job.countByOperationOnly", query="SELECT COUNT(j) FROM Job j where j.operation = :operation"), @NamedQuery(name="Job.fullMonty", query="SELECT COUNT(j) FROM Job j where j.status = :status and j.operation = :operation and j.processorServiceRegistration is not null and j.processorServiceRegistration.serviceType = :serviceType and j.creatorServiceRegistration.hostRegistration.baseUrl = :host"), @NamedQuery(name="Job.count.history.failed", query="SELECT COUNT(j) FROM Job j WHERE j.status = 4 AND j.processorServiceRegistration IS NOT NULL AND j.processorServiceRegistration.serviceType = :serviceType AND j.processorServiceRegistration.hostRegistration.baseUrl = :host AND j.dateCompleted >= j.processorServiceRegistration.stateChanged"), @NamedQuery(name="Job.countPerHostService", query="SELECT h.baseUrl, s.serviceType, j.status, count(j) FROM Job j, ServiceRegistration s, HostRegistration h WHERE ((j.processorServiceRegistration IS NOT NULL AND j.processorServiceRegistration = s) OR (j.creatorServiceRegistration IS NOT NULL AND j.creatorServiceRegistration = s)) AND s.hostRegistration = h GROUP BY h.baseUrl, s.serviceType, j.status")})
public class JpaJob {
    private static final Logger logger = LoggerFactory.getLogger(JpaJob.class);
    @Id
    @GeneratedValue
    @Column(name="id")
    private long id;
    @Lob
    @Column(name="creator", nullable=false, length=65535)
    private String creator;
    @Column(name="organization", nullable=false, length=128)
    private String organization;
    @Version
    @Column(name="instance_version")
    private long version;
    @Column(name="status")
    private int status;
    @Column(name="operation", length=128)
    private String operation;
    @Lob
    @Column(name="argument", length=0x7FFFFFFF)
    @OrderColumn(name="argument_index")
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="oc_job_argument", joinColumns={@JoinColumn(name="id", referencedColumnName="id", nullable=false)}, indexes={@Index(name="IX_oc_job_argument_id", columnList="id")})
    private List<String> arguments;
    @Column(name="date_completed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCompleted;
    @Column(name="date_created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreated;
    @Column(name="date_started")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateStarted;
    @Column(name="queue_time")
    private Long queueTime = 0L;
    @Column(name="run_time")
    private Long runTime = 0L;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="payload", length=0xFFFFFF)
    private String payload;
    @Column(name="dispatchable")
    private boolean dispatchable = true;
    @Column(name="job_load", nullable=false)
    private Float jobLoad = Float.valueOf(1.0f);
    @ManyToOne
    @JoinColumn(name="creator_service")
    private ServiceRegistrationJpaImpl creatorServiceRegistration;
    @ManyToOne
    @JoinColumn(name="processor_service")
    private ServiceRegistrationJpaImpl processorServiceRegistration;
    @Column(name="processor_service", updatable=false, insertable=false)
    private Long processorServiceRegistrationFK;
    @JoinColumn(name="parent", referencedColumnName="id", nullable=true)
    private JpaJob parentJob = null;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=JpaJob.class, optional=true)
    @JoinColumn(name="root", referencedColumnName="id", nullable=true)
    private JpaJob rootJob = null;
    @OneToMany(mappedBy="parentJob", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE})
    private List<JpaJob> childJobs;
    @Transient
    private String createdHost;
    @Transient
    private String processingHost;
    @Transient
    private Long parentJobId = null;
    @Transient
    private Long rootJobId = null;
    @Transient
    private Job.FailureReason failureReason = Job.FailureReason.NONE;
    @Transient
    private String jobType;
    @Transient
    private URI uri;

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public JpaJob() {
    }

    public JpaJob(User currentUser, Organization organization, ServiceRegistrationJpaImpl creatingService, String operation, List<String> arguments, String payload, boolean dispatchable, float load) {
        this.creator = currentUser.getUsername();
        this.organization = organization.getId();
        this.creatorServiceRegistration = creatingService;
        this.jobType = creatingService.getServiceType();
        this.operation = operation;
        this.arguments = arguments;
        this.payload = payload;
        this.dispatchable = dispatchable;
        this.jobLoad = Float.valueOf(load);
        this.status = Job.Status.INSTANTIATED.ordinal();
    }

    public static JpaJob from(Job job) {
        JpaJob newJob = new JpaJob();
        newJob.id = job.getId();
        newJob.dateCompleted = job.getDateCompleted();
        newJob.dateCreated = job.getDateCreated();
        newJob.dateStarted = job.getDateStarted();
        newJob.queueTime = job.getQueueTime();
        newJob.runTime = job.getRunTime();
        newJob.version = job.getVersion();
        newJob.payload = job.getPayload();
        newJob.jobType = job.getJobType();
        newJob.operation = job.getOperation();
        newJob.arguments = job.getArguments();
        newJob.status = job.getStatus().ordinal();
        newJob.parentJobId = job.getParentJobId();
        newJob.rootJobId = job.getRootJobId();
        newJob.dispatchable = job.isDispatchable();
        newJob.uri = job.getUri();
        newJob.creator = job.getCreator();
        newJob.organization = job.getOrganization();
        newJob.jobLoad = job.getJobLoad();
        return newJob;
    }

    public Job toJob() {
        return new JobImpl(this.id, this.creator, this.organization, this.version, this.jobType, this.operation, this.arguments, Job.Status.values()[this.status], this.createdHost, this.processingHost, this.dateCreated, this.dateStarted, this.dateCompleted, this.queueTime, this.runTime, this.payload, this.parentJobId, this.rootJobId, this.dispatchable, this.uri, this.jobLoad);
    }

    @PostLoad
    public void postLoad() {
        if (this.creatorServiceRegistration == null) {
            logger.warn("creator service registration for job '{}' is null", (Object)this.id);
        } else {
            this.createdHost = this.creatorServiceRegistration.getHost();
            this.jobType = this.creatorServiceRegistration.getServiceType();
        }
        if (this.processorServiceRegistration == null) {
            logger.debug("processor service registration for job '{}' is null", (Object)this.id);
        } else {
            this.processingHost = this.processorServiceRegistration.getHost();
            this.jobType = this.processorServiceRegistration.getServiceType();
        }
        if (this.rootJob != null) {
            this.rootJobId = this.rootJob.id;
        }
        if (this.parentJob != null) {
            this.parentJobId = this.parentJob.id;
        }
    }

    public void setProcessorServiceRegistration(ServiceRegistrationJpaImpl processorServiceRegistration) {
        this.processorServiceRegistration = processorServiceRegistration;
        this.processingHost = processorServiceRegistration == null ? null : processorServiceRegistration.getHost();
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setStatus(Job.Status status) {
        this.status = status.ordinal();
    }

    public void setDispatchable(boolean dispatchable) {
        this.dispatchable = dispatchable;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    public void setQueueTime(long queueTime) {
        this.queueTime = queueTime;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public void setParentJob(JpaJob parentJob) {
        this.parentJob = parentJob;
        this.parentJobId = parentJob.id;
    }

    public void setRootJob(JpaJob rootJob) {
        this.rootJob = rootJob;
        this.rootJobId = rootJob.id;
    }

    public void setStatus(Job.Status status, Job.FailureReason failureReason) {
        this.status = status.ordinal();
        this.failureReason = failureReason;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public long getId() {
        return this.id;
    }

    public ServiceRegistrationJpaImpl getProcessorServiceRegistration() {
        return this.processorServiceRegistration;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getOperation() {
        return this.operation;
    }

    public Float getJobLoad() {
        return this.jobLoad;
    }

    public Job.Status getStatus() {
        return Job.Status.values()[this.status];
    }

    public boolean isDispatchable() {
        return this.dispatchable;
    }

    public JpaJob getRootJob() {
        return this.rootJob;
    }

    public JpaJob getParentJob() {
        return this.parentJob;
    }

    public List<JpaJob> getChildJobs() {
        return this.childJobs;
    }

    public String getChildJobsString() {
        StringBuilder sb = new StringBuilder();
        for (JpaJob job : this.getChildJobs()) {
            sb.append(job.getId());
            sb.append(" ");
        }
        return sb.toString();
    }

    public Job.FailureReason getFailureReason() {
        return this.failureReason;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String toString() {
        return String.format("Job {id:%d, operation:%s, status:%s}", this.id, this.operation, this.getStatus().toString());
    }
}

