/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.impl.jpa;

import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.User;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.util.EqualsUtil;

@Entity
@Access(value=AccessType.FIELD)
@Table(name="oc_user_ref", uniqueConstraints={@UniqueConstraint(name="UNQ_oc_user_ref", columnNames={"username", "organization"})})
@NamedQueries(value={@NamedQuery(name="UserReference.findByQuery", query="select u from JpaUserReference u where UPPER(u.username) like :query and u.organization.id = :org"), @NamedQuery(name="UserReference.findByUsername", query="select u from JpaUserReference u where u.username=:u and u.organization.id = :org"), @NamedQuery(name="UserReference.findAll", query="select u from JpaUserReference u where u.organization.id = :org"), @NamedQuery(name="UserReference.findAllByUserNames", query="select u from JpaUserReference u where u.organization.id = :org and u.username in :names"), @NamedQuery(name="UserReference.countAll", query="select COUNT(u) from JpaUserReference u where u.organization.id = :org")})
public class JpaUserReference {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="username", length=128)
    protected String username;
    @Column(name="name")
    protected String name;
    @Column(name="email")
    protected String email;
    @Column(name="login_mechanism")
    protected String loginMechanism;
    @Column(name="last_login")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastLogin;
    @OneToOne
    @JoinColumn(name="organization")
    protected JpaOrganization organization;
    @ManyToMany(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY)
    @JoinTable(name="oc_user_ref_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    protected Set<JpaRole> roles;

    public User toUser(String providerName) {
        HashSet<JaxbRole> roleSet = new HashSet<JaxbRole>();
        for (JpaRole role : this.roles) {
            roleSet.add(JaxbRole.fromRole((Role)role));
        }
        return new JaxbUser(this.username, null, this.name, this.email, providerName, JaxbOrganization.fromOrganization((Organization)this.organization), roleSet);
    }

    public JpaUserReference() {
    }

    public JpaUserReference(String username, String name, String email, String loginMechanism, Date lastLogin, JpaOrganization organization) {
        this.username = username;
        this.name = name;
        this.email = email;
        this.loginMechanism = loginMechanism;
        this.lastLogin = lastLogin;
        this.organization = organization;
        this.roles = new HashSet<JpaRole>();
    }

    public JpaUserReference(String username, String name, String email, String loginMechanism, Date lastLogin, JpaOrganization organization, Set<JpaRole> roles) {
        this(username, name, email, loginMechanism, lastLogin, organization);
        for (Role role : roles) {
            if (Objects.equals(organization.getId(), role.getOrganizationId())) continue;
            throw new IllegalArgumentException("Role " + role + " is not from the same organization!");
        }
        this.roles = roles;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setLoginMechanism(String loginMechanism) {
        this.loginMechanism = loginMechanism;
    }

    public String getLoginMechanism() {
        return this.loginMechanism;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setRoles(Set<JpaRole> roles) {
        this.roles = roles;
    }

    public Set<Role> getRoles() {
        return new HashSet<Role>(this.roles);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JpaUserReference)) {
            return false;
        }
        JpaUserReference other = (JpaUserReference)obj;
        return this.username.equals(other.getUsername()) && this.organization.equals(other.getOrganization());
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.username, this.organization});
    }

    public String toString() {
        return this.username + ":" + this.organization;
    }
}

