/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.remote;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.api.CaptionService;
import org.opencastproject.caption.api.UnsupportedCaptionFormatException;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.XmlSafeParser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(immediate=true, service={CaptionService.class}, property={"service.description=Caption Remote Service Proxy"})
public class CaptionServiceRemoteImpl
extends RemoteBase
implements CaptionService {
    private static final Logger logger = LoggerFactory.getLogger(CaptionServiceRemoteImpl.class);

    public CaptionServiceRemoteImpl() {
        super("org.opencastproject.caption");
    }

    public Job convert(MediaPackageElement input, String inputFormat, String outputFormat) throws UnsupportedCaptionFormatException, CaptionConverterException, MediaPackageException {
        return this.convert(input, inputFormat, outputFormat, null);
    }

    public Job convert(MediaPackageElement input, String inputFormat, String outputFormat, String language) throws UnsupportedCaptionFormatException, CaptionConverterException, MediaPackageException {
        HttpPost post = new HttpPost("/convert");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("captions", MediaPackageElementParser.getAsXml((MediaPackageElement)input)));
            params.add(new BasicNameValuePair("input", inputFormat));
            params.add(new BasicNameValuePair("output", outputFormat));
            if (StringUtils.isNotBlank((CharSequence)language)) {
                params.add(new BasicNameValuePair("language", language));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new CaptionConverterException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                Job r = JobParser.parseJob((String)content);
                logger.info("Converting job {} started on a remote caption service", (Object)r.getId());
                Job job = r;
                return job;
            }
        }
        catch (Exception e) {
            throw new CaptionConverterException("Unable to convert catalog " + String.valueOf(input) + " using a remote caption service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new CaptionConverterException("Unable to convert catalog " + String.valueOf(input) + " using a remote caption service");
    }

    public String[] getLanguageList(MediaPackageElement input, String format) throws UnsupportedCaptionFormatException, CaptionConverterException {
        HttpPost post = new HttpPost("/languages");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("captions", MediaPackageElementParser.getAsXml((MediaPackageElement)input)));
            params.add(new BasicNameValuePair("input", format));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new CaptionConverterException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                ArrayList<String> langauges = new ArrayList<String>();
                Document doc = XmlSafeParser.newDocumentBuilderFactory().newDocumentBuilder().parse(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
                NodeList languages = doc.getElementsByTagName("languages");
                for (int i = 0; i < languages.getLength(); ++i) {
                    Node item = languages.item(i);
                    langauges.add(item.getTextContent());
                }
                logger.info("Catalog languages received from remote caption service");
                String[] stringArray = langauges.toArray(new String[langauges.size()]);
                return stringArray;
            }
        }
        catch (Exception e) {
            throw new CaptionConverterException("Unable to get catalog languages " + String.valueOf(input) + " using a remote caption service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new CaptionConverterException("Unable to get catalog languages" + String.valueOf(input) + " using a remote caption service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

