/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.jboss.security.xacml.core.model.policy.ActionMatchType;
import org.jboss.security.xacml.core.model.policy.ActionType;
import org.jboss.security.xacml.core.model.policy.ActionsType;
import org.jboss.security.xacml.core.model.policy.ApplyType;
import org.jboss.security.xacml.core.model.policy.AttributeDesignatorType;
import org.jboss.security.xacml.core.model.policy.AttributeValueType;
import org.jboss.security.xacml.core.model.policy.ConditionType;
import org.jboss.security.xacml.core.model.policy.EffectType;
import org.jboss.security.xacml.core.model.policy.ObjectFactory;
import org.jboss.security.xacml.core.model.policy.PolicyType;
import org.jboss.security.xacml.core.model.policy.ResourceMatchType;
import org.jboss.security.xacml.core.model.policy.ResourceType;
import org.jboss.security.xacml.core.model.policy.ResourcesType;
import org.jboss.security.xacml.core.model.policy.RuleType;
import org.jboss.security.xacml.core.model.policy.SubjectAttributeDesignatorType;
import org.jboss.security.xacml.core.model.policy.TargetType;
import org.opencastproject.authorization.xacml.XACMLParsingException;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.util.XmlSafeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public final class XACMLUtils {
    public static final String RULE_COMBINING_ALG = "urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:permit-overrides";
    public static final String ACTION_IDENTIFIER = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    public static final String RESOURCE_IDENTIFIER = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    public static final String SUBJECT_IDENTIFIER = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    public static final String SUBJECT_ROLE_IDENTIFIER = "urn:oasis:names:tc:xacml:2.0:subject:role";
    public static final String XACML_STRING_EQUAL = "urn:oasis:names:tc:xacml:1.0:function:string-equal";
    public static final String XACML_STRING_IS_IN = "urn:oasis:names:tc:xacml:1.0:function:string-is-in";
    public static final String W3C_STRING = "http://www.w3.org/2001/XMLSchema#string";
    public static final String ISSUER = "matterhorn";
    protected static JAXBContext jBossXacmlJaxbContext;
    private static final Logger logger;

    private XACMLUtils() {
    }

    public static AccessControlList parseXacml(InputStream xacml) throws XACMLParsingException {
        try {
            AccessControlList acl = new AccessControlList();
            List entries = acl.getEntries();
            PolicyType policy = (PolicyType)((JAXBElement)jBossXacmlJaxbContext.createUnmarshaller().unmarshal((Node)XmlSafeParser.parse((InputStream)xacml))).getValue();
            for (Object object : policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition()) {
                if (!(object instanceof RuleType)) {
                    throw new XACMLParsingException("Object " + String.valueOf(object) + " of policy " + String.valueOf(policy) + " is not of type RuleType");
                }
                RuleType rule = (RuleType)object;
                if (rule.getTarget() == null) {
                    if (rule.getRuleId().equals("DenyRule")) {
                        logger.trace("Skipping global deny rule");
                        continue;
                    }
                    throw new XACMLParsingException("Empty rule " + String.valueOf(rule) + " in policy " + String.valueOf(policy));
                }
                String role = null;
                String actionForAce = null;
                try {
                    ActionType action = rule.getTarget().getActions().getAction().get(0);
                    actionForAce = (String)action.getActionMatch().get(0).getAttributeValue().getContent().get(0);
                    JAXBElement<?> apply = rule.getCondition().getExpression();
                    for (JAXBElement<?> element : ((ApplyType)apply.getValue()).getExpression()) {
                        if (!(element.getValue() instanceof AttributeValueType)) continue;
                        role = (String)((AttributeValueType)element.getValue()).getContent().get(0);
                        break;
                    }
                }
                catch (Exception e) {
                    throw new XACMLParsingException("Rule " + String.valueOf(rule) + " of policy " + String.valueOf(policy) + " could not be parsed", e);
                }
                if (role == null) {
                    throw new XACMLParsingException("Unable to find role in rule " + String.valueOf(rule) + " of policy " + String.valueOf(policy));
                }
                AccessControlEntry ace = new AccessControlEntry(role, actionForAce, rule.getEffect().equals((Object)EffectType.PERMIT));
                entries.add(ace);
            }
            return acl;
        }
        catch (Exception e) {
            if (e instanceof XACMLParsingException) {
                throw (XACMLParsingException)e;
            }
            throw new XACMLParsingException("XACML could not be parsed", e);
        }
    }

    public static String getXacml(MediaPackage mediapackage, AccessControlList accessControlList) throws JAXBException {
        ObjectFactory jbossXacmlObjectFactory = new ObjectFactory();
        PolicyType policy = new PolicyType();
        policy.setPolicyId(mediapackage.getIdentifier().toString());
        policy.setVersion("2.0");
        policy.setRuleCombiningAlgId(RULE_COMBINING_ALG);
        TargetType policyTarget = new TargetType();
        ResourcesType resources = new ResourcesType();
        ResourceType resource = new ResourceType();
        ResourceMatchType resourceMatch = new ResourceMatchType();
        resourceMatch.setMatchId(XACML_STRING_EQUAL);
        AttributeValueType resourceAttributeValue = new AttributeValueType();
        resourceAttributeValue.setDataType(W3C_STRING);
        resourceAttributeValue.getContent().add(mediapackage.getIdentifier().toString());
        AttributeDesignatorType resourceDesignator = new AttributeDesignatorType();
        resourceDesignator.setAttributeId(RESOURCE_IDENTIFIER);
        resourceDesignator.setDataType(W3C_STRING);
        resourceMatch.setResourceAttributeDesignator(resourceDesignator);
        resourceMatch.setAttributeValue(resourceAttributeValue);
        resource.getResourceMatch().add(resourceMatch);
        resources.getResource().add(resource);
        policyTarget.setResources(resources);
        policy.setTarget(policyTarget);
        for (AccessControlEntry ace : accessControlList.getEntries()) {
            boolean allow = ace.isAllow();
            RuleType rule = new RuleType();
            rule.setRuleId(ace.getRole() + "_" + ace.getAction() + (allow ? "_Permit" : "_Deny"));
            if (allow) {
                rule.setEffect(EffectType.PERMIT);
            } else {
                rule.setEffect(EffectType.DENY);
            }
            TargetType target = new TargetType();
            ActionsType actions = new ActionsType();
            ActionType action = new ActionType();
            ActionMatchType actionMatch = new ActionMatchType();
            actionMatch.setMatchId(XACML_STRING_EQUAL);
            AttributeValueType attributeValue = new AttributeValueType();
            attributeValue.setDataType(W3C_STRING);
            attributeValue.getContent().add(ace.getAction());
            AttributeDesignatorType designator = new AttributeDesignatorType();
            designator.setAttributeId(ACTION_IDENTIFIER);
            designator.setDataType(W3C_STRING);
            actionMatch.setActionAttributeDesignator(designator);
            actionMatch.setAttributeValue(attributeValue);
            action.getActionMatch().add(actionMatch);
            actions.getAction().add(action);
            target.setActions(actions);
            rule.setTarget(target);
            ConditionType condition = new ConditionType();
            ApplyType apply = new ApplyType();
            apply.setFunctionId(XACML_STRING_IS_IN);
            AttributeValueType conditionAttributeValue = new AttributeValueType();
            conditionAttributeValue.setDataType(W3C_STRING);
            conditionAttributeValue.getContent().add(ace.getRole());
            SubjectAttributeDesignatorType subjectDesignator = new SubjectAttributeDesignatorType();
            subjectDesignator.setDataType(W3C_STRING);
            subjectDesignator.setAttributeId(SUBJECT_ROLE_IDENTIFIER);
            apply.getExpression().add(jbossXacmlObjectFactory.createAttributeValue(conditionAttributeValue));
            apply.getExpression().add(jbossXacmlObjectFactory.createSubjectAttributeDesignator(subjectDesignator));
            condition.setExpression(jbossXacmlObjectFactory.createApply(apply));
            rule.setCondition(condition);
            policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition().add(rule);
        }
        RuleType deny = new RuleType();
        deny.setEffect(EffectType.DENY);
        deny.setRuleId("DenyRule");
        policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition().add(deny);
        StringWriter writer = new StringWriter();
        jBossXacmlJaxbContext.createMarshaller().marshal(jbossXacmlObjectFactory.createPolicy(policy), (Writer)writer);
        return writer.getBuffer().toString();
    }

    static {
        logger = LoggerFactory.getLogger(XACMLUtils.class);
        try {
            jBossXacmlJaxbContext = JAXBContext.newInstance((String)"org.jboss.security.xacml.core.model.policy", (ClassLoader)PolicyType.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

