/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.authorization.xacml.XACMLUtils;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageSerializer;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides translation between access control entries and xacml documents"}, service={AuthorizationService.class})
public class XACMLAuthorizationService
implements AuthorizationService {
    private static final Logger logger = LoggerFactory.getLogger(XACMLAuthorizationService.class);
    private static final String XACML_FILENAME = "xacml.xml";
    protected Workspace workspace;
    protected SecurityService securityService;
    private MediaPackageSerializer serializer;
    private static final String CONFIG_MERGE_MODE = "merge.mode";
    private static MergeMode mergeMode = MergeMode.OVERRIDE;

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        Dictionary properties = cc.getProperties();
        if (properties == null) {
            mergeMode = MergeMode.OVERRIDE;
            logger.debug("Merge mode set to {}", (Object)mergeMode);
            return;
        }
        String mode = (String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(CONFIG_MERGE_MODE)), (CharSequence)MergeMode.OVERRIDE.toString());
        try {
            mergeMode = MergeMode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Invalid value set for ACL merge mode, defaulting to {}", (Object)MergeMode.OVERRIDE);
            mergeMode = MergeMode.OVERRIDE;
        }
        logger.debug("Merge mode set to {}", (Object)mergeMode);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetMediaPackageSerializer", target="(service.pid=org.opencastproject.mediapackage.ChainingMediaPackageSerializer)")
    public void setMediaPackageSerializer(MediaPackageSerializer serializer) {
        this.serializer = serializer;
    }

    protected void unsetMediaPackageSerializer(MediaPackageSerializer serializer) {
        if (this.serializer == serializer) {
            this.serializer = null;
        }
    }

    public Tuple<AccessControlList, AclScope> getActiveAcl(MediaPackage mp) {
        logger.debug("getActiveACl for media package {}", (Object)mp.getIdentifier());
        return this.getAcl(mp, AclScope.Episode);
    }

    public Tuple<AccessControlList, AclScope> getAcl(MediaPackage mp, AclScope scope) {
        Optional<Object> episode = Optional.empty();
        Optional<Object> series = Optional.empty();
        if (AclScope.Episode.equals((Object)scope) || AclScope.Merged.equals((Object)scope)) {
            episode = this.getAclByFlavor(mp, MediaPackageElements.XACML_POLICY_EPISODE);
        }
        if (Arrays.asList(AclScope.Episode, AclScope.Series, AclScope.Merged).contains(scope)) {
            series = this.getAclByFlavor(mp, MediaPackageElements.XACML_POLICY_SERIES);
        }
        if (episode.isPresent() && series.isPresent()) {
            logger.debug("Found event and series ACL for media package {}", (Object)mp.getIdentifier());
            switch (mergeMode) {
                case ACTIONS: {
                    logger.debug("Merging ACLs based on individual actions");
                    return Tuple.tuple((Object)((AccessControlList)series.get()).mergeActions((AccessControlList)episode.get()), (Object)AclScope.Merged);
                }
                case ROLES: {
                    logger.debug("Merging ACLs based on roles");
                    return Tuple.tuple((Object)((AccessControlList)series.get()).merge((AccessControlList)episode.get()), (Object)AclScope.Merged);
                }
            }
            logger.debug("Episode ACL overrides series ACL");
            return Tuple.tuple((Object)((AccessControlList)episode.get()), (Object)AclScope.Merged);
        }
        if (episode.isPresent()) {
            logger.debug("Found event ACL for media package {}", (Object)mp.getIdentifier());
            return Tuple.tuple((Object)((AccessControlList)episode.get()), (Object)AclScope.Episode);
        }
        if (series.isPresent()) {
            logger.debug("Found series ACL for media package {}", (Object)mp.getIdentifier());
            return Tuple.tuple((Object)((AccessControlList)series.get()), (Object)AclScope.Series);
        }
        logger.debug("Falling back to global default ACL");
        return Tuple.tuple((Object)new AccessControlList(), (Object)AclScope.Global);
    }

    private Optional<AccessControlList> getAclByFlavor(MediaPackage mp, MediaPackageElementFlavor xacmlPolicyFlavor) {
        Optional<AccessControlList> acl = Optional.empty();
        for (Attachment xacml : mp.getAttachments(xacmlPolicyFlavor)) {
            URI uri = xacml.getURI();
            try {
                if (this.serializer != null) {
                    uri = this.serializer.decodeURI(uri);
                }
            }
            catch (URISyntaxException e) {
                logger.warn("URI {} syntax error, skip decoding", (Object)uri);
            }
            acl = this.loadAcl(uri);
        }
        return acl;
    }

    public Tuple<MediaPackage, Attachment> setAcl(MediaPackage mp, AclScope scope, AccessControlList acl) throws MediaPackageException {
        URI uri;
        String xacmlContent;
        try {
            xacmlContent = XACMLUtils.getXacml(mp, acl);
        }
        catch (JAXBException e) {
            throw new MediaPackageException("Unable to generate xacml for media package " + mp.getIdentifier());
        }
        Attachment attachment = (Attachment)this.removeFromMediaPackageAndWorkspace(mp, XACMLAuthorizationService.toFlavor(scope)).getB();
        String elementId = XACMLAuthorizationService.toElementId(scope);
        try (InputStream in = IOUtils.toInputStream((String)xacmlContent, (String)"UTF-8");){
            uri = this.workspace.put(mp.getIdentifier().toString(), elementId, XACML_FILENAME, in);
        }
        catch (IOException e) {
            throw new MediaPackageException("Error storing xacml for media package " + mp.getIdentifier());
        }
        if (attachment == null) {
            attachment = (Attachment)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(uri, Attachment.TYPE, XACMLAuthorizationService.toFlavor(scope));
        }
        attachment.setURI(uri);
        attachment.setIdentifier(elementId);
        attachment.setMimeType(MimeTypes.XML);
        attachment.setChecksum(null);
        mp.add(attachment);
        logger.debug("Saved XACML as {}", (Object)uri);
        return Tuple.tuple((Object)mp, (Object)attachment);
    }

    public MediaPackage removeAcl(MediaPackage mp, AclScope scope) {
        return (MediaPackage)this.removeFromMediaPackageAndWorkspace(mp, XACMLAuthorizationService.toFlavor(scope)).getA();
    }

    private static MediaPackageElementFlavor toFlavor(AclScope scope) {
        switch (scope) {
            case Episode: {
                return MediaPackageElements.XACML_POLICY_EPISODE;
            }
            case Series: {
                return MediaPackageElements.XACML_POLICY_SERIES;
            }
        }
        throw new IllegalArgumentException("No flavors match the given ACL scope");
    }

    private static String toElementId(AclScope scope) {
        switch (scope) {
            case Episode: {
                return "security-policy-episode";
            }
            case Series: {
                return "security-policy-series";
            }
        }
        throw new IllegalArgumentException("No element id matches the given ACL scope");
    }

    private Tuple<MediaPackage, Attachment> removeFromMediaPackageAndWorkspace(MediaPackage mp, MediaPackageElementFlavor flavor) {
        Attachment attachment = null;
        for (Attachment a : mp.getAttachments(flavor)) {
            attachment = (Attachment)a.clone();
            try {
                this.workspace.delete(a.getURI());
            }
            catch (Exception e) {
                logger.warn("Unable to delete XACML file:", (Throwable)e);
            }
            mp.remove(a);
        }
        return Tuple.tuple((Object)mp, attachment);
    }

    private Optional<AccessControlList> loadAcl(URI uri) {
        block10: {
            Optional<AccessControlList> optional;
            block9: {
                logger.debug("Load Acl from {}", (Object)uri);
                InputStream is = this.workspace.read(uri);
                try {
                    AccessControlList acl = XACMLUtils.parseXacml(is);
                    optional = Optional.of(acl);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NotFoundException e) {
                        logger.debug("URI {} not found", (Object)uri);
                        break block10;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to load or parse Acl from URI {}", (Object)uri, (Object)e);
                    }
                }
                is.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public boolean hasPermission(MediaPackage mp, String action) {
        AccessControlList acl = (AccessControlList)this.getActiveAcl(mp).getA();
        return this.hasPermission(acl, action);
    }

    public boolean hasPermission(AccessControlList acl, String action) {
        boolean allowed = false;
        User user = this.securityService.getUser();
        for (AccessControlEntry entry : acl.getEntries()) {
            if (!entry.getAction().equals(action)) continue;
            for (Role role : user.getRoles()) {
                if (!entry.getRole().equals(role.getName())) continue;
                if (!entry.isAllow()) {
                    logger.debug("Access explicitly denied for role({}), action({})", (Object)role.getName(), (Object)action);
                    return false;
                }
                allowed = true;
            }
        }
        logger.debug("XACML file allowed access");
        return allowed;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    static enum MergeMode {
        OVERRIDE,
        ROLES,
        ACTIONS;

    }
}

