/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.endpoint;

import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.authorization.xacml.manager.api.AclService;
import org.opencastproject.authorization.xacml.manager.api.AclServiceException;
import org.opencastproject.authorization.xacml.manager.api.AclServiceFactory;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.endpoint.JsonConv;
import org.opencastproject.authorization.xacml.manager.impl.ManagedAclImpl;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.Jsons;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Monadics;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Functions;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAclServiceRestEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAclServiceRestEndpoint.class);
    private static final Function<String, AccessControlList> parseAcl = new Function<String, AccessControlList>(){

        public AccessControlList apply(String acl) {
            try {
                return AccessControlParser.parseAcl((String)acl);
            }
            catch (Exception e) {
                logger.warn("Unable to parse ACL");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
    };

    protected abstract AclServiceFactory getAclServiceFactory();

    protected abstract SecurityService getSecurityService();

    protected abstract AssetManager getAssetManager();

    protected abstract AuthorizationService getAuthorizationService();

    @GET
    @Path(value="/acl/{aclId}")
    @Produces(value={"application/json"})
    @RestQuery(name="getacl", description="Return the ACL by the given id", returnDescription="Return the ACL by the given id", pathParameters={@RestParameter(name="aclId", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been returned"), @RestResponse(responseCode=404, description="The ACL has not been found"), @RestResponse(responseCode=500, description="Error during returning the ACL")})
    public String getAcl(@PathParam(value="aclId") long aclId) throws NotFoundException {
        Optional<ManagedAcl> managedAcl = this.aclService().getAcl(aclId);
        if (managedAcl.isEmpty()) {
            logger.info("No ACL with id '{}' could be found", (Object)aclId);
            throw new NotFoundException();
        }
        return JsonConv.full(managedAcl.get()).toJson();
    }

    @POST
    @Path(value="/acl/extend")
    @Produces(value={"application/json"})
    @RestQuery(name="extendacl", description="Return the given ACL with a new role and action in JSON format", returnDescription="Return the ACL with the new role and action in JSON format", restParameters={@RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING), @RestParameter(name="action", isRequired=true, description="The action for the ACL", type=RestParameter.Type.STRING), @RestParameter(name="role", isRequired=true, description="The role for the ACL", type=RestParameter.Type.STRING), @RestParameter(name="allow", isRequired=true, description="The allow status for the ACL", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been returned"), @RestResponse(responseCode=400, description="The ACL, action or role was invalid or empty"), @RestResponse(responseCode=500, description="Error during returning the ACL")})
    public String extendAcl(@FormParam(value="acl") String accessControlList, @FormParam(value="action") String action, @FormParam(value="role") String role, @FormParam(value="allow") boolean allow) {
        if (StringUtils.isBlank((CharSequence)accessControlList) || StringUtils.isBlank((CharSequence)action) || StringUtils.isBlank((CharSequence)role)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        AccessControlList acl = AccessControlUtil.extendAcl((AccessControlList)((AccessControlList)parseAcl.apply((Object)accessControlList)), (String)role, (String)action, (boolean)allow);
        return JsonConv.full(acl).toJson();
    }

    @POST
    @Path(value="/acl/reduce")
    @Produces(value={"application/json"})
    @RestQuery(name="reduceacl", description="Return the given ACL without a role and action in JSON format", returnDescription="Return the ACL without the role and action in JSON format", restParameters={@RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING), @RestParameter(name="action", isRequired=true, description="The action for the ACL", type=RestParameter.Type.STRING), @RestParameter(name="role", isRequired=true, description="The role for the ACL", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been returned"), @RestResponse(responseCode=400, description="The ACL, role or action was invalid or empty"), @RestResponse(responseCode=500, description="Error during returning the ACL")})
    public String reduceAcl(@FormParam(value="acl") String accessControlList, @FormParam(value="action") String action, @FormParam(value="role") String role) {
        if (StringUtils.isBlank((CharSequence)accessControlList) || StringUtils.isBlank((CharSequence)action) || StringUtils.isBlank((CharSequence)role)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        AccessControlList acl = AccessControlUtil.reduceAcl((AccessControlList)((AccessControlList)parseAcl.apply((Object)accessControlList)), (String)role, (String)action);
        return JsonConv.full(acl).toJson();
    }

    @GET
    @Path(value="/acl/acls.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getacls", description="Lists the ACL's as JSON", returnDescription="The list of ACL's as JSON", responses={@RestResponse(responseCode=200, description="The list of ACL's has successfully been returned"), @RestResponse(responseCode=500, description="Error during returning the list of ACL's")})
    public String getAcls() {
        return Jsons.arr((Monadics.ListMonadic)Monadics.mlist(this.aclService().getAcls()).map(Functions.co(JsonConv.fullManagedAcl))).toJson();
    }

    @POST
    @Path(value="/acl")
    @Produces(value={"application/json"})
    @RestQuery(name="createacl", description="Create an ACL", returnDescription="Create an ACL", restParameters={@RestParameter(name="name", isRequired=true, description="The ACL name", type=RestParameter.Type.STRING), @RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been added"), @RestResponse(responseCode=409, description="An ACL with the same name already exists"), @RestResponse(responseCode=400, description="Unable to parse the ACL"), @RestResponse(responseCode=500, description="Error during adding the ACL")})
    public String createAcl(@FormParam(value="name") String name, @FormParam(value="acl") String accessControlList) {
        AccessControlList acl = (AccessControlList)parseAcl.apply((Object)accessControlList);
        Optional<ManagedAcl> managedAcl = this.aclService().createAcl(acl, name);
        if (managedAcl.isEmpty()) {
            logger.info("An ACL with the same name '{}' already exists", (Object)name);
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        return JsonConv.full(managedAcl.get()).toJson();
    }

    @PUT
    @Path(value="/acl/{aclId}")
    @Produces(value={"application/json"})
    @RestQuery(name="updateacl", description="Update an ACL", returnDescription="Update an ACL", pathParameters={@RestParameter(name="aclId", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(name="name", isRequired=true, description="The ACL name", type=RestParameter.Type.STRING), @RestParameter(name="acl", isRequired=true, description="The access control list", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been updated"), @RestResponse(responseCode=404, description="The ACL has not been found"), @RestResponse(responseCode=400, description="Unable to parse the ACL"), @RestResponse(responseCode=500, description="Error during updating the ACL")})
    public String updateAcl(@PathParam(value="aclId") long aclId, @FormParam(value="name") String name, @FormParam(value="acl") String accessControlList) throws NotFoundException {
        Organization org = this.getSecurityService().getOrganization();
        AccessControlList acl = (AccessControlList)parseAcl.apply((Object)accessControlList);
        ManagedAclImpl managedAcl = new ManagedAclImpl(aclId, name, org.getId(), acl);
        if (!this.aclService().updateAcl(managedAcl)) {
            logger.info("No ACL with id '{}' could be found under organization '{}'", (Object)aclId, (Object)org.getId());
            throw new NotFoundException();
        }
        return JsonConv.full(managedAcl).toJson();
    }

    @DELETE
    @Path(value="/acl/{aclId}")
    @RestQuery(name="deleteacl", description="Delete an ACL", returnDescription="Delete an ACL", pathParameters={@RestParameter(name="aclId", isRequired=true, description="The ACL identifier", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The ACL has successfully been deleted"), @RestResponse(responseCode=404, description="The ACL has not been found"), @RestResponse(responseCode=409, description="The ACL could not be deleted, there are still references on it"), @RestResponse(responseCode=500, description="Error during deleting the ACL")})
    public Response deleteAcl(@PathParam(value="aclId") long aclId) throws NotFoundException {
        try {
            if (!this.aclService().deleteAcl(aclId)) {
                return RestUtil.R.conflict();
            }
        }
        catch (AclServiceException e) {
            logger.warn("Error deleting manged acl with id '{}'", (Object)aclId, (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return RestUtil.R.noContent();
    }

    @POST
    @Path(value="/apply/episode/{episodeId}")
    @RestQuery(name="applyAclToEpisode", description="Immediate application of an ACL to an episode (Attention: This endpoint is deprecated and  will be removed in future versions!)", returnDescription="Status code", pathParameters={@RestParameter(name="episodeId", isRequired=true, description="The episode ID", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="aclId", isRequired=false, description="The ID of the ACL to apply. If missing the episode ACL will be deleted to fall back to the series ACL", type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The ACL has been successfully applied"), @RestResponse(responseCode=404, description="The ACL or the episode has not been found"), @RestResponse(responseCode=500, description="Internal error")})
    public Response applyAclToEpisode(@PathParam(value="episodeId") String episodeId, @FormParam(value="aclId") Long aclId) {
        AclService aclService = this.aclService();
        Optional<ManagedAcl> macl = aclService.getAcl(aclId);
        if (macl.isEmpty()) {
            return RestUtil.R.notFound();
        }
        try {
            Option aclOpt = Option.some((Object)macl.get().getAcl());
            Optional mediaPackage = this.getAssetManager().getMediaPackage(episodeId);
            if (mediaPackage.isPresent()) {
                final MediaPackage episodeSvcMp = (MediaPackage)mediaPackage.get();
                aclOpt.fold((Option.Match)new Option.EMatch<AccessControlList>(){

                    public void esome(AccessControlList acl) {
                        try {
                            MediaPackage mp = (MediaPackage)AbstractAclServiceRestEndpoint.this.getAuthorizationService().setAcl(episodeSvcMp, AclScope.Episode, acl).getA();
                            AbstractAclServiceRestEndpoint.this.getAssetManager().takeSnapshot(mp);
                        }
                        catch (MediaPackageException e) {
                            logger.error("Error getting ACL from media package", (Throwable)e);
                        }
                    }

                    public void enone() {
                        MediaPackage mp = AbstractAclServiceRestEndpoint.this.getAuthorizationService().removeAcl(episodeSvcMp, AclScope.Episode);
                        AbstractAclServiceRestEndpoint.this.getAssetManager().takeSnapshot(mp);
                    }
                });
                return RestUtil.R.ok();
            }
            return RestUtil.R.notFound();
        }
        catch (Exception e) {
            logger.error("Error applying acl to episode {}", (Object)episodeId);
            return RestUtil.R.serverError();
        }
    }

    private AclService aclService() {
        return this.getAclServiceFactory().serviceFor(this.getSecurityService().getOrganization());
    }
}

