/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.impl.persistence;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;

@Entity(name="ManagedAcl")
@Table(name="oc_acl_managed_acl", uniqueConstraints={@UniqueConstraint(columnNames={"name", "organization_id"})})
@NamedQueries(value={@NamedQuery(name="ManagedAcl.findByIdAndOrg", query="SELECT e FROM ManagedAcl e WHERE e.id = :id AND e.organizationId = :organization"), @NamedQuery(name="ManagedAcl.findAllByOrg", query="SELECT e FROM ManagedAcl e WHERE e.organizationId = :organization"), @NamedQuery(name="ManagedAcl.deleteByIdAndOrg", query="DELETE FROM ManagedAcl e WHERE e.id = :id AND e.organizationId = :organization")})
public class ManagedAclEntity
implements ManagedAcl {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="pk")
    private Long id;
    @Column(name="name", nullable=false, length=128)
    private String name;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="acl", nullable=false)
    private String acl;
    @Transient
    private AccessControlList parsedAcl;
    @Column(name="organization_id", nullable=false, length=128)
    private String organizationId;

    ManagedAclEntity update(String name, AccessControlList acl, String orgId) {
        this.acl = AccessControlParser.toJsonSilent((AccessControlList)acl);
        this.name = name;
        this.organizationId = orgId;
        return this;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AccessControlList getAcl() {
        if (this.parsedAcl == null) {
            this.parsedAcl = AccessControlParser.parseAclSilent((String)this.acl);
        }
        return this.parsedAcl;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static Function<EntityManager, Optional<ManagedAclEntity>> findByIdAndOrgQuery(String orgId, Long id) {
        return Queries.namedQuery.findOpt("ManagedAcl.findByIdAndOrg", ManagedAclEntity.class, new Object[]{Pair.of((Object)"id", (Object)id), Pair.of((Object)"organization", (Object)orgId)});
    }

    public static Function<EntityManager, Optional<ManagedAclEntity>> findByIdQuery(Long id) {
        return Queries.namedQuery.findByIdOpt(ManagedAclEntity.class, (Object)id);
    }

    public static Function<EntityManager, List<ManagedAclEntity>> findByOrgQuery(String orgId) {
        return Queries.namedQuery.findAll("ManagedAcl.findAllByOrg", ManagedAclEntity.class, new Object[]{Pair.of((Object)"organization", (Object)orgId)});
    }

    public static Function<EntityManager, Integer> deleteByIdAndOrgQuery(String orgId, Long id) {
        return Queries.namedQuery.delete("ManagedAcl.deleteByIdAndOrg", new Object[]{Pair.of((Object)"id", (Object)id), Pair.of((Object)"organization", (Object)orgId)});
    }
}

