/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.authorization.xacml.manager.impl.persistence;

import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.RollbackException;
import org.opencastproject.authorization.xacml.manager.api.ManagedAcl;
import org.opencastproject.authorization.xacml.manager.impl.AclDb;
import org.opencastproject.authorization.xacml.manager.impl.persistence.ManagedAclEntity;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.Organization;
import org.opencastproject.util.data.functions.Misc;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=JPA based ACL Provider"}, immediate=true, service={AclDb.class})
public final class JpaAclDb
implements AclDb {
    private DBSessionFactory dbSessionFactory;
    private EntityManagerFactory emf;
    private DBSession db;

    @Activate
    public void activate() {
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Deactivate
    public synchronized void deactivate() {
        this.db.close();
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.authorization.xacml.manager)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Override
    public List<ManagedAcl> getAcls(Organization org) {
        return Misc.widen((List)((List)this.db.execTx(ManagedAclEntity.findByOrgQuery(org.getId()))));
    }

    @Override
    public Optional<ManagedAcl> getAcl(Organization org, long id) {
        return Misc.widen((Optional)((Optional)this.db.execTx(ManagedAclEntity.findByIdAndOrgQuery(org.getId(), id))));
    }

    @Override
    public boolean updateAcl(ManagedAcl acl) {
        return (Boolean)this.db.execTx(em -> {
            Optional<ManagedAclEntity> e = ManagedAclEntity.findByIdAndOrgQuery(acl.getOrganizationId(), acl.getId()).apply((EntityManager)em);
            if (e.isEmpty()) {
                return false;
            }
            ManagedAclEntity updated = e.get().update(acl.getName(), acl.getAcl(), acl.getOrganizationId());
            em.merge((Object)updated);
            return true;
        });
    }

    @Override
    public Optional<ManagedAcl> createAcl(Organization org, AccessControlList acl, String name) {
        try {
            ManagedAclEntity e = new ManagedAclEntity().update(name, acl, org.getId());
            return (Optional)this.db.execTx(Queries.namedQuery.persistOpt((Object)e));
        }
        catch (RollbackException e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage().toLowerCase();
            if (message.contains("unique") || message.contains("duplicate")) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @Override
    public boolean deleteAcl(Organization org, long id) {
        return (Integer)this.db.execTx(ManagedAclEntity.deleteByIdAndOrgQuery(org.getId(), id)) > 0;
    }
}

