/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.assetmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Selects a mp version from the archive", "workflow.operation=select-version"})
public class SelectVersionWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SelectVersionWorkflowOperationHandler.class);
    public static final String OPT_VERSION = "version";
    public static final String OPT_NO_TAGS = "no-tags";
    public static final String OPT_SOURCE_FLAVORS = "source-flavors";
    private AssetManager assetManager;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage resultMp;
        block9: {
            WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
            if (currentOperation == null) {
                throw new WorkflowOperationException("Cannot get current workflow operation");
            }
            MediaPackage mp = workflowInstance.getMediaPackage();
            resultMp = null;
            String version = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_VERSION));
            String noTagsOpt = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_NO_TAGS));
            String sourceFlavorsOpt = StringUtils.trimToNull((String)currentOperation.getConfiguration(OPT_SOURCE_FLAVORS));
            if (version != null && (noTagsOpt != null || sourceFlavorsOpt != null)) {
                throw new WorkflowOperationException(String.format("Configuration error: '%s' cannot be used with '%s' and '%s'.", OPT_VERSION, OPT_NO_TAGS, OPT_SOURCE_FLAVORS));
            }
            if (version != null) {
                try {
                    Integer.parseInt(version);
                    resultMp = this.findVersion(mp.getIdentifier().toString(), version);
                    if (resultMp == null) {
                        throw new WorkflowOperationException(String.format("Could not find version %d of mp %s in the archive", mp.getIdentifier(), version));
                    }
                    break block9;
                }
                catch (NumberFormatException e) {
                    throw new WorkflowOperationException("Invalid version passed: " + version);
                }
            }
            if (noTagsOpt == null || sourceFlavorsOpt == null) {
                throw new WorkflowOperationException(String.format("Configuration error: both '%s' and '%s' must be passed.", OPT_NO_TAGS, OPT_SOURCE_FLAVORS));
            }
            List<String> noTags = Arrays.asList(noTagsOpt.split(","));
            SimpleElementSelector elementSelector = new SimpleElementSelector();
            for (MediaPackageElementFlavor flavor : this.parseFlavors(sourceFlavorsOpt)) {
                elementSelector.addFlavor(flavor);
            }
            resultMp = this.findVersionWithNoTags(mp.getIdentifier().toString(), elementSelector, noTags);
            if (resultMp == null) {
                throw new WorkflowOperationException(String.format("Could not find in the archive a version of mp %s that does not have the tags %s in element flavors %s", mp.getIdentifier(), noTagsOpt, sourceFlavorsOpt));
            }
        }
        return this.createResult(resultMp, WorkflowOperationResult.Action.CONTINUE);
    }

    private MediaPackage findVersion(String mpId, String version) throws WorkflowOperationException {
        AQueryBuilder q = this.assetManager.createQuery();
        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().eq((Object)((Version)this.assetManager.toVersion(version).get())))).run();
        if (r.getSize() == 0L) {
            throw new WorkflowOperationException(String.format("Media package %s, version %s not found in the archive.", mpId, version));
        }
        for (ARecord rec : r.getRecords()) {
            Optional optSnap = rec.getSnapshot();
            if (optSnap.isEmpty()) continue;
            logger.info("Replacing current media package with version: {}", (Object)version);
            return ((Snapshot)optSnap.get()).getMediaPackage();
        }
        return null;
    }

    private MediaPackage findVersionWithNoTags(String mpId, SimpleElementSelector elementSelector, Collection<String> tags) throws WorkflowOperationException {
        AQueryBuilder q = this.assetManager.createQuery();
        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId)).orderBy(q.version().desc()).run();
        if (r.getSize() == 0L) {
            throw new WorkflowOperationException("Media package not found in the archive: " + mpId);
        }
        block0: for (ARecord rec : r.getRecords()) {
            Optional optSnap = rec.getSnapshot();
            if (optSnap.isEmpty()) continue;
            Snapshot snapshot = (Snapshot)optSnap.get();
            MediaPackage mp = snapshot.getMediaPackage();
            for (MediaPackageElement el : elementSelector.select(mp, false)) {
                for (String t : el.getTags()) {
                    if (tags.contains(t)) continue block0;
                }
            }
            logger.info("Replacing current media package with version: {}", (Object)snapshot.getVersion());
            return mp;
        }
        return null;
    }

    private List<MediaPackageElementFlavor> parseFlavors(String flavorStr) {
        ArrayList<MediaPackageElementFlavor> flavors = new ArrayList<MediaPackageElementFlavor>();
        if (flavorStr != null) {
            for (String flavor : this.asList(flavorStr)) {
                flavors.add(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
        }
        return flavors;
    }

    @Reference
    public void setAssetManager(AssetManager service) {
        this.assetManager = service;
    }
}

