/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.assetmanager;

import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Asset Manager Delete Workflow Operation Handler", "workflow.operation=asset-delete"})
public class AssetManagerDeleteWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerDeleteWorkflowOperationHandler.class);
    private AssetManager assetManager;
    private static final String OPT_LAST_SNAPSHOT = "keep-last-snapshot";

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        String mpId = mediaPackage.getIdentifier().toString();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        boolean keepLastSnapshot = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(OPT_LAST_SNAPSHOT));
        try {
            long deleted;
            AQueryBuilder q = this.assetManager.createQuery();
            if (keepLastSnapshot) {
                logger.info("Deleting all but latest snapshot of episode {}", (Object)mpId);
                deleted = q.delete("default", q.snapshot()).where(q.mediaPackageId(mpId).and(q.version().isLatest().not())).run();
            } else {
                logger.info("Deleting all snapshots of episode {}", (Object)mpId);
                deleted = q.delete("default", q.snapshot()).where(q.mediaPackageId(mpId)).run();
            }
            logger.info("Successfully deleted {} version/s episode {} from the asset manager", (Object)deleted, (Object)mpId);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error deleting episode %s from the asset manager", mpId);
            throw new WorkflowOperationException(errorMessage, (Throwable)e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

