/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.assetmanager;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.impl.AssetManagerJobProducer;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Asset Manager Move Storage Operation Handler", "workflow.operation=move-storage"})
public class AssetManagerStorageMoveOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerStorageMoveOperationHandler.class);
    private static final String LATEST = "latest";
    private AssetManagerJobProducer tsamjp;
    private AssetManager assetManager;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Reference
    public void setJobProducer(AssetManagerJobProducer tsamjp) {
        this.tsamjp = tsamjp;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Job job;
        MediaPackage mp = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        logger.debug("Working on mediapackage {}", (Object)mp.getIdentifier().toString());
        String targetStorage = StringUtils.trimToNull((String)operation.getConfiguration("target-storage"));
        if (!this.tsamjp.datastoreExists(targetStorage)) {
            throw new WorkflowOperationException("Target storage type " + targetStorage + " is not available!");
        }
        logger.debug("Target storage set to {}", (Object)targetStorage);
        String targetVersion = StringUtils.trimToNull((String)operation.getConfiguration("target-version"));
        logger.debug("Target version set to {}", (Object)targetVersion);
        logger.debug("Beginning moving process");
        if (null != targetVersion) {
            Object version;
            try {
                version = targetVersion.equals(LATEST) ? this.getLatestVersion(mp.getIdentifier().toString()) : VersionImpl.mk((long)Long.parseLong(targetVersion));
            }
            catch (NumberFormatException e) {
                throw new WorkflowOperationException("Invalid version number", (Throwable)e);
            }
            job = this.tsamjp.moveByIdAndVersion((Version)version, mp.getIdentifier().toString(), targetStorage);
        } else {
            job = this.tsamjp.moveById(mp.getIdentifier().toString(), targetStorage);
        }
        if (this.waitForStatus(new Job[]{job}).isSuccess()) {
            return this.createResult(WorkflowOperationResult.Action.CONTINUE);
        }
        throw new WorkflowOperationException("Archive operation did not complete successfully!");
    }

    private Version getLatestVersion(String mediaPackageId) throws WorkflowOperationException {
        AQueryBuilder q = this.assetManager.createQuery();
        Optional result = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mediaPackageId).and(q.version().isLatest())).run().getRecords().stream().findFirst();
        if (result.isPresent()) {
            return ((Snapshot)((ARecord)result.get()).getSnapshot().get()).getVersion();
        }
        throw new WorkflowOperationException(String.format("No last version found for mpId: {}", mediaPackageId));
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

