/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.auth;

import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.StaticFileAuthorization;
import org.opencastproject.security.api.User;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=AssetManager based StaticFileAuthorization"}, immediate=true, service={StaticFileAuthorization.class})
public class AssetManagerStaticFileAuthorization
implements StaticFileAuthorization {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerStaticFileAuthorization.class);
    protected EntityManagerFactory entityManagerFactory;
    private SecurityService securityService;
    private Pattern staticFilePattern = Pattern.compile("^/([^/]+)/(?:api|internal)/([^/]+)/.*$");
    private boolean includeAPIRoles = false;
    private boolean includeCARoles = false;
    private boolean includeUIRoles = false;
    private final Predicate<String> roleFilter = name -> !(!this.includeAPIRoles && name.startsWith("ROLE_API_") || !this.includeCARoles && name.startsWith("ROLE_CAPTURE_AGENT_") || !this.includeUIRoles && name.startsWith("ROLE_UI_"));

    @Reference
    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        ArrayList newPattern = new ArrayList();
        Dictionary properties = cc != null ? cc.getProperties() : new Hashtable();
        this.staticFilePattern = Pattern.compile(Objects.toString(properties.get("pattern"), "^/([^/]+)/(?:api|internal)/([^/]+)/.*$"));
        this.includeAPIRoles = BooleanUtils.toBoolean((String)Objects.toString(properties.get("evaluate.roles.api"), null));
        this.includeCARoles = BooleanUtils.toBoolean((String)Objects.toString(properties.get("evaluate.roles.ca"), null));
        this.includeUIRoles = BooleanUtils.toBoolean((String)Objects.toString(properties.get("evaluate.roles.ui"), null));
        logger.info("Started authentication handler for {}", (Object)this.staticFilePattern);
    }

    public List<Pattern> getProtectedUrlPattern() {
        return Collections.singletonList(this.staticFilePattern);
    }

    public boolean verifyUrlAccess(String path) {
        User user = this.securityService.getUser();
        if (user.hasRole("ROLE_ADMIN")) {
            logger.debug("Allow access for admin `{}`", (Object)user);
            return true;
        }
        Matcher m = this.staticFilePattern.matcher(path);
        if (!m.matches()) {
            logger.debug("Path does not match pattern. Preventing access.");
            return false;
        }
        String organizationId = m.group(1);
        if (!this.securityService.getOrganization().getId().equals(organizationId)) {
            logger.debug("The user's organization does not match. Preventing access.");
            return false;
        }
        if (user.getRoles().size() == 0) {
            logger.debug("User has no roles allowing access.");
            return false;
        }
        List roles = user.getRoles().parallelStream().map(Role::getName).filter(this.roleFilter).map(role -> role + " | read").collect(Collectors.toList());
        StringBuilder properties = new StringBuilder("property_name = ?");
        for (int i = 1; i < roles.size(); ++i) {
            properties.append(" or property_name = ?");
        }
        String sql = "select count(1) from oc_assets_properties where val_bool = true and namespace = ? and mediapackage_id = ? and (" + properties + ")";
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        Query q = entityManager.createNativeQuery(sql);
        q.setParameter(1, (Object)"org.opencastproject.assetmanager.security");
        q.setParameter(2, (Object)m.group(2));
        for (int i = 0; i < roles.size(); ++i) {
            q.setParameter(i + 3, roles.get(i));
        }
        try {
            return (Long)q.getSingleResult() > 0L;
        }
        catch (PersistenceException e) {
            Throwable parent = e.getCause();
            if (parent instanceof RuntimeException && (parent = parent.getCause()) instanceof SQLSyntaxErrorException) {
                logger.info("Denying access to static file {}. {}", (Object)path, (Object)parent.getMessage());
                return false;
            }
            throw e;
        }
    }
}

