/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.query;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Fn2;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.SetB;
import com.entwinemedia.fn.fns.Booleans;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAQueryFactory;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.Order;
import org.opencastproject.assetmanager.impl.AssetManagerImpl;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.opencastproject.assetmanager.impl.persistence.EntityPaths;
import org.opencastproject.assetmanager.impl.persistence.PropertyDto;
import org.opencastproject.assetmanager.impl.persistence.QPropertyDto;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDto;
import org.opencastproject.assetmanager.impl.query.ARecordImpl;
import org.opencastproject.assetmanager.impl.query.AResultImpl;
import org.opencastproject.assetmanager.impl.query.Join;
import org.opencastproject.assetmanager.impl.query.JpaFns;
import org.opencastproject.assetmanager.impl.query.SelectQueryContribution;
import org.opencastproject.assetmanager.impl.query.SelectQueryContributor;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.data.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractASelectQuery
implements ASelectQuery,
SelectQueryContributor,
EntityPaths {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractASelectQuery.class);
    private final AbstractASelectQuery self = this;
    private final AssetManagerImpl am;
    private static Fn<Tuple, Opt<Property>> toProperty = new Fn<Tuple, Opt<Property>>(){

        public Opt<Property> apply(Tuple tuple) {
            PropertyDto dto = (PropertyDto)tuple.get((Expression)EntityPaths.Q_PROPERTY);
            return dto != null ? Opt.some((Object)dto.toProperty()) : Opt.none();
        }
    };

    public AbstractASelectQuery(AssetManagerImpl am) {
        this.am = am;
    }

    public ASelectQuery where(final org.opencastproject.assetmanager.api.query.Predicate predicate) {
        return new AbstractASelectQuery(this.am){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                SelectQueryContribution predicateContrib = RuntimeTypes.convert(predicate).contributeSelect(f);
                return AbstractASelectQuery.this.self.contributeSelect(f).addFrom(predicateContrib.from).addJoin(predicateContrib.join).andWhere(predicateContrib.where);
            }

            public String toString() {
                return "where " + String.valueOf(predicate);
            }
        };
    }

    public ASelectQuery page(final int offset, final int size) {
        return new AbstractASelectQuery(this.am){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return AbstractASelectQuery.this.self.contributeSelect(f).offset(offset).limit(size);
            }
        };
    }

    public ASelectQuery orderBy(final Order order) {
        return new AbstractASelectQuery(this.am){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                SelectQueryContribution orderContrib = RuntimeTypes.convert(order).contributeSelect(f);
                return AbstractASelectQuery.this.self.contributeSelect(f).addOrder(orderContrib.order).andWhere(orderContrib.where);
            }
        };
    }

    public AResult run() {
        return this.am.getDatabase().run(new Function<JPAQueryFactory, AResult>(){

            public AResult apply(JPAQueryFactory f) {
                return AbstractASelectQuery.this.run(f);
            }
        });
    }

    private AResult run(JPAQueryFactory f) {
        LinkedHashSet records;
        long startTime = System.nanoTime();
        SelectQueryContribution r = this.contributeSelect(f);
        boolean toFetchProperties = r.fetch.exists((Fn)Booleans.eq((Object)((Object)QPropertyDto.propertyDto)));
        JPAQuery q = f.query();
        Set from = Stream.mk((Object[])new EntityPath[]{Q_SNAPSHOT}).append(r.from).append(r.join.map(Join.getFrom)).toSet(SetB.MH);
        from.removeAll(r.join.map(Join.getJoin).toSet());
        q.from(JpaFns.toEntityPathArray(from));
        if (!r.join.isEmpty()) {
            Map joins = (Map)r.join.foldl(new HashMap(), new Fn2<Map<EntityPath<?>, BooleanExpression>, Join, Map<EntityPath<?>, BooleanExpression>>(this){

                public Map<EntityPath<?>, BooleanExpression> apply(Map<EntityPath<?>, BooleanExpression> sum, Join join) {
                    BooleanExpression existing = sum.get(join.join);
                    BooleanExpression combined = existing == null ? join.on : (existing.equals((Object)join.on) ? existing : existing.or((Predicate)join.on));
                    sum.put(join.join, combined);
                    return sum;
                }
            });
            for (Map.Entry j : joins.entrySet()) {
                ((JPAQuery)q.leftJoin((EntityPath)j.getKey())).on((Predicate)j.getValue());
            }
        }
        q.where((Predicate)r.where.orNull());
        for (Integer a : r.offset) {
            q.offset((long)a.intValue());
        }
        for (Integer a : r.limit) {
            q.limit((long)a.intValue());
        }
        for (Integer a : r.order) {
            q.orderBy((OrderSpecifier)a);
        }
        if (!toFetchProperties) {
            q.distinct();
        }
        List fetch = r.fetch.exists(MandatoryFetch.exists) ? r.fetch.toList() : r.fetch.append(MandatoryFetch.fetch).toList();
        this.am.getDatabase().logQuery(q);
        List result = q.list(JpaFns.toExpressionArray(fetch));
        logger.debug("Pure query ms " + (System.nanoTime() - startTime) / 1000000L);
        if (!toFetchProperties) {
            records = result.stream().map(tuple -> this.toARecord((Tuple)tuple, r)).map(record -> {
                Optional<Snapshot> snapshotOpt = record.getSnapshot();
                Snapshot snapshot = null;
                if (snapshotOpt.isPresent()) {
                    snapshot = this.am.getHttpAssetProvider().prepareForDelivery(snapshotOpt.get());
                }
                return new ARecordImpl(record.getSnapshotId(), record.getMediaPackageId(), record.getProperties(), snapshot);
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        } else {
            logger.trace("Fetched properties");
            Map propertiesPerMp = (Map)Stream.$((Iterable)result).bind(toProperty).foldl(new HashMap(), (Fn2)new Fn2<Map<String, Set<Property>>, Property, Map<String, Set<Property>>>(this){

                public Map<String, Set<Property>> apply(Map<String, Set<Property>> sum, Property p) {
                    String mpId = p.getId().getMediaPackageId();
                    Set<Property> props = sum.get(mpId);
                    if (props != null) {
                        props.add(p);
                    } else {
                        sum.put(mpId, SetB.MH.mk((Object[])new Property[]{p}));
                    }
                    return sum;
                }
            });
            Map<String, List<ARecordImpl>> distinctRecords = result.stream().map(tuple -> this.toARecord((Tuple)tuple, r)).collect(Collectors.groupingBy(record -> record.getMediaPackageId()));
            records = distinctRecords.values().stream().flatMap(Collection::stream).map(record -> {
                Set properties = (Set)propertiesPerMp.get(record.getMediaPackageId());
                ArrayList<Property> p = properties != null ? properties.stream().collect(Collectors.toList()) : new ArrayList<Property>();
                Snapshot snapshot = null;
                Optional<Snapshot> snapshotOpt = record.getSnapshot();
                if (snapshotOpt.isPresent()) {
                    snapshot = this.am.getHttpAssetProvider().prepareForDelivery(snapshotOpt.get());
                }
                return new ARecordImpl(record.getSnapshotId(), record.getMediaPackageId(), p, snapshot);
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        long searchTime = (System.nanoTime() - startTime) / 1000000L;
        logger.debug("Complete query ms " + searchTime);
        LinkedHashSet<ARecord> narrowRecords = new LinkedHashSet<ARecord>();
        for (ARecordImpl recordImpl : records) {
            narrowRecords.add(recordImpl);
        }
        return new AResultImpl(narrowRecords, narrowRecords.size(), ((Integer)r.offset.getOr((Object)0)).intValue(), ((Integer)r.limit.getOr((Object)-1)).intValue(), searchTime);
    }

    private Fn<Tuple, ARecordImpl> toARecord(final SelectQueryContribution c) {
        return new Fn<Tuple, ARecordImpl>(this){

            public ARecordImpl apply(Tuple tuple) {
                String mediaPackageId;
                long id;
                SnapshotDto snapshotDto = null;
                if (c.fetch.exists((Fn)Booleans.eq((Object)((Object)EntityPaths.Q_SNAPSHOT)))) {
                    snapshotDto = (SnapshotDto)RequireUtil.notNull((Object)((SnapshotDto)tuple.get((Expression)EntityPaths.Q_SNAPSHOT)), (String)"[BUG] snapshot table data");
                    id = snapshotDto.getId();
                    mediaPackageId = snapshotDto.getMediaPackageId();
                } else {
                    id = (Long)RequireUtil.notNull((Object)((Long)tuple.get(EntityPaths.Q_SNAPSHOT.id)), (String)"[BUG] snapshot table id");
                    mediaPackageId = (String)RequireUtil.notNull((Object)((String)tuple.get((Expression)EntityPaths.Q_SNAPSHOT.mediaPackageId)), (String)"[BUG] snapshot table media package id");
                }
                return new ARecordImpl(id, mediaPackageId, new ArrayList<Property>(), snapshotDto);
            }
        };
    }

    private ARecordImpl toARecord(Tuple tuple, SelectQueryContribution c) {
        String mediaPackageId;
        long id;
        SnapshotDto snapshotDto = null;
        if (c.fetch.exists((Fn)Booleans.eq((Object)((Object)Q_SNAPSHOT)))) {
            snapshotDto = (SnapshotDto)RequireUtil.notNull((Object)((SnapshotDto)tuple.get((Expression)Q_SNAPSHOT)), (String)"[BUG] snapshot table data");
            id = snapshotDto.getId();
            mediaPackageId = snapshotDto.getMediaPackageId();
        } else {
            id = (Long)RequireUtil.notNull((Object)((Long)tuple.get(AbstractASelectQuery.Q_SNAPSHOT.id)), (String)"[BUG] snapshot table id");
            mediaPackageId = (String)RequireUtil.notNull((Object)((String)tuple.get((Expression)AbstractASelectQuery.Q_SNAPSHOT.mediaPackageId)), (String)"[BUG] snapshot table media package id");
        }
        return new ARecordImpl(id, mediaPackageId, new ArrayList<Property>(), snapshotDto);
    }

    private static <A> Stream<A> vary(Stream<? extends A> a) {
        return a;
    }

    private static <A> int sizeOf(Stream<A> stream) {
        int count = 0;
        for (Object ignore : stream) {
            ++count;
        }
        return count;
    }

    private static final class MandatoryFetch {
        static final Fn<Expression<?>, Boolean> exists = Booleans.eq((Object)((Object)EntityPaths.Q_SNAPSHOT)).or((Fn)Booleans.eq((Object)EntityPaths.Q_SNAPSHOT.mediaPackageId)).or((Fn)Booleans.eq(EntityPaths.Q_SNAPSHOT.id));
        static final Stream<Expression<?>> fetch = Stream.mk((Object[])new Expression[]{EntityPaths.Q_SNAPSHOT.mediaPackageId, EntityPaths.Q_SNAPSHOT.id});

        private MandatoryFetch() {
        }
    }
}

