/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.persistence;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.UniqueConstraint;
import org.eclipse.persistence.annotations.CascadeOnDelete;
import org.opencastproject.assetmanager.api.Availability;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.impl.SnapshotImpl;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.assetmanager.impl.persistence.AssetDto;
import org.opencastproject.assetmanager.impl.persistence.Conversions;
import org.opencastproject.assetmanager.impl.persistence.Database;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.util.data.functions.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="Snapshot")
@Table(name="oc_assets_snapshot", indexes={@Index(name="IX_oc_assets_snapshot_archival_date", columnList="archival_date"), @Index(name="IX_oc_assets_snapshot_mediapackage_id", columnList="mediapackage_id"), @Index(name="IX_oc_assets_snapshot_organization_id", columnList="organization_id"), @Index(name="IX_oc_assets_snapshot_owner", columnList="owner"), @Index(name="IX_oc_assets_snapshot_series", columnList="series_id, version")}, uniqueConstraints={@UniqueConstraint(columnNames={"mediapackage_id", "version"})})
@NamedQueries(value={@NamedQuery(name="Snapshot.countOrgEvents", query="select count(distinct s.mediaPackageId) from Snapshot s where s.organizationId = :organizationId"), @NamedQuery(name="Snapshot.countEvents", query="select count(distinct s.mediaPackageId) from Snapshot s"), @NamedQuery(name="Snapshot.countByMediaPackage", query="select count(s) from Snapshot s where s.mediaPackageId = :mediaPackageId"), @NamedQuery(name="Snapshot.countByMediaPackageAndOrg", query="select count(s) from Snapshot s where s.mediaPackageId = :mediaPackageId and s.organizationId = :organizationId")})
@TableGenerator(name="seq_oc_assets_snapshot", initialValue=0, allocationSize=50)
public class SnapshotDto {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotDto.class);
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="seq_oc_assets_snapshot")
    private Long id;
    @Column(name="mediapackage_id", length=128, nullable=false)
    private String mediaPackageId;
    @Column(name="version", nullable=false)
    private Long version;
    @Column(name="series_id", length=128)
    private String seriesId;
    @Column(name="organization_id", length=128, nullable=false)
    private String organizationId;
    @Column(name="archival_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date archivalDate;
    @Column(name="availability", nullable=false, length=32)
    private String availability;
    @Column(name="storage_id", nullable=false, length=256)
    private String storageId;
    @Column(name="owner", nullable=false, length=256)
    private String owner;
    @Lob
    @Column(name="mediapackage_xml", length=65535, nullable=false)
    private String mediaPackageXml;
    @CascadeOnDelete
    @OneToMany(targetEntity=AssetDto.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="snapshot")
    private Set<AssetDto> assets;

    public static SnapshotDto mk(MediaPackage mediaPackage, VersionImpl version, String organization, Date archivalDate, Availability availability, String storageId, String owner) {
        try {
            SnapshotDto dto = new SnapshotDto();
            dto.mediaPackageId = mediaPackage.getIdentifier().toString();
            dto.version = version.value();
            dto.seriesId = mediaPackage.getSeries();
            dto.organizationId = organization;
            dto.archivalDate = archivalDate;
            dto.mediaPackageXml = MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
            dto.availability = availability.name();
            dto.storageId = storageId;
            dto.owner = owner;
            return dto;
        }
        catch (Exception e) {
            return (SnapshotDto)Functions.chuck((Throwable)e);
        }
    }

    public static SnapshotDto mk(Snapshot snapshot) {
        try {
            return SnapshotDto.mk(snapshot.getMediaPackage(), VersionImpl.mk(Long.parseLong(snapshot.getVersion().toString())), snapshot.getOrganizationId(), snapshot.getArchivalDate(), snapshot.getAvailability(), snapshot.getStorageId(), snapshot.getOwner());
        }
        catch (Exception e) {
            return (SnapshotDto)Functions.chuck((Throwable)e);
        }
    }

    public Long getId() {
        return Database.insidePersistenceContextCheck(this.id);
    }

    public VersionImpl getVersion() {
        return Conversions.toVersion(this.version);
    }

    public String getMediaPackageId() {
        return this.mediaPackageId;
    }

    public String getStorageId() {
        return this.storageId;
    }

    void setAvailability(Availability a) {
        this.availability = a.name();
    }

    void setStorageId(String id) {
        this.storageId = id;
    }

    public boolean addAsset(AssetDto asset) {
        return this.assets.add(asset);
    }

    public boolean removeAsset(AssetDto asset) {
        return this.assets.remove(asset);
    }

    public Snapshot toSnapshot() {
        MediaPackage mediaPackage = Conversions.toMediaPackage(this.mediaPackageXml);
        for (MediaPackageElement element : mediaPackage.getElements()) {
            if (Arrays.asList(element.getTags()).contains("archive")) continue;
            logger.debug("Adding additional tag `archive` to element {} retrieved from asset manager", (Object)element);
            element.addTag("archive");
        }
        return new SnapshotImpl(this.id, Conversions.toVersion(this.version), this.organizationId, this.archivalDate, Availability.valueOf((String)this.availability), this.storageId, this.owner, mediaPackage);
    }

    public static Function<EntityManager, Boolean> existsQuery(String mediaPackageId) {
        return SnapshotDto.existsQuery(mediaPackageId, null);
    }

    public static Function<EntityManager, Boolean> existsQuery(String mediaPackageId, String organization) {
        return em -> {
            TypedQuery query = organization == null ? em.createNamedQuery("Snapshot.countByMediaPackage", Long.class).setParameter("mediaPackageId", (Object)mediaPackageId) : em.createNamedQuery("Snapshot.countByMediaPackageAndOrg", Long.class).setParameter("mediaPackageId", (Object)mediaPackageId).setParameter("organizationId", (Object)organization);
            logger.debug("Executing query {}", (Object)query);
            return (Long)query.getSingleResult() > 0L;
        };
    }

    public static Function<EntityManager, Long> countEventsQuery(String organization) {
        return em -> {
            TypedQuery query = null != organization ? em.createNamedQuery("Snapshot.countOrgEvents", Long.class).setParameter("organizationId", (Object)organization) : em.createNamedQuery("Snapshot.countEvents", Long.class);
            logger.debug("Executing query {}", (Object)query);
            return (Long)query.getSingleResult();
        };
    }
}

