/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.endpoint;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.assetmanager.impl.AssetManagerJobProducer;
import org.opencastproject.assetmanager.impl.VersionImpl;
import org.opencastproject.assetmanager.impl.endpoint.AbstractAssetManagerRestEndpoint;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;

public abstract class AbstractTieredStorageAssetManagerRestEndpoint
extends AbstractAssetManagerRestEndpoint {
    public static final String SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected AssetManagerJobProducer tsamjp = null;
    protected ServiceRegistry serviceRegistry = null;

    public void setJobProducer(AssetManagerJobProducer producer) {
        this.tsamjp = producer;
    }

    public JobProducer getService() {
        return this.tsamjp;
    }

    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @POST
    @Path(value="moveById")
    @Produces(value={"text/xml"})
    @RestQuery(name="moveById", description="Move a mediapackage based on its ID.", restParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The mediapackage ID to move."), @RestParameter(name="target", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The target storage to move the mediapackage to.")}, responses={@RestResponse(description="The job created to move the snapshot.", responseCode=200), @RestResponse(description="Invalid parameters, and the job was not created", responseCode=400), @RestResponse(description="There has been an internal error, and the job was not created", responseCode=500)}, returnDescription="The Job created")
    public Response moveById(@FormParam(value="id") String id, @FormParam(value="target") String target) {
        String mpid = StringUtils.trimToNull((String)id);
        if (null == mpid) {
            return RestUtil.R.badRequest((String)("Invalid mediapackage ID: " + mpid));
        }
        String trimmedTarget = StringUtils.trimToNull((String)target);
        if (null == trimmedTarget) {
            return RestUtil.R.badRequest((String)("Invalid target store ID: " + trimmedTarget));
        }
        if (!this.tsamjp.datastoreExists(trimmedTarget)) {
            return RestUtil.R.badRequest((String)("Target store " + trimmedTarget + " not found"));
        }
        try {
            Job j = this.tsamjp.moveById(mpid, trimmedTarget);
            return Response.ok((Object)new JaxbJob(j)).build();
        }
        catch (Exception e) {
            return AbstractTieredStorageAssetManagerRestEndpoint.handleException(e);
        }
    }

    @POST
    @Path(value="moveByIdAndVersion")
    @Produces(value={"text/xml"})
    @RestQuery(name="moveByIdAndVersion", description="Move a mediapackage based on its ID and version.", restParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The mediapackage ID to move."), @RestParameter(name="version", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The version to move."), @RestParameter(name="target", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The target storage to move the mediapackage to.")}, responses={@RestResponse(description="The job created to move the snapshot.", responseCode=200), @RestResponse(description="Invalid parameters, and the job was not created", responseCode=400), @RestResponse(description="There has been an internal error, and the job was not created", responseCode=500)}, returnDescription="The Job created")
    public Response moveByIdAndVersion(@FormParam(value="id") String id, @FormParam(value="version") String version, @FormParam(value="target") String target) {
        VersionImpl v;
        String mpid = StringUtils.trimToNull((String)id);
        if (null == mpid) {
            return RestUtil.R.badRequest((String)("Invalid mediapackage ID: " + mpid));
        }
        try {
            Long versionNumber = Long.parseLong(version);
            v = new VersionImpl(versionNumber);
        }
        catch (NumberFormatException e) {
            return RestUtil.R.badRequest((String)"Invalid version number format");
        }
        String trimmedTarget = StringUtils.trimToNull((String)target);
        if (null == trimmedTarget) {
            return RestUtil.R.badRequest((String)("Invalid target store ID: " + trimmedTarget));
        }
        if (!this.tsamjp.datastoreExists(trimmedTarget)) {
            return RestUtil.R.badRequest((String)("Target store " + trimmedTarget + " not found"));
        }
        try {
            Job j = this.tsamjp.moveByIdAndVersion(v, mpid, trimmedTarget);
            return RestUtil.R.ok((Object)new JaxbJob(j));
        }
        catch (Exception e) {
            return AbstractTieredStorageAssetManagerRestEndpoint.handleException(e);
        }
    }

    @POST
    @Path(value="moveByDate")
    @Produces(value={"text/xml"})
    @RestQuery(name="moveByDate", description="Move all snapshots between two dates.", restParameters={@RestParameter(name="start", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The start date, in the format yyyy-MM-dd'T'HH:mm:ss'Z'."), @RestParameter(name="end", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The end date, in the format yyyy-MM-dd'T'HH:mm:ss'Z'."), @RestParameter(name="target", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The target storage to move the mediapackage to.")}, responses={@RestResponse(description="The job created to move the snapshots.", responseCode=200), @RestResponse(description="Invalid parameters, and the job was not created", responseCode=400), @RestResponse(description="There has been an internal error, and the job was not created", responseCode=500)}, returnDescription="The Job created")
    public Response moveByDate(@FormParam(value="start") String startString, @FormParam(value="end") String endString, @FormParam(value="target") String target) {
        Date end;
        Date start;
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_FORMAT);
        try {
            start = sdf.parse(startString);
            end = sdf.parse(endString);
        }
        catch (ParseException e) {
            return RestUtil.R.badRequest((String)"Invalid start or end date format");
        }
        if (end.before(start)) {
            return RestUtil.R.badRequest((String)("Start date " + String.valueOf(start) + " must be before end date " + String.valueOf(end)));
        }
        String trimmedTarget = StringUtils.trimToNull((String)target);
        if (null == trimmedTarget) {
            return RestUtil.R.badRequest((String)("Invalid target store ID: " + trimmedTarget));
        }
        if (!this.tsamjp.datastoreExists(trimmedTarget)) {
            return RestUtil.R.badRequest((String)("Target store " + trimmedTarget + " not found"));
        }
        try {
            Job j = this.tsamjp.moveByDate(start, end, trimmedTarget);
            return RestUtil.R.ok((Object)new JaxbJob(j));
        }
        catch (Exception e) {
            return AbstractTieredStorageAssetManagerRestEndpoint.handleException(e);
        }
    }

    @POST
    @Path(value="moveByIdAndDate")
    @Produces(value={"text/xml"})
    @RestQuery(name="moveByIdAndDate", description="Move all snapshots for a given mediapackage taken between two dates.", restParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The mediapackage ID to move."), @RestParameter(name="start", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The start date, in the format yyyy-MM-dd'T'HH:mm:ss'Z'."), @RestParameter(name="end", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The end date, in the format yyyy-MM-dd'T'HH:mm:ss'Z'."), @RestParameter(name="target", isRequired=true, type=RestParameter.Type.STRING, defaultValue="", description="The target storage to move the mediapackage to.")}, responses={@RestResponse(description="The job created to move the snapshots.", responseCode=200), @RestResponse(description="Invalid parameters, and the job was not created", responseCode=400), @RestResponse(description="There has been an internal error, and the job was not created", responseCode=500)}, returnDescription="The Job created")
    public Response moveByIdAndDate(@FormParam(value="id") String id, @FormParam(value="start") String startString, @FormParam(value="end") String endString, @FormParam(value="target") String target) {
        Date end;
        Date start;
        SimpleDateFormat sdf = new SimpleDateFormat(SDF_FORMAT);
        String mpid = StringUtils.trimToNull((String)id);
        if (null == mpid) {
            return RestUtil.R.badRequest((String)("Invalid mediapackage ID: " + mpid));
        }
        try {
            start = sdf.parse(startString);
            end = sdf.parse(endString);
        }
        catch (ParseException e) {
            return RestUtil.R.badRequest((String)"Invalid start or end date format");
        }
        if (end.before(start)) {
            return RestUtil.R.badRequest((String)("Start date " + String.valueOf(start) + " must be before end date " + String.valueOf(end)));
        }
        String trimmedTarget = StringUtils.trimToNull((String)target);
        if (null == trimmedTarget) {
            return RestUtil.R.badRequest((String)("Invalid target store ID: " + trimmedTarget));
        }
        if (!this.tsamjp.datastoreExists(trimmedTarget)) {
            return RestUtil.R.badRequest((String)("Target store " + trimmedTarget + " not found"));
        }
        try {
            Job j = this.tsamjp.moveByIdAndDate(mpid, start, end, trimmedTarget);
            return RestUtil.R.ok((Object)new JaxbJob(j));
        }
        catch (Exception e) {
            return AbstractTieredStorageAssetManagerRestEndpoint.handleException(e);
        }
    }
}

