/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl;

import com.entwinemedia.fn.Fn;
import java.util.Optional;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.data.Either;

public final class Protected<A> {
    private final Either<UnauthorizedException, A> wrapped;

    public Protected(Either<UnauthorizedException, A> wrapped) {
        this.wrapped = wrapped;
    }

    public static <A> Protected<A> granted(A a) {
        return new Protected<A>(Either.right(a));
    }

    public static <A> Protected<A> rejected(UnauthorizedException e) {
        return new Protected<A>(Either.left((Object)e));
    }

    public Either<UnauthorizedException, A> get() {
        return this.wrapped;
    }

    public boolean isGranted() {
        return this.wrapped.isRight();
    }

    public A getGranted() {
        return (A)this.wrapped.right().value();
    }

    public boolean isRejected() {
        return this.wrapped.isLeft();
    }

    public UnauthorizedException getRejected() {
        return (UnauthorizedException)this.wrapped.left().value();
    }

    public Optional<A> getGrantedOpt() {
        return this.wrapped.right().toOptional();
    }

    public static <A> Fn<Protected<A>, Optional<A>> getGrantedOptFn() {
        return new Fn<Protected<A>, Optional<A>>(){

            public Optional<A> apply(Protected<A> p) {
                return p.getGrantedOpt();
            }
        };
    }

    public static <A> Fn<Protected<A>, Either<UnauthorizedException, A>> getFn() {
        return new Fn<Protected<A>, Either<UnauthorizedException, A>>(){

            public Either<UnauthorizedException, A> apply(Protected<A> p) {
                return p.get();
            }
        };
    }
}

