/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.query;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.mysema.query.jpa.impl.JPAQueryFactory;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.ComparableExpressionBase;
import java.util.Date;
import javax.annotation.Nonnull;
import org.opencastproject.assetmanager.api.Availability;
import org.opencastproject.assetmanager.api.PropertyName;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.query.ADeleteQuery;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ASelectQuery;
import org.opencastproject.assetmanager.api.query.Field;
import org.opencastproject.assetmanager.api.query.PropertyField;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.api.query.VersionField;
import org.opencastproject.assetmanager.impl.AssetManagerImpl;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.opencastproject.assetmanager.impl.persistence.EntityPaths;
import org.opencastproject.assetmanager.impl.persistence.QPropertyDto;
import org.opencastproject.assetmanager.impl.persistence.QSnapshotDto;
import org.opencastproject.assetmanager.impl.query.AbstractADeleteQuery;
import org.opencastproject.assetmanager.impl.query.AbstractASelectQuery;
import org.opencastproject.assetmanager.impl.query.AbstractPredicate;
import org.opencastproject.assetmanager.impl.query.AbstractTarget;
import org.opencastproject.assetmanager.impl.query.DeleteQueryContribution;
import org.opencastproject.assetmanager.impl.query.Join;
import org.opencastproject.assetmanager.impl.query.JpaFns;
import org.opencastproject.assetmanager.impl.query.PropertyFieldImpl;
import org.opencastproject.assetmanager.impl.query.PropertyPredicates;
import org.opencastproject.assetmanager.impl.query.SelectQueryContribution;
import org.opencastproject.assetmanager.impl.query.SimpleSnapshotField;
import org.opencastproject.assetmanager.impl.query.VersionFieldImpl;
import org.opencastproject.util.RequireUtil;

public final class AQueryBuilderImpl
implements AQueryBuilder,
EntityPaths {
    private static final Stream<QSnapshotDto> FROM_SNAPSHOT = $Q_SNAPSHOT;
    private final AssetManagerImpl am;

    public AQueryBuilderImpl(AssetManagerImpl am) {
        this.am = am;
    }

    private static Fn<Target, SelectQueryContribution> contributeSelect(final JPAQueryFactory f) {
        return new Fn<Target, SelectQueryContribution>(){

            public SelectQueryContribution apply(Target t) {
                return RuntimeTypes.convert(t).contributeSelect(f);
            }
        };
    }

    public ASelectQuery select(final Target ... target) {
        return new AbstractASelectQuery(this.am){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                Stream c = Stream.$((Object[])target).map(AQueryBuilderImpl.contributeSelect(f));
                return SelectQueryContribution.mk().fetch(c.bind(SelectQueryContribution.getFetch)).from(c.bind(SelectQueryContribution.getFrom)).join((Stream<Join>)c.bind(SelectQueryContribution.getJoin)).where((Opt<BooleanExpression>)Opt.nul((Object)JpaFns.allOf((Iterable<BooleanExpression>)c.bind(SelectQueryContribution.getWhere))));
            }
        };
    }

    public ADeleteQuery delete(String owner, final Target target) {
        RequireUtil.notEmpty((String)owner, (String)"owner");
        return new AbstractADeleteQuery(this.am, owner){

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                DeleteQueryContribution c = RuntimeTypes.convert(target).contributeDelete(owner);
                return DeleteQueryContribution.mk().from(c.from).targetPredicate(c.targetPredicate).where(c.where);
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate mediaPackageIds(final String ... mpIds) {
        return new AbstractPredicate(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().from(FROM_SNAPSHOT).where(EntityPaths.Q_SNAPSHOT.mediaPackageId.in((Object[])mpIds));
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().where(new DeleteQueryContribution.Where(){

                    @Override
                    public BooleanExpression fromSnapshot(@Nonnull QSnapshotDto e) {
                        return e.mediaPackageId.in((Object[])mpIds);
                    }

                    @Override
                    public BooleanExpression fromProperty(@Nonnull QPropertyDto p) {
                        return p.mediaPackageId.in((Object[])mpIds);
                    }
                });
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate mediaPackageId(final String mpId) {
        return new AbstractPredicate(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().from(FROM_SNAPSHOT).where(EntityPaths.Q_SNAPSHOT.mediaPackageId.eq((Object)mpId));
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().where(new DeleteQueryContribution.Where(){

                    @Override
                    public BooleanExpression fromSnapshot(@Nonnull QSnapshotDto e) {
                        return e.mediaPackageId.eq((Object)mpId);
                    }

                    @Override
                    public BooleanExpression fromProperty(@Nonnull QPropertyDto p) {
                        return p.mediaPackageId.eq((Object)mpId);
                    }
                });
            }
        };
    }

    public Field<String> mediapackageId() {
        return new SimpleSnapshotField<String>((ComparableExpressionBase<String>)AQueryBuilderImpl.Q_SNAPSHOT.mediaPackageId);
    }

    public Field<String> seriesId() {
        return new SimpleSnapshotField<String>((ComparableExpressionBase<String>)AQueryBuilderImpl.Q_SNAPSHOT.seriesId);
    }

    public org.opencastproject.assetmanager.api.query.Predicate organizationId(final String orgId) {
        return new SnapshotBasedPredicate(){

            @Override
            protected BooleanExpression mkSnapshotFieldPredicate(QSnapshotDto e) {
                return e.organizationId.eq((Object)orgId);
            }
        };
    }

    public Field<String> organizationId() {
        return new SimpleSnapshotField<String>((ComparableExpressionBase<String>)AQueryBuilderImpl.Q_SNAPSHOT.organizationId);
    }

    public Field<String> owner() {
        return new SimpleSnapshotField<String>((ComparableExpressionBase<String>)AQueryBuilderImpl.Q_SNAPSHOT.owner);
    }

    public org.opencastproject.assetmanager.api.query.Predicate availability(final Availability availability) {
        return new SnapshotBasedPredicate(){

            @Override
            protected BooleanExpression mkSnapshotFieldPredicate(QSnapshotDto e) {
                return e.availability.eq((Object)availability.name());
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate storage(final String storage) {
        return new SnapshotBasedPredicate(){

            @Override
            protected BooleanExpression mkSnapshotFieldPredicate(QSnapshotDto e) {
                return e.storageId.eq((Object)storage);
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate hasPropertiesOf(final String namespace) {
        return new AbstractPredicate(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().where(PropertyPredicates.mkWhereSelect((Opt<String>)Opt.some((Object)namespace), (Opt<String>)PropertyPredicates.NONE, PropertyPredicates.NO_VALUE));
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().where(PropertyPredicates.mkWhereDelete((Opt<String>)Opt.some((Object)namespace), (Opt<String>)PropertyPredicates.NONE, PropertyPredicates.NO_VALUE));
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate hasProperties() {
        return new AbstractPredicate(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().where(PropertyPredicates.mkWhereSelect((Opt<String>)PropertyPredicates.NONE, (Opt<String>)PropertyPredicates.NONE, PropertyPredicates.NO_VALUE));
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().where(PropertyPredicates.mkWhereDelete((Opt<String>)PropertyPredicates.NONE, (Opt<String>)PropertyPredicates.NONE, PropertyPredicates.NO_VALUE));
            }
        };
    }

    public Field<Date> archived() {
        return new SimpleSnapshotField<Date>((ComparableExpressionBase<Date>)AQueryBuilderImpl.Q_SNAPSHOT.archivalDate);
    }

    public VersionField version() {
        return new VersionFieldImpl();
    }

    public <A> PropertyField<A> property(Value.ValueType<A> ev, String namespace, String name) {
        return new PropertyFieldImpl<A>(ev, PropertyName.mk((String)namespace, (String)name));
    }

    public <A> PropertyField<A> property(Value.ValueType<A> ev, PropertyName fqn) {
        return new PropertyFieldImpl<A>(ev, fqn);
    }

    public Target snapshot() {
        return new AbstractTarget(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().from(FROM_SNAPSHOT).fetch(EntityPaths.$Q_SNAPSHOT);
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().from(FROM_SNAPSHOT).where(EntityPaths.Q_SNAPSHOT.owner.eq((Object)owner));
            }
        };
    }

    public Target propertiesOf(String ... namespace) {
        return AQueryBuilderImpl.propertyTarget(namespace);
    }

    public Target properties(PropertyName ... fqn) {
        return AQueryBuilderImpl.propertyTarget(fqn);
    }

    public Target nothing() {
        return new AbstractTarget(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk();
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk();
            }
        };
    }

    public org.opencastproject.assetmanager.api.query.Predicate always() {
        return new AbstractPredicate(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                return SelectQueryContribution.mk().where(Expressions.booleanTemplate((String)"true = true", (Object[])new Object[0]));
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().where(Expressions.booleanTemplate((String)"true = true", (Object[])new Object[0]));
            }
        };
    }

    static Target propertyTarget(String ... namespace) {
        Stream onExpressions = Stream.$((Object[])namespace).map((Fn)new Fn<String, BooleanExpression>(){

            public BooleanExpression apply(String namespace) {
                return EntityPaths.Q_PROPERTY.namespace.eq((Object)namespace);
            }
        });
        return AQueryBuilderImpl.propertyTarget((Stream<BooleanExpression>)onExpressions);
    }

    static Target propertyTarget(PropertyName ... fqn) {
        Stream onExpressions = Stream.$((Object[])fqn).map((Fn)new Fn<PropertyName, BooleanExpression>(){

            public BooleanExpression apply(PropertyName name) {
                return EntityPaths.Q_PROPERTY.namespace.eq((Object)name.getNamespace()).and((Predicate)EntityPaths.Q_PROPERTY.propertyName.eq((Object)name.getName()));
            }
        });
        return AQueryBuilderImpl.propertyTarget((Stream<BooleanExpression>)onExpressions);
    }

    private static Target propertyTarget(final Stream<BooleanExpression> onExpressions) {
        return new AbstractTarget(){

            @Override
            public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
                BooleanExpression on = EntityPaths.Q_PROPERTY.mediaPackageId.eq((Expression)EntityPaths.Q_SNAPSHOT.mediaPackageId).and((Predicate)JpaFns.anyOf((Iterable<BooleanExpression>)onExpressions));
                return SelectQueryContribution.mk().join((Stream<Join>)Stream.$((Object[])new Join[]{new Join((EntityPath<?>)EntityPaths.Q_SNAPSHOT, (EntityPath<?>)EntityPaths.Q_PROPERTY, on)})).fetch(EntityPaths.$Q_PROPERTY);
            }

            @Override
            public DeleteQueryContribution contributeDelete(String owner) {
                return DeleteQueryContribution.mk().from(EntityPaths.$Q_PROPERTY).targetPredicate(JpaFns.anyOf((Iterable<BooleanExpression>)onExpressions));
            }
        };
    }

    private static abstract class SnapshotBasedPredicate
    extends AbstractPredicate {
        private SnapshotBasedPredicate() {
        }

        @Override
        public SelectQueryContribution contributeSelect(JPAQueryFactory f) {
            return SelectQueryContribution.mk().from(FROM_SNAPSHOT).where(this.mkSnapshotFieldPredicate(EntityPaths.Q_SNAPSHOT));
        }

        @Override
        public DeleteQueryContribution contributeDelete(String owner) {
            return DeleteQueryContribution.mk().where(new DeleteQueryContribution.Where(){

                @Override
                public BooleanExpression fromSnapshot(@Nonnull QSnapshotDto e) {
                    return this.mkSnapshotFieldPredicate(e);
                }

                @Override
                public BooleanExpression fromProperty(@Nonnull QPropertyDto p) {
                    return this.mkSnapshotFieldPredicate(EntityPaths.Q_SNAPSHOT);
                }
            });
        }

        protected abstract BooleanExpression mkSnapshotFieldPredicate(QSnapshotDto var1);
    }
}

