/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.persistence;

import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="Property")
@Table(name="oc_assets_properties", indexes={@Index(name="IX_oc_assets_properties_val_date", columnList="val_date"), @Index(name="IX_oc_assets_properties_val_long", columnList="val_long"), @Index(name="IX_oc_assets_properties_val_string", columnList="val_string"), @Index(name="IX_oc_assets_properties_val_bool", columnList="val_bool"), @Index(name="IX_oc_assets_properties_mediapackage_id", columnList="mediapackage_id"), @Index(name="IX_oc_assets_properties_namespace", columnList="namespace"), @Index(name="IX_oc_assets_properties_property_name", columnList="property_name")})
@NamedQueries(value={@NamedQuery(name="Property.selectByMediaPackageAndNamespace", query="select p from Property p where p.mediaPackageId = :mediaPackageId and p.namespace = :namespace"), @NamedQuery(name="Property.delete", query="delete from Property p where p.mediaPackageId = :mediaPackageId"), @NamedQuery(name="Property.deleteByNamespace", query="delete from Property p where p.mediaPackageId = :mediaPackageId and p.namespace = :namespace")})
public class PropertyDto {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDto.class);
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="mediapackage_id", nullable=false, length=128)
    private String mediaPackageId;
    @Column(name="namespace", nullable=false, length=128)
    private String namespace;
    @Column(name="property_name", nullable=false, length=128)
    private String propertyName;
    @Column(name="val_string", nullable=true)
    private String stringValue;
    @Column(name="val_date", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateValue;
    @Column(name="val_long", nullable=true)
    private Long longValue;
    @Column(name="val_bool", nullable=true)
    private Boolean boolValue;

    public static PropertyDto mk(Property property) {
        PropertyDto dto = new PropertyDto();
        dto.mediaPackageId = property.getId().getMediaPackageId();
        dto.namespace = property.getId().getNamespace();
        dto.propertyName = property.getId().getName();
        PropertyDto.setValue(dto, property.getValue());
        return dto;
    }

    public Property toProperty() {
        PropertyId id = new PropertyId(this.mediaPackageId, this.namespace, this.propertyName);
        if (this.stringValue != null) {
            return new Property(id, (Value)Value.mk((String)this.stringValue));
        }
        if (this.dateValue != null) {
            return new Property(id, (Value)Value.mk((Date)this.dateValue));
        }
        if (this.longValue != null) {
            return new Property(id, (Value)Value.mk((Long)this.longValue));
        }
        if (this.boolValue != null) {
            return new Property(id, (Value)Value.mk((Boolean)this.boolValue));
        }
        throw new RuntimeException("Bug. At least one of the value columns must be non null.");
    }

    public PropertyDto update(Value value) {
        PropertyDto dto = new PropertyDto();
        dto.id = this.id;
        dto.mediaPackageId = this.mediaPackageId;
        dto.namespace = this.namespace;
        dto.propertyName = this.propertyName;
        PropertyDto.setValue(dto, value);
        return dto;
    }

    private static void setValue(final PropertyDto dto, Value value) {
        value.decompose((Function)new Function<String, Void>(){

            @Override
            public Void apply(String a) {
                dto.stringValue = a;
                return null;
            }
        }, (Function)new Function<Date, Void>(){

            @Override
            public Void apply(Date a) {
                dto.dateValue = a;
                return null;
            }
        }, (Function)new Function<Long, Void>(){

            @Override
            public Void apply(Long a) {
                dto.longValue = a;
                return null;
            }
        }, (Function)new Function<Boolean, Void>(){

            @Override
            public Void apply(Boolean a) {
                dto.boolValue = a;
                return null;
            }
        }, (Function)new Function<Version, Void>(){

            @Override
            public Void apply(Version a) {
                dto.longValue = RuntimeTypes.convert(a).value();
                return null;
            }
        });
    }

    public static Function<EntityManager, Integer> deleteQuery(String mediaPackageId) {
        return PropertyDto.deleteQuery(mediaPackageId, null);
    }

    public static Function<EntityManager, Integer> deleteQuery(String mediaPackageId, String namespace) {
        return em -> {
            TypedQuery query = namespace == null ? em.createNamedQuery("Property.delete", PropertyDto.class).setParameter("mediaPackageId", (Object)mediaPackageId) : em.createNamedQuery("Property.deleteByNamespace", PropertyDto.class).setParameter("mediaPackageId", (Object)mediaPackageId).setParameter("namespace", (Object)namespace);
            logger.debug("Executing query {}", (Object)query);
            return query.executeUpdate();
        };
    }

    public static Function<EntityManager, List<Property>> selectQuery(String mediaPackageId, String namespace) {
        return em -> {
            TypedQuery query = em.createNamedQuery("Property.selectByMediaPackageAndNamespace", PropertyDto.class).setParameter("mediaPackageId", (Object)mediaPackageId).setParameter("namespace", (Object)namespace);
            logger.debug("Executing query {}", (Object)query);
            return query.getResultList().parallelStream().map(PropertyDto::toProperty).collect(Collectors.toList());
        };
    }
}

