/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl.persistence;

import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.opencastproject.assetmanager.impl.persistence.Conversions;
import org.opencastproject.assetmanager.impl.persistence.SnapshotDto;
import org.opencastproject.util.MimeType;

@Entity(name="Asset")
@Table(name="oc_assets_asset", indexes={@Index(name="IX_oc_assets_asset_checksum", columnList="checksum"), @Index(name="IX_oc_assets_asset_mediapackage_element_id", columnList="mediapackage_element_id")})
@TableGenerator(name="seq_oc_assets_asset", initialValue=0, allocationSize=50)
public class AssetDto {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="seq_oc_assets_asset")
    @Column(name="id")
    private Long id;
    @ManyToOne(targetEntity=SnapshotDto.class)
    @JoinColumn(name="snapshot_id", referencedColumnName="id", nullable=false)
    private SnapshotDto snapshot;
    @Column(name="mediapackage_element_id", nullable=false, length=128)
    private String mediaPackageElementId;
    @Column(name="checksum", nullable=false, length=64)
    private String checksum;
    @Column(name="mime_type", nullable=true, length=255)
    private String mimeType;
    @Column(name="size", nullable=false)
    private Long size;
    @Column(name="storage_id", nullable=false, length=256)
    private String storageId;

    public static AssetDto mk(String mediaPackageElementId, SnapshotDto snapshot, String checksum, Optional<MimeType> mimeType, String storeageId, long size) {
        AssetDto dto = new AssetDto();
        dto.snapshot = snapshot;
        dto.mediaPackageElementId = mediaPackageElementId;
        dto.checksum = checksum;
        dto.mimeType = mimeType.isPresent() ? mimeType.get().toString() : null;
        dto.storageId = storeageId;
        dto.size = size;
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getMediaPackageElementId() {
        return this.mediaPackageElementId;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Optional<MimeType> getMimeType() {
        return Conversions.toMimeType(this.mimeType);
    }

    public Long getSize() {
        return this.size;
    }

    public String getStorageId() {
        return this.storageId;
    }

    void setStorageId(String storage) {
        this.storageId = storage;
    }

    public SnapshotDto getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(SnapshotDto snapshot) {
        this.snapshot = snapshot;
    }
}

