/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.impl;

import javax.annotation.ParametersAreNonnullByDefault;
import org.opencastproject.assetmanager.api.Version;
import org.opencastproject.assetmanager.impl.RuntimeTypes;
import org.opencastproject.util.EqualsUtil;

@ParametersAreNonnullByDefault
public final class VersionImpl
implements Version {
    private static final long serialVersionUID = 3060347920702655628L;
    public static final VersionImpl FIRST = VersionImpl.mk(0L);
    private final long nr;

    public VersionImpl(long nr) {
        this.nr = nr;
    }

    public static VersionImpl mk(long nr) {
        return new VersionImpl(nr);
    }

    public static VersionImpl mk(Version v) {
        return new VersionImpl(Long.parseLong(v.toString()));
    }

    public static VersionImpl next(long latest) {
        return new VersionImpl(latest + 1L);
    }

    public long value() {
        return this.nr;
    }

    public boolean isOlder(Version v) {
        return this.compareTo(v) < 0;
    }

    public boolean isYounger(Version v) {
        return this.compareTo(v) > 0;
    }

    public int compareTo(Version v) {
        return Long.compare(this.nr, RuntimeTypes.convert((Version)v).nr);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof VersionImpl && this.eqFields((VersionImpl)that);
    }

    private boolean eqFields(VersionImpl that) {
        return this.nr == that.nr;
    }

    public int hashCode() {
        return EqualsUtil.hash((Object[])new Object[]{this.nr});
    }

    public String toString() {
        return String.valueOf(this.nr);
    }
}

